/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.perlin.DensityGenerator;
import net.minecraft.core.world.generate.chunk.perlin.TerrainGeneratorLerp;
import net.minecraft.core.world.generate.chunk.perlin.nether.DensityGeneratorNether;
import net.minecraft.core.world.type.WorldType;

public class TerrainGeneratorNether
extends TerrainGeneratorLerp {
    private final DensityGenerator densityGenerator;
    private int lastX = -1;
    private int lastZ = -1;
    private Biome lastBiome = null;
    private Biome lastBiomeNegX = null;
    private Biome lastBiomePosX = null;
    private Biome lastBiomeNegZ = null;
    private Biome lastBiomePosZ = null;
    private Map<Biome, Integer> fluidLookup = new HashMap<Biome, Integer>();

    public TerrainGeneratorNether(World world) {
        super(world);
        this.densityGenerator = new DensityGeneratorNether(world);
        this.fluidLookup.put(Biomes.NETHER_NETHER, Blocks.FLUID_LAVA_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_VOLCANIC_ISLANDS, Blocks.FLUID_LAVA_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_SULFUR_POOLS, Blocks.FLUID_WATER_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_CRYSTAL_FOREST, Blocks.FLUID_WATER_STILL.id());
        this.fluidLookup.put(Biomes.NETHER_ASH_PLAINS, Blocks.OBSIDIAN.id());
        this.fluidLookup.put(Biomes.NETHER_BONEYARD, Blocks.COBBLE_NETHERRACK.id());
    }

    @Override
    protected int getBlockAt(Chunk chunk, int x, int y, int z, double density) {
        WorldType type;
        int halfHeight;
        if (this.lastX != x || this.lastZ != z) {
            this.lastBiome = chunk.getBlockBiome(x, 0, z);
            this.lastBiomeNegX = x - 1 < 0 ? this.lastBiome : chunk.getBlockBiome(x - 1, 0, z);
            this.lastBiomePosX = x + 1 >= 16 ? this.lastBiome : chunk.getBlockBiome(x + 1, 0, z);
            this.lastBiomeNegZ = z - 1 < 0 ? this.lastBiome : chunk.getBlockBiome(x, 0, z - 1);
            this.lastBiomePosZ = z + 1 >= 16 ? this.lastBiome : chunk.getBlockBiome(x, 0, z + 1);
        }
        if (y < (halfHeight = (type = this.world.getWorldType()).getMaxY() / 2)) {
            return 0;
        }
        if (y >= type.getMaxY() - this.rand.nextInt(5)) {
            return Blocks.BEDROCK.id();
        }
        if (y <= halfHeight + this.rand.nextInt(5)) {
            return Blocks.BEDROCK.id();
        }
        if (density > 0.0) {
            return type.getFillerBlockId();
        }
        if (y >= halfHeight && y < type.getOceanY()) {
            int biomeFluid = this.fluidLookup.getOrDefault(this.lastBiome, 0);
            int biomeFluidNegX = this.fluidLookup.getOrDefault(this.lastBiomeNegX, 0);
            int biomeFluidPosX = this.fluidLookup.getOrDefault(this.lastBiomePosX, 0);
            int biomeFluidNegZ = this.fluidLookup.getOrDefault(this.lastBiomeNegZ, 0);
            int biomeFluidPosZ = this.fluidLookup.getOrDefault(this.lastBiomePosZ, 0);
            if (biomeFluid == biomeFluidNegX && biomeFluid == biomeFluidPosX && biomeFluid == biomeFluidNegZ && biomeFluid == biomeFluidPosZ) {
                return biomeFluid;
            }
            return Blocks.OBSIDIAN.id();
        }
        return 0;
    }

    @Override
    public DensityGenerator getDensityGenerator() {
        return this.densityGenerator;
    }
}

