/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.ScaledResolution;
import net.minecraft.client.console.LogMessageReceiver;
import net.minecraft.client.console.shell.BindManager;
import net.minecraft.client.discord.RichPresenceHandlerThread;
import net.minecraft.client.entity.ClientSkinVariantList;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.entity.player.PlayerLocalMultiplayer;
import net.minecraft.client.enums.EnumGPUVendor;
import net.minecraft.client.gui.ExceptionPopupElement;
import net.minecraft.client.gui.MainMenuBackground;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenBadJavaArch;
import net.minecraft.client.gui.ScreenConflictWarning;
import net.minecraft.client.gui.ScreenConnecting;
import net.minecraft.client.gui.ScreenConsole;
import net.minecraft.client.gui.ScreenCreateWorld;
import net.minecraft.client.gui.ScreenGameOver;
import net.minecraft.client.gui.ScreenMainMenu;
import net.minecraft.client.gui.ScreenMissingMinecraft;
import net.minecraft.client.gui.ScreenOutOfMemory;
import net.minecraft.client.gui.ScreenPause;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.ScreenSelectWorld;
import net.minecraft.client.gui.ScreenSleepSP;
import net.minecraft.client.gui.ScreenStats;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.achievements.ScreenAchievements;
import net.minecraft.client.gui.chat.ScreenChat;
import net.minecraft.client.gui.chat.ScreenSleepMP;
import net.minecraft.client.gui.container.ScreenInventory;
import net.minecraft.client.gui.container.ScreenInventoryCreative;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.gui.subtitles.SubtitleTracker;
import net.minecraft.client.gui.toasts.GuiElementToastsHud;
import net.minecraft.client.holiday.Holidays;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.input.InputHandler;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.MouseInput;
import net.minecraft.client.input.PlayerInput;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.input.controller.Joystick;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.client.net.thread.ThreadDownloadResources;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.OptionInteger;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.player.controller.PlayerController;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.FallbackRenderer;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.LoadingScreenRenderer;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.ParticleEngine;
import net.minecraft.client.render.PostProcessingManager;
import net.minecraft.client.render.RenderGlobal;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelGrass;
import net.minecraft.client.render.camera.EntityCameraFirstPerson;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.client.render.shader.ShadersRenderer;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.terrain.TerrainRenderer;
import net.minecraft.client.render.terrain.TerrainRendererLegacy;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.client.render.window.GameWindow;
import net.minecraft.client.render.window.GameWindowGLFW;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.client.util.debug.DebugRender;
import net.minecraft.client.util.helper.ScreenShot;
import net.minecraft.client.util.helper.ScreenshotHelper;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.client.world.WorldClient;
import net.minecraft.client.world.chunk.provider.ChunkProviderStatic;
import net.minecraft.core.Global;
import net.minecraft.core.MinecraftAccessor;
import net.minecraft.core.MinecraftError;
import net.minecraft.core.MinecraftException;
import net.minecraft.core.Timer;
import net.minecraft.core.UnexpectedThrowable;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumOS;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.PlayerProfile;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.command.commands.CommandAchievement;
import net.minecraft.core.net.command.commands.CommandBiome;
import net.minecraft.core.net.command.commands.CommandChunk;
import net.minecraft.core.net.command.commands.CommandClear;
import net.minecraft.core.net.command.commands.CommandClone;
import net.minecraft.core.net.command.commands.CommandDamage;
import net.minecraft.core.net.command.commands.CommandFill;
import net.minecraft.core.net.command.commands.CommandGameMode;
import net.minecraft.core.net.command.commands.CommandGameRule;
import net.minecraft.core.net.command.commands.CommandGive;
import net.minecraft.core.net.command.commands.CommandHeal;
import net.minecraft.core.net.command.commands.CommandHelp;
import net.minecraft.core.net.command.commands.CommandKill;
import net.minecraft.core.net.command.commands.CommandMessage;
import net.minecraft.core.net.command.commands.CommandMobSpawning;
import net.minecraft.core.net.command.commands.CommandParticle;
import net.minecraft.core.net.command.commands.CommandPlace;
import net.minecraft.core.net.command.commands.CommandPlaySound;
import net.minecraft.core.net.command.commands.CommandSay;
import net.minecraft.core.net.command.commands.CommandSeed;
import net.minecraft.core.net.command.commands.CommandSetBlock;
import net.minecraft.core.net.command.commands.CommandSetSpawn;
import net.minecraft.core.net.command.commands.CommandSpawn;
import net.minecraft.core.net.command.commands.CommandSummon;
import net.minecraft.core.net.command.commands.CommandTeleport;
import net.minecraft.core.net.command.commands.CommandTellRaw;
import net.minecraft.core.net.command.commands.CommandTestFor;
import net.minecraft.core.net.command.commands.CommandTime;
import net.minecraft.core.net.command.commands.CommandWeather;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.player.Session;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.debug.Debug;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.LoggedPrintStream;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Time;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.PortalHandler;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.ISaveConverter;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveConverters;
import net.minecraft.core.world.save.SaveFormats;
import net.minecraft.core.world.save.mcregion.SaveFormat19134;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypeGroups;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class Minecraft
implements MinecraftAccessor {
    public static Logger LOGGER = LogUtils.getLogger();
    public static final String VERSION = Global.VERSION;
    public static final boolean isMultiplayerDisabled = false;
    public static boolean doPartialTick = true;
    public static EnumGPUVendor GPU_VENDOR = EnumGPUVendor.UNKNOWN;
    private static Minecraft INSTANCE;
    public PlayerController playerController;
    public boolean hasCrashed;
    public UnexpectedThrowable lastCrash;
    private final Timer timer;
    public WorldClient currentWorld;
    public RenderGlobal renderGlobal;
    public PlayerLocal thePlayer;
    public ICamera activeCamera;
    public ParticleEngine particleEngine;
    public Session session;
    public String worldPresetName = null;
    public String worldPresetSeed = null;
    public int worldPresetX;
    public int worldPresetY;
    public int worldPresetZ;
    public String minecraftUri;
    public boolean hideQuitButton;
    public volatile boolean isGamePaused;
    public TextureManager textureManager;
    public Font font;
    @Nullable
    public Screen currentScreen;
    public LoadingScreenRenderer loadingScreen;
    public WorldRenderer worldRenderer;
    public ThreadDownloadResources downloadResourcesThread;
    private int ticksRan;
    public GuiElementToastsHud guiToasts;
    public HudIngame hudIngame;
    public boolean skipRenderWorld;
    public HitResult objectMouseOver;
    public GameSettings gameSettings;
    public SoundEngine sndManager;
    public final SubtitleTracker subtitleTracker = new SubtitleTracker();
    public TexturePackList texturePackList;
    private File mcDataDir;
    private ISaveFormat saveFormat;
    public static int numRecordedFrameTimes;
    public static long hasPaidCheckTime;
    public StatsCounter statsCounter;
    private String serverName;
    private int serverPort;
    private static File minecraftDir;
    public volatile boolean running;
    public String debug;
    public String debugFPS;
    boolean isTakingScreenshot;
    public boolean inGameHasFocus;
    private int mouseTicksRan;
    public boolean isRaining;
    long systemTime;
    private int joinPlayerCounter;
    protected boolean toggleFlyPressed = false;
    protected long flyPressedTime = 0L;
    public float hotbarSwapAnimationProgress = 0.0f;
    public ScaledResolution resolution;
    public boolean fullbright = false;
    public Renderer renderer;
    @Nullable
    public ControllerInput controllerInput;
    public final MouseInput mouseInput = new MouseInput(this);
    public InputType inputType = InputType.KEYBOARD;
    public final ScreenshotHelper screenshotHelper = new ScreenshotHelper(this);
    private boolean f3Press = false;
    public Thread rpcThread = null;
    public PostProcessingManager ppm = new PostProcessingManager(this);
    private long lastFocusTime;
    public GameWindow gameWindow;
    public ClientSkinVariantList skinVariantList = new ClientSkinVariantList(this);
    public MainMenuBackground mainMenuBackground = new MainMenuBackground(this);
    @Nullable
    public Integer overrideWidth = null;
    @Nullable
    public Integer overrideHeight = null;
    private boolean gameStarted = false;
    private int mojrand = new Random(System.currentTimeMillis()).nextInt(200);
    public TerrainRenderer terrainRenderer;

    public Minecraft(GameWindow gameWindow, boolean test) {
        Global.accessor = this;
        this.hasCrashed = false;
        this.timer = new Timer(20.0f);
        this.session = null;
        this.hideQuitButton = false;
        this.isGamePaused = false;
        this.currentScreen = null;
        this.ticksRan = 0;
        this.skipRenderWorld = false;
        this.objectMouseOver = null;
        this.running = true;
        this.debug = "";
        this.isTakingScreenshot = false;
        this.inGameHasFocus = false;
        this.mouseTicksRan = 0;
        this.isRaining = false;
        this.systemTime = System.currentTimeMillis();
        this.joinPlayerCounter = 0;
        INSTANCE = this;
        if (test) {
            return;
        }
        this.gameWindow = gameWindow;
        this.resolution = new ScaledResolution(this.gameWindow);
        LoggedPrintStream.wrapStreams();
        this.loadingScreen = new LoadingScreenRenderer(this);
        this.guiToasts = new GuiElementToastsHud(this);
        this.sndManager = new SoundEngine();
        new Thread("Timer hack thread"){
            {
                this.setDaemon(true);
                this.start();
            }

            @Override
            public void run() {
                while (Minecraft.this.running) {
                    try {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
    }

    public static boolean isClientASteamDeck() {
        File vendor = new File("/sys/devices/virtual/dmi/id/board_vendor");
        File name = new File("/sys/devices/virtual/dmi/id/board_name");
        if (vendor.exists() && vendor.isFile() && name.exists() && name.isFile()) {
            try {
                List<String> vendorText = Files.readAllLines(vendor.toPath());
                List<String> nameText = Files.readAllLines(name.toPath());
                if (!vendorText.isEmpty() && vendorText.get(0).contains("Valve") && !nameText.isEmpty() && nameText.get(0).contains("Jupiter")) {
                    return true;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public void onMinecraftCrash(UnexpectedThrowable throwable) {
        if (!this.gameStarted) {
            this.running = false;
            LOGGER.error("An exception has occurred while trying to start the game!", throwable.exception);
            this.gameWindow.displayCrashReport(throwable, 1);
            this.hasCrashed = true;
            this.shutdownMinecraftApplet();
            return;
        }
        boolean disableCrashHandler = (Boolean)this.gameSettings.disableCrashHandler.value;
        if (disableCrashHandler) {
            this.running = false;
            LOGGER.error("An exception has occurred while trying to start the game!", throwable.exception);
            this.gameWindow.displayCrashReport(throwable, 1);
            this.hasCrashed = true;
            this.shutdownMinecraftApplet();
            return;
        }
        if (this.hasCrashed) {
            this.running = false;
            LOGGER.error("An exception has occurred while trying to start the game!", throwable.exception);
            this.gameWindow.displayCrashReport(throwable, 2);
            this.shutdownMinecraftApplet();
            return;
        }
        Debug.reset();
        LOGGER.error("Minecraft has crashed!", throwable.exception);
        this.hasCrashed = true;
        this.lastCrash = throwable;
        try {
            if (!this.gameStarted) {
                PopupScreen error = ExceptionPopupElement.createStartupError(throwable.exception, this);
                this.displayScreen(error);
                return;
            }
            if (throwable.exception instanceof RuntimeException) {
                this.changeWorld(null);
                ScreenMainMenu screenMainMenu = new ScreenMainMenu();
                this.displayScreen(screenMainMenu);
                PopupScreen error = ExceptionPopupElement.create(screenMainMenu, throwable.exception, this);
                this.displayScreen(error);
            } else {
                this.changeWorld(null);
                PopupScreen error = ExceptionPopupElement.createFatal(throwable.exception, this);
                this.displayScreen(error);
            }
        }
        catch (Throwable e) {
            this.onMinecraftCrash(new UnexpectedThrowable("Trying to display crash handler", e));
        }
    }

    public void setServer(String serverName, int serverPort) {
        this.serverName = serverName;
        this.serverPort = serverPort;
    }

    private static void checkLwjglVersion() {
        LOGGER.info("LWJGL version = {}", (Object)Sys.getVersion());
        if (Integer.parseInt(Sys.getVersion().substring(0, 1)) < 3) {
            JOptionPane.showMessageDialog(null, new Object[]{"Better than Adventure! requires LWJGL 3 to run.", "If you're using MultiMC or Prism Launcher to run BTA!,", "please review the installation guide at", new JLabel("<html><a href=\"\">betterthanadventure.net</a>.</html>"){
                {
                    this.setCursor(new Cursor(12));
                    this.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            try {
                                Desktop.getDesktop().browse(new URL("https://www.betterthanadventure.net/installation-guide/").toURI());
                            }
                            catch (Exception ex) {
                                LOGGER.error("Exception occurred when attempting to open URL 'https://www.betterthanadventure.net/installation-guide/'!", ex);
                            }
                        }
                    });
                }
            }, "", "Please note that MultiMC/Prism Launcher instances from", "versions prior to 7.3 cannot be manually upgraded to 7.3", "or later and must be re-downloaded."}, "LWJGL Version Error", 0);
            System.exit(1);
        }
    }

    public void startGame() throws LWJGLException {
        ImageIO.setUseCache(false);
        this.mcDataDir = this.getMinecraftDir();
        LogMessageReceiver.init();
        Holidays.initialize();
        Blocks.init();
        Items.init();
        Dimension.init();
        EntityDispatcher.init();
        TileEntityDispatcher.init();
        CommandHelper.init();
        this.initCommands();
        this.gameSettings = new GameSettings(this, this.mcDataDir);
        LOGGER.info("Java Version: {}", (Object)System.getProperty("java.version"));
        this.printWrongJavaVersionInfo();
        this.gameWindow.init(this, this.overrideWidth != null ? this.overrideWidth : (Integer)this.gameSettings.windowWidth.value, this.overrideHeight != null ? this.overrideHeight : (Integer)this.gameSettings.windowHeight.value);
        @Nullable String vendorString = GL11.glGetString((int)7936);
        if (vendorString != null && (GPU_VENDOR = EnumGPUVendor.getVendorFromString(vendorString)) == EnumGPUVendor.INTEL) {
            this.gameSettings.lightmapStyle.set(LightmapStyle.DISABLED);
        }
        LOGGER.info("Resolution: {} x {}", (Object)this.gameWindow.getWidthPixels(), (Object)this.gameWindow.getHeightPixels());
        this.resolution.setScale((Integer)this.gameSettings.guiScale.value);
        this.saveFormat = new SaveFormat19134(new File(this.mcDataDir, "saves"));
        I18n.initialize((String)this.gameSettings.language.value);
        if (!((Boolean)this.gameSettings.startInFullscreen.value).booleanValue()) {
            this.gameSettings.fullscreen.value = false;
        }
        this.resolution.setScale((Integer)this.gameSettings.guiScale.value);
        OpenGLHelper.testCapabilities(this);
        this.terrainRenderer = new TerrainRendererLegacy(this);
        if (Shaders.enableShaders) {
            this.setRenderer(new ShadersRenderer(this));
        } else {
            this.setRenderer(new FallbackRenderer(this));
        }
        this.texturePackList = new TexturePackList(this, this.mcDataDir);
        this.textureManager = new TextureManager(this, this.texturePackList, this.gameSettings);
        TooltipElement.reloadStyles(this.texturePackList);
        SoundRepository.initialize(this);
        this.loadScreen();
        BiomeProviderOverworld.init();
        this.worldRenderer = new WorldRenderer(this);
        BlockModelDispatcher.getInstance();
        ItemModelDispatcher.getInstance();
        EntityRenderDispatcher.instance.itemRenderer = new ItemRenderer(this);
        this.loadScreen();
        LOGGER.info("Initializing input");
        try {
            InputHandler.init(this);
            this.controllerInput = InputHandler.getController((String)this.gameSettings.selectedController.value);
        }
        catch (Exception e) {
            LOGGER.error("Input init error!", e);
        }
        this.mouseInput.setRawInput((Boolean)this.gameSettings.rawMouseInput.value);
        LOGGER.info("Input done!");
        LOGGER.info("Setting up OpenGL values...");
        OpenGLHelper.checkError("pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        OpenGLHelper.checkError("startup");
        this.sndManager.init(this.gameSettings);
        this.loadScreen();
        Colorizers.init(this);
        this.textureManager.refreshTextures(new ArrayList<Throwable>());
        OptionsPages.init();
        this.loadScreen();
        LOGGER.info("Initializing Renderer...");
        TextureRegistry.blockAtlas.bind();
        this.renderGlobal = new RenderGlobal(this, this.textureManager);
        GL11.glViewport((int)0, (int)0, (int)this.gameWindow.getWidthPixels(), (int)this.gameWindow.getHeightPixels());
        this.particleEngine = new ParticleEngine(this.currentWorld);
        try {
            LOGGER.info("Starting Resource Download Thread...");
            this.downloadResourcesThread = new ThreadDownloadResources(this.mcDataDir, this);
            this.downloadResourcesThread.start();
        }
        catch (Exception e) {
            LOGGER.error("Failed to start Resource Download Thread!", e);
        }
        OpenGLHelper.checkError("post startup");
        this.hudIngame = new HudIngame(this);
        new Registries();
        DataLoader.loadRecipesFromFile("/recipes/blast_furnace.json");
        DataLoader.loadRecipesFromFile("/recipes/furnace.json");
        DataLoader.loadRecipesFromFile("/recipes/trommel.json");
        DataLoader.loadRecipesFromFile("/recipes/workbench.json");
        DataLoader.loadDataPacks(this);
        Registries.RECIPES_LOCAL_COPY = Registries.RECIPES;
        int recipes = Registries.RECIPES.getAllRecipes().size();
        int groups = Registries.RECIPES.getAllGroups().size();
        int namespaces = Registries.RECIPES.size();
        int itemGroups = Registries.ITEM_GROUPS.size();
        LOGGER.info(String.format("%d item groups.", itemGroups));
        LOGGER.info(String.format("%d recipes in %d groups in %d namespaces.", recipes, groups, namespaces));
        StatList.init();
        this.statsCounter = new StatsCounter(this.session, this.mcDataDir);
        Achievements.OPEN_INVENTORY.setDescriptionFormatter(s -> {
            if (!this.gameSettings.keyInventory.isBound()) {
                return "Set your inventory keybind in the controls menu!";
            }
            return String.format(s, this.gameSettings.keyInventory.getKeyName());
        });
        Achievements.OPEN_GUIDEBOOK.setDescriptionFormatter(s -> {
            if (!this.gameSettings.keyGuidebook.isBound()) {
                return "Set your guidebook keybind in the controls menu!";
            }
            return String.format(s, this.gameSettings.keyGuidebook.getKeyName());
        });
        this.loadScreen();
        if (((Boolean)this.gameSettings.discordRichPresence.value).booleanValue()) {
            this.rpcThread = new RichPresenceHandlerThread(this);
            this.rpcThread.start();
        }
        this.gameStarted = true;
        boolean hasBeta173 = true;
        try {
            Class.forName("a");
        }
        catch (Exception e) {
            hasBeta173 = false;
        }
        if (!hasBeta173) {
            this.displayScreen(new ScreenMissingMinecraft());
        } else if (System.getProperty("sun.arch.data.model").equals("32")) {
            this.displayScreen(new ScreenBadJavaArch());
        } else if (this.serverName != null) {
            this.displayScreen(new ScreenConnecting(this, this.serverName, this.serverPort));
        } else if (this.worldPresetName != null && this.worldPresetSeed != null) {
            ScreenSelectWorld screenSelectWorld = new ScreenSelectWorld(null);
            this.displayScreen(screenSelectWorld);
            screenSelectWorld.deletePresetWorld(this.worldPresetName);
            ScreenCreateWorld screen = new ScreenCreateWorld(null);
            this.displayScreen(screen);
            screen.runPreset(this.worldPresetName, this.worldPresetSeed, this.worldPresetX, this.worldPresetY, this.worldPresetZ);
        } else {
            this.displayScreen(new ScreenMainMenu());
        }
        this.gameWindow.updateWindowState();
    }

    public void initCommands() {
        CommandManager.registerCommand(new CommandAchievement());
        CommandManager.registerCommand(new CommandClear());
        CommandManager.registerCommand(new CommandKill());
        CommandManager.registerCommand(new CommandSeed());
        CommandManager.registerCommand(new CommandSetBlock());
        CommandManager.registerCommand(new CommandSummon());
        CommandManager.registerCommand(new CommandTeleport());
        CommandManager.registerCommand(new CommandMessage());
        CommandManager.registerCommand(new CommandSetSpawn());
        CommandManager.registerCommand(new CommandTime());
        CommandManager.registerCommand(new CommandGameMode());
        CommandManager.registerCommand(new CommandWeather());
        CommandManager.registerCommand(new CommandSpawn());
        CommandManager.registerCommand(new CommandPlace());
        CommandManager.registerCommand(new CommandHelp());
        CommandManager.registerCommand(new CommandChunk());
        CommandManager.registerCommand(new CommandGive());
        CommandManager.registerCommand(new CommandGameRule());
        CommandManager.registerCommand(new CommandFill());
        CommandManager.registerCommand(new CommandClone());
        CommandManager.registerCommand(new CommandBiome());
        CommandManager.registerCommand(new CommandSay());
        CommandManager.registerCommand(new CommandTellRaw());
        CommandManager.registerCommand(new CommandTestFor());
        CommandManager.registerCommand(new CommandDamage());
        CommandManager.registerCommand(new CommandHeal());
        CommandManager.registerCommand(new CommandMobSpawning());
        CommandManager.registerCommand(new CommandPlaySound());
        CommandManager.registerCommand(new CommandParticle());
    }

    private void printWrongJavaVersionInfo() {
        String javaVersion = System.getProperty("java.version");
        if (Minecraft.getOs() != EnumOS.linux || javaVersion == null) {
            return;
        }
        try {
            int major = Integer.parseInt(javaVersion.split("\\.")[0]);
            if (major > 8) {
                LOGGER.warn("Detected a probably incompatible Java version. If the game crashes with a message similar to \n\"Inconsistency detected by ld.so: dl-lookup.c: 111: check_match: Assertion `version->filename == NULL || ! _dl_name_match_p (version->filename, map)' failed!\", \nuse Java 8!");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve Java version!", e);
            LOGGER.warn("If the game crashes with a message similar to \n\"Inconsistency detected by ld.so: dl-lookup.c: 111: check_match: Assertion `version->filename == NULL || ! _dl_name_match_p (version->filename, map)' failed!\", \nuse Java 8!");
        }
    }

    private void loadScreen() throws LWJGLException {
        LOGGER.info("Drawing Loading Screen...");
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.resolution.getExactScaledWidthScreenCoords(), (double)this.resolution.getExactScaledHeightScreenCoords(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.gameWindow.getWidthPixels(), (int)this.gameWindow.getHeightPixels());
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        if (this.mojrand == 0) {
            this.textureManager.loadTexture("/assets/minecraft/textures/gui/title/majonk.png").bind();
        } else {
            this.textureManager.loadTexture("/assets/minecraft/textures/gui/title/mojang.png").bind();
        }
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0xFFFFFF);
        tessellator.addVertexWithUV(0.0, this.gameWindow.getHeightPixels(), 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(this.gameWindow.getWidthPixels(), this.gameWindow.getHeightPixels(), 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(this.gameWindow.getWidthPixels(), 0.0, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        int width = 256;
        int height = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawMojangLogoVertices((this.resolution.getScaledWidthScreenCoords() - width) / 2, (this.resolution.getScaledHeightScreenCoords() - height) / 2, 0, 0, width, height);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        this.gameWindow.update();
    }

    public void drawMojangLogoVertices(int minX, int minY, int minU, int minV, int width, int height) {
        float scaleX = 0.00390625f;
        float scaleY = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0xFFFFFF);
        tessellator.addVertexWithUV(minX + 0, minY + height, 0.0, (float)(minU + 0) * scaleX, (float)(minV + height) * scaleY);
        tessellator.addVertexWithUV(minX + width, minY + height, 0.0, (float)(minU + width) * scaleX, (float)(minV + height) * scaleY);
        tessellator.addVertexWithUV(minX + width, minY + 0, 0.0, (float)(minU + width) * scaleX, (float)(minV + 0) * scaleY);
        tessellator.addVertexWithUV(minX + 0, minY + 0, 0.0, (float)(minU + 0) * scaleX, (float)(minV + 0) * scaleY);
        tessellator.draw();
    }

    @Override
    public File getMinecraftDir() {
        if (minecraftDir == null) {
            minecraftDir = Minecraft.getAppDir("minecraft-bta");
        }
        return minecraftDir;
    }

    @Override
    public String getMinecraftVersion() {
        return VERSION;
    }

    @Override
    public IChunkProvider createChunkProvider(World world, IChunkLoader chunkLoader) {
        return new ChunkProviderStatic(world, chunkLoader, world.getWorldType().createChunkGenerator(world));
    }

    public static File getAppDir(String s) {
        File appDir;
        String homeDirPath = System.getProperty("user.home", ".");
        switch (Minecraft.getOs()) {
            case linux: 
            case solaris: {
                appDir = new File(homeDirPath, '.' + s + '/');
                break;
            }
            case windows: {
                String s2 = System.getenv("APPDATA");
                if (s2 != null) {
                    appDir = new File(s2, "." + s + '/');
                    break;
                }
                appDir = new File(homeDirPath, '.' + s + '/');
                break;
            }
            case macos: {
                appDir = new File(homeDirPath, "Library/Application Support/" + s);
                break;
            }
            default: {
                appDir = new File(homeDirPath, s + '/');
            }
        }
        if (!appDir.exists() && !appDir.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + appDir);
        }
        return appDir;
    }

    public static EnumOS getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS.windows;
        }
        if (s.contains("mac")) {
            return EnumOS.macos;
        }
        if (s.contains("solaris") || s.contains("sunos")) {
            return EnumOS.solaris;
        }
        if (s.contains("linux") || s.contains("unix")) {
            return EnumOS.linux;
        }
        return EnumOS.unknown;
    }

    public ISaveFormat getSaveFormat() {
        return this.saveFormat;
    }

    public void displayScreen(Screen screen) {
        if (this.currentScreen == null && screen != null && this.controllerInput != null) {
            this.controllerInput.cursorX = (double)this.resolution.getScaledWidthScreenCoords() / 2.0;
            this.controllerInput.cursorY = (double)this.resolution.getScaledHeightScreenCoords() / 2.0;
        }
        if (this.currentScreen != null) {
            this.currentScreen.removed();
        }
        if (screen instanceof ScreenMainMenu) {
            this.statsCounter.fetchStats();
        }
        if (this.statsCounter != null) {
            this.statsCounter.saveStats();
        }
        if (screen == null && this.currentWorld == null) {
            screen = new ScreenMainMenu();
        } else if (screen == null && this.thePlayer.getHealth() <= 0) {
            screen = new ScreenGameOver();
        }
        if (screen instanceof ScreenMainMenu) {
            this.hudIngame.clearChatMessages();
        }
        this.currentScreen = screen;
        if (screen != null) {
            this.setIngameNotInFocus();
            screen.opened(this, this.resolution.getScaledWidthScreenCoords(), this.resolution.getScaledHeightScreenCoords());
            this.skipRenderWorld = false;
        } else {
            this.setIngameFocus();
        }
    }

    public void shutdownMinecraftApplet() {
        try {
            if (this.gameSettings != null) {
                this.gameSettings.saveOptions();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while saving settings! Some settings may be lost!", e);
        }
        if (this.statsCounter != null) {
            this.statsCounter.fetchStats();
            this.statsCounter.saveStats();
        }
        LOGGER.info("Stopping!");
        try {
            this.changeWorld(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            GLAllocation.deleteTexturesAndDisplayLists();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.sndManager != null) {
            this.sndManager.destroy();
        }
        System.gc();
        if (!this.hasCrashed) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        this.running = true;
        try {
            this.startGame();
        }
        catch (Throwable e) {
            this.onMinecraftCrash(new UnexpectedThrowable("Failed to start game", e));
        }
        try {
            long currentTime = System.currentTimeMillis();
            int fpsCounter = 0;
            while (this.running) {
                try {
                    long now;
                    long sleepTime;
                    Debug.reset();
                    Debug.push("update");
                    Debug.push("misc");
                    long tickStartTime = System.currentTimeMillis();
                    Time.tick();
                    AABB.initializePool();
                    Vec3.initializePool();
                    if (this.gameWindow.shouldClose()) {
                        this.shutdown();
                    }
                    if (this.isGamePaused && this.currentWorld != null && !(this.currentScreen instanceof ScreenModelViewer)) {
                        float temp = this.timer.partialTicks;
                        this.timer.advanceTime();
                        this.timer.partialTicks = temp;
                    } else {
                        this.timer.advanceTime();
                    }
                    if (!doPartialTick) {
                        this.timer.partialTicks = 1.0f;
                    }
                    this.mouseInput.update();
                    if (this.controllerInput != null && this.currentScreen != null) {
                        this.controllerInput.moveCursor();
                    }
                    Debug.pop();
                    Debug.change("tick");
                    for (int tick = 0; tick < this.timer.frames; ++tick) {
                        ++this.ticksRan;
                        try {
                            this.runTick();
                            continue;
                        }
                        catch (MinecraftException e) {
                            this.currentWorld = null;
                            LOGGER.error("MinecraftException occurred while attempting to run tick, exiting world!", e);
                            this.changeWorld(null);
                            this.displayScreen(new ScreenConflictWarning());
                        }
                    }
                    Debug.change("update");
                    Debug.push("misc");
                    OpenGLHelper.checkError("pre render");
                    BlockModelGrass.fancyGrass = (Integer)this.gameSettings.fancyGraphics.value == 1;
                    EntityItem.enableItemClumping = (Boolean)this.gameSettings.enableItemClumping.value;
                    BlockLogicLeavesBase.enableTreeShadowing = (Boolean)this.gameSettings.treeShadows.value;
                    this.sndManager.updateListener(this.thePlayer, this.timer.partialTicks);
                    GL11.glEnable((int)3553);
                    if (this.currentWorld != null) {
                        Debug.change("updatelight");
                        try {
                            this.currentWorld.updatingLighting();
                        }
                        catch (Throwable t) {
                            LOGGER.error("Unhandled exception when updating lighting!", t);
                        }
                        Debug.change("misc");
                    }
                    Debug.change("misc");
                    if (this.thePlayer != null && this.thePlayer.isInWall()) {
                        this.gameSettings.thirdPersonView.value = 0;
                    }
                    Debug.change("displayupdate");
                    this.gameWindow.update();
                    Debug.change("render");
                    Debug.push("post");
                    this.renderer.beginRenderGame(this.timer.partialTicks);
                    GL11.glEnable((int)3008);
                    Debug.change("misc");
                    if (!this.skipRenderWorld) {
                        if (this.playerController != null) {
                            this.playerController.render(this.timer.partialTicks);
                        }
                        this.worldRenderer.updateCameraAndRender(this.timer.partialTicks);
                    }
                    if (((Boolean)this.gameSettings.pauseOnLostFocus.value).booleanValue()) {
                        if (!this.gameWindow.isFocused()) {
                            if (System.currentTimeMillis() > this.lastFocusTime + 250L) {
                                this.displayInGameMenu();
                            }
                        } else {
                            this.lastFocusTime = System.currentTimeMillis();
                        }
                    }
                    this.sndManager.setMuted((Boolean)this.gameSettings.muteOnLostFocus.value != false && !this.gameWindow.isFocused());
                    this.guiToasts.render(this.timer.partialTicks);
                    Debug.change("post");
                    this.renderer.endRenderGame(this.timer.partialTicks);
                    Debug.pop();
                    Debug.change("misc");
                    if (this.gameWindow.wasResized()) {
                        this.resize();
                    }
                    OpenGLHelper.checkError("post render");
                    ++fpsCounter;
                    boolean bl = this.isGamePaused = !this.isMultiplayerWorld() && this.currentScreen != null && this.currentScreen.isPauseScreen();
                    while (System.currentTimeMillis() >= currentTime + 1000L) {
                        this.debug = fpsCounter + " fps, " + ChunkRenderer.updates + " chunk updates";
                        this.debugFPS = fpsCounter + " fps";
                        ChunkRenderer.updates = 0;
                        currentTime += 1000L;
                        fpsCounter = 0;
                    }
                    if (this.currentWorld == null && (sleepTime = 16L - ((now = System.currentTimeMillis()) - tickStartTime) - 1L) > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    Debug.pop();
                    Debug.pop();
                    if (((Boolean)this.gameSettings.showFrameTimes.value).booleanValue()) {
                        DebugRender.render(this.font);
                    }
                    this.screenshotListener();
                }
                catch (MinecraftException minecraftexception) {
                    this.currentWorld = null;
                    this.changeWorld(null);
                    this.displayScreen(new ScreenConflictWarning());
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    this.freeUpMemory();
                    this.displayScreen(new ScreenOutOfMemory());
                    System.gc();
                }
                catch (Throwable throwable) {
                    if (this.currentWorld != null) {
                        try {
                            this.changeWorld(null);
                        }
                        catch (Throwable t) {
                            LOGGER.error("Exception when panic leaving world!", t);
                        }
                    }
                    this.freeUpMemory();
                    this.onMinecraftCrash(new UnexpectedThrowable("Unexpected error", throwable));
                }
            }
        }
        catch (MinecraftError minecraftError) {
        }
        finally {
            this.shutdownMinecraftApplet();
        }
    }

    public void freeUpMemory() {
        try {
            this.renderGlobal.deleteRenderListBase();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            AABB.deinitializePool();
            Vec3.deinitializePool();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            this.changeWorld(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    private void screenshotListener() {
        if (this.gameSettings.keyScreenshot.isPressed()) {
            if (!this.isTakingScreenshot) {
                this.isTakingScreenshot = true;
                boolean ctrl = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
                Debug.push("screenshot");
                if (ctrl) {
                    if (Shaders.enableShaders) {
                        try {
                            this.screenshotHelper.takePanoramaScreenshot();
                            this.hudIngame.addChatMessage("Saved panorama screenshot!");
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception occurred while taking panoramic screenshot!", e);
                        }
                    }
                } else {
                    this.hudIngame.addChatMessage(ScreenShot.saveScreenshot(minecraftDir, this.gameWindow.getWidthPixels(), this.gameWindow.getHeightPixels()));
                }
                Debug.pop();
            }
        } else {
            this.isTakingScreenshot = false;
        }
    }

    public void shutdown() {
        this.running = false;
    }

    public void setIngameFocus() {
        if (!this.gameWindow.isFocused()) {
            return;
        }
        if (!this.inGameHasFocus) {
            this.inGameHasFocus = true;
            this.mouseInput.grabCursor();
            this.displayScreen(null);
            this.mouseTicksRan = this.ticksRan + 10000;
            if (this.thePlayer != null) {
                this.thePlayer.input.onGameFocused();
            }
        }
    }

    public void setIngameNotInFocus() {
        if (!this.inGameHasFocus) {
            return;
        }
        if (this.thePlayer != null) {
            this.thePlayer.input.onGameUnfocused();
        }
        this.inGameHasFocus = false;
        if (this.inputType == InputType.KEYBOARD) {
            this.mouseInput.releaseCursor();
        }
        this.worldRenderer.zooming = false;
    }

    public void displayInGameMenu() {
        if (this.currentScreen == null) {
            this.displayScreen(new ScreenPause());
        }
    }

    private void mineBlocks(int i, boolean flag) {
        if (flag && this.objectMouseOver != null && this.objectMouseOver.hitType == HitResult.HitType.TILE && i == 0) {
            int blockX = this.objectMouseOver.x;
            int blockY = this.objectMouseOver.y;
            int blockZ = this.objectMouseOver.z;
            Side side = this.objectMouseOver.side;
            double yPlaced = this.objectMouseOver.location.y - (double)this.objectMouseOver.y;
            double xPlaced = side.getAxis() == Axis.X ? this.objectMouseOver.location.x - (double)this.objectMouseOver.x : (side.getAxis() == Axis.Z ? this.objectMouseOver.location.z - (double)this.objectMouseOver.z : this.objectMouseOver.location.x - (double)this.objectMouseOver.x);
            this.playerController.continueDestroyBlock(blockX, blockY, blockZ, this.objectMouseOver.side, xPlaced, yPlaced);
        } else {
            this.playerController.stopDestroyBlock(flag);
        }
    }

    private void clickMouse(int clickType, boolean attack, boolean repeat) {
        ItemStack itemstack;
        this.mouseTicksRan = this.ticksRan;
        boolean flag = true;
        if (this.objectMouseOver == null) {
            block29: {
                AABB cube;
                List<AABB> cubes;
                if (((Boolean)this.gameSettings.easyBridge.value).booleanValue() && clickType == 1 && !(this.thePlayer.xRot < 45.0f) && (cubes = this.thePlayer.world.getCubes(this.thePlayer, this.thePlayer.bb.cloneMove(0.0, -1.0, 0.0))).size() >= 1 && (cube = cubes.get(0)) != null) {
                    int numItemsInStack;
                    Side side;
                    int blockX = MathHelper.floor(this.thePlayer.x);
                    int blockY = MathHelper.floor(this.thePlayer.y - (double)this.thePlayer.heightOffset - 0.25);
                    int blockZ = MathHelper.floor(this.thePlayer.z);
                    Direction playerDirection = Direction.getHorizontalDirection(this.thePlayer);
                    switch (playerDirection) {
                        case NORTH: {
                            side = Side.NORTH;
                            break;
                        }
                        case SOUTH: {
                            side = Side.SOUTH;
                            break;
                        }
                        case WEST: {
                            side = Side.WEST;
                            break;
                        }
                        case EAST: {
                            side = Side.EAST;
                            break;
                        }
                        default: {
                            break block29;
                        }
                    }
                    double yPlaced = 0.5;
                    double xPlaced = 0.5;
                    ItemStack stack = this.thePlayer.inventory.getCurrentItem();
                    int n = numItemsInStack = stack == null ? 0 : stack.stackSize;
                    if (this.playerController.useItemOn(this.thePlayer, this.currentWorld, stack, blockX, blockY, blockZ, side, xPlaced, yPlaced)) {
                        this.playerController.swingItem(true);
                    }
                    if (stack != null) {
                        if (stack.stackSize <= 0) {
                            this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.getCurrentItemIndex()] = null;
                        } else if (stack.stackSize != numItemsInStack) {
                            this.worldRenderer.itemRenderer.updateEquippedItem();
                        }
                    }
                }
            }
            if (clickType == 0 && attack) {
                this.playerController.swingItem(true);
            }
        } else if (this.objectMouseOver.hitType == HitResult.HitType.ENTITY) {
            if (clickType == 0 && attack) {
                this.playerController.swingItem(true);
                this.playerController.attack(this.thePlayer, this.objectMouseOver.entity);
            }
            if (clickType == 1 && this.playerController.interact(this.thePlayer, this.objectMouseOver.entity)) {
                flag = false;
            }
        } else if (this.objectMouseOver.hitType == HitResult.HitType.TILE) {
            int blockX = this.objectMouseOver.x;
            int blockY = this.objectMouseOver.y;
            int blockZ = this.objectMouseOver.z;
            Side side = this.objectMouseOver.side;
            double yPlaced = this.objectMouseOver.location.y - (double)this.objectMouseOver.y;
            double xPlaced = side.getAxis() == Axis.X ? this.objectMouseOver.location.x - (double)this.objectMouseOver.x : (side.getAxis() == Axis.Z ? this.objectMouseOver.location.z - (double)this.objectMouseOver.z : this.objectMouseOver.location.x - (double)this.objectMouseOver.x);
            if (clickType == 0) {
                this.playerController.startDestroyBlock(blockX, blockY, blockZ, this.objectMouseOver.side, xPlaced, yPlaced, repeat);
                if (this.thePlayer.getHeldObject() == null) {
                    this.playerController.swingItem(true);
                }
            } else {
                int numItemsInStack;
                ItemStack stack = this.thePlayer.inventory.getCurrentItem();
                int n = numItemsInStack = stack == null ? 0 : stack.stackSize;
                if (this.playerController.useItemOn(this.thePlayer, this.currentWorld, stack, blockX, blockY, blockZ, side, xPlaced, yPlaced)) {
                    flag = false;
                    this.playerController.swingItem(true);
                }
                if (stack == null) {
                    return;
                }
                if (stack.stackSize <= 0) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.getCurrentItemIndex()] = null;
                } else if (stack.stackSize != numItemsInStack) {
                    this.worldRenderer.itemRenderer.resetEquippedProgress();
                }
            }
        }
        if (flag && clickType == 1 && (itemstack = this.thePlayer.inventory.getCurrentItem()) != null && this.playerController.useItem(this.thePlayer, this.currentWorld, itemstack)) {
            this.worldRenderer.itemRenderer.resetEquippedProgress();
        }
    }

    public void resize() {
        this.resolution.setScale((Integer)this.gameSettings.guiScale.value);
        if (this.currentScreen != null) {
            this.currentScreen.opened(this, this.resolution.getScaledWidthScreenCoords(), this.resolution.getScaledHeightScreenCoords());
        }
    }

    private void clickMiddleMouseButton(boolean shift, boolean control) {
        HitResult mouseOver = this.thePlayer.rayTrace(256.0, this.timer.partialTicks, false, false);
        if (mouseOver != null && mouseOver.hitType == HitResult.HitType.TILE) {
            int x = mouseOver.x;
            int y = mouseOver.y;
            int z = mouseOver.z;
            this.thePlayer.pickBlock(x, y, z, control);
        }
    }

    private void startCheckPaidThread() {
        new Thread(() -> {
            try {
                HttpURLConnection httpurlconnection = (HttpURLConnection)new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.session.username + "&session=" + this.session.sessionId).openConnection();
                httpurlconnection.connect();
                if (httpurlconnection.getResponseCode() == 400) {
                    hasPaidCheckTime = System.currentTimeMillis();
                }
                httpurlconnection.disconnect();
            }
            catch (Exception exception) {
                LOGGER.error("Error occurred while checking if paid client", exception);
            }
        }).start();
    }

    public void runTick() {
        if (this.ticksRan == 6000) {
            this.startCheckPaidThread();
        }
        Debug.push("gui");
        this.subtitleTracker.tick();
        this.statsCounter.tick();
        this.hudIngame.updateTick();
        Debug.change("misc");
        this.worldRenderer.getMouseOver(1.0f);
        if (this.thePlayer != null) {
            IChunkProvider chunkProvider = this.currentWorld.getChunkProvider();
            int playerChunkX = MathHelper.floor_float((int)this.thePlayer.x) >> 4;
            int playerChunkZ = MathHelper.floor_float((int)this.thePlayer.z) >> 4;
            chunkProvider.setCurrentChunkOver(playerChunkX, playerChunkZ);
        }
        if (!this.isGamePaused && this.currentWorld != null) {
            this.playerController.tick();
        }
        Debug.change("textureTick");
        TextureRegistry.blockAtlas.bind();
        this.textureManager.updateDynamicTextures(this.isGamePaused);
        Debug.change("misc");
        if (this.currentScreen == null && this.thePlayer != null) {
            if (this.thePlayer.getHealth() <= 0) {
                this.displayScreen(null);
            } else if (this.thePlayer.isPlayerSleeping() && this.currentWorld != null) {
                if (this.currentWorld.isClientSide) {
                    this.displayScreen(new ScreenSleepMP());
                } else {
                    this.displayScreen(new ScreenSleepSP());
                }
            }
        } else if (this.currentScreen != null && this.currentScreen instanceof ScreenSleepMP && !this.thePlayer.isPlayerSleeping()) {
            this.displayScreen(null);
        }
        Debug.change("input");
        if (this.currentScreen != null) {
            this.mouseTicksRan = this.ticksRan + 10000;
        }
        if (this.currentScreen != null && this.inputType == InputType.CONTROLLER && (this.mouseInput.deltaX != 0.0 || this.mouseInput.deltaY != 0.0)) {
            this.setInputType(InputType.KEYBOARD);
        }
        if (this.currentScreen != null) {
            this.currentScreen.updateEvents();
            if (this.currentScreen != null) {
                this.currentScreen.tick();
            }
        }
        if (this.currentScreen == null || this.currentScreen.passEvents) {
            boolean placeBlockPressed;
            while (Mouse.next()) {
                long delta = System.currentTimeMillis() - this.systemTime;
                if (delta > 200L) continue;
                int scrollDelta = Mouse.getEventDWheel();
                if (scrollDelta != 0) {
                    if (this.thePlayer.noPhysics && this.toggleFlyPressed) {
                        float steps = 20.0f;
                        int step = Math.round(((Float)this.gameSettings.flightSpeed.value).floatValue() * 20.0f);
                        float newSpeed = (float)(step += MathHelper.clamp(scrollDelta, -1, 1)) / 20.0f;
                        newSpeed = MathHelper.clamp(newSpeed, 0.0f, 1.0f);
                        this.gameSettings.flightSpeed.value = Float.valueOf(newSpeed);
                        this.thePlayer.setFlySpeed(newSpeed);
                        this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(this.gameSettings.flightSpeed);
                    } else if (!this.gameSettings.keyZoom.isPressed()) {
                        this.thePlayer.inventory.changeCurrentItem(scrollDelta);
                    }
                }
                if (!this.inGameHasFocus && Mouse.getEventButtonState()) {
                    this.setIngameFocus();
                    continue;
                }
                if (!this.checkBoundInputs(InputDevice.mouse) || Mouse.isGrabbed() || this.inputType != InputType.KEYBOARD || this.currentScreen != null) continue;
                this.mouseInput.grabCursor();
            }
            if (this.toggleFlyPressed && !this.gameSettings.keyFly.isPressed()) {
                this.toggleFlyPressed = false;
                if (this.flyPressedTime + 400L > System.currentTimeMillis()) {
                    this.thePlayer.setNoclip(!this.thePlayer.noPhysics);
                }
            }
            while (Keyboard.next()) {
                boolean control;
                if (Keyboard.getEventKeyState() && ((Boolean)this.gameSettings.showFrameTimes.value).booleanValue() && DebugRender.keyPressed(Keyboard.getEventKey())) continue;
                @Nullable Runnable scriptBindAction = BindManager.getInstance().getActionForKey(Keyboard.getEventKey());
                if (scriptBindAction != null) {
                    scriptBindAction.run();
                    continue;
                }
                boolean shift = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT);
                boolean bl = control = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
                if (!Keyboard.getEventKeyState() || !this.gameSettings.keyToggleDebug.isPressed()) {
                    this.thePlayer.input.keyEvent(Keyboard.getEventKey(), Keyboard.getEventKeyState());
                }
                if (this.gameSettings.keyToggleDebug.isPressEvent()) {
                    this.f3Press = true;
                }
                if (this.gameSettings.keyToggleDebug.isReleaseEvent() && this.f3Press) {
                    if (control) {
                        this.gameSettings.showFrameTimes.toggle();
                    } else {
                        this.gameSettings.showDebugScreen.toggle();
                    }
                    this.f3Press = false;
                }
                if (Keyboard.getEventKeyState()) {
                    if (Keyboard.getEventKey() == Keyboard.KEY_F11) {
                        this.gameWindow.toggleFullscreen();
                        continue;
                    }
                    if (this.gameSettings.keyToggleDebug.isPressed()) {
                        if (Keyboard.getEventKey() == Keyboard.KEY_Q) {
                            this.hudIngame.addChatMessage(TextFormatting.YELLOW + "Keyboard shortcuts: ");
                            this.gameSettings.debugsKeys.sort(Comparator.comparing(KeyBinding::getKeyName));
                            for (KeyBinding binding : this.gameSettings.debugsKeys) {
                                this.hudIngame.addChatMessage(String.format("%s + %s: %s", this.gameSettings.keyToggleDebug.getKeyName(), binding.getKeyName(), I18n.getInstance().translateKey(binding.getId())));
                            }
                            this.hudIngame.addChatMessage(String.format("%s: %s", this.gameSettings.keyToggleTextureAtlas.getKeyName(), I18n.getInstance().translateKey(this.gameSettings.keyToggleTextureAtlas.getId())));
                            this.hudIngame.addChatMessage(String.format("%s: %s", this.gameSettings.keyReleaseCursor.getKeyName(), I18n.getInstance().translateKey(this.gameSettings.keyReleaseCursor.getId())));
                        }
                        if (this.gameSettings.keyReload.isPressEvent()) {
                            this.forceReload();
                        } else if (this.gameSettings.keySwitchGamemode.isPressEvent()) {
                            if (this.currentWorld.getLevelData().getCheatsEnabled() || this.currentWorld.isClientSide) {
                                if (this.thePlayer.getGamemode() == Gamemode.creative) {
                                    this.thePlayer.sendChatMessage("/gamemode 0");
                                } else {
                                    this.thePlayer.sendChatMessage("/gamemode 1");
                                }
                            }
                        } else if (this.gameSettings.keyDumpTextures.isPressEvent()) {
                            Textures.dumpTextures();
                        } else if (this.gameSettings.keyFullbright.isPressEvent()) {
                            PacketHandlerClient queue = this.getSendQueue();
                            if (queue != null) {
                                PlayerProfile profile = queue.getPlayer(this.thePlayer.username);
                                if (profile != null && profile.isOperator) {
                                    boolean bl2 = this.fullbright = !this.fullbright;
                                    if (!LightmapHelper.isLightmapEnabled()) {
                                        this.renderGlobal.loadRenderers();
                                    }
                                }
                            } else if (this.currentWorld.getLevelData().getCheatsEnabled()) {
                                boolean bl3 = this.fullbright = !this.fullbright;
                                if (!LightmapHelper.isLightmapEnabled()) {
                                    this.renderGlobal.loadRenderers();
                                }
                            }
                            this.hudIngame.heldItemTooltipElement.setString("Fullbright: " + (this.fullbright ? "On" : "Off"));
                        } else if (this.gameSettings.keyLightmaps.isPressEvent()) {
                            if (this.gameSettings.lightmapStyle.value == LightmapStyle.DISABLED) {
                                this.gameSettings.lightmapStyle.value = LightmapStyle.GRAY;
                                this.hudIngame.heldItemTooltipElement.setString("Lightmap: On");
                                this.renderGlobal.loadRenderers();
                            } else {
                                this.gameSettings.lightmapStyle.value = LightmapStyle.DISABLED;
                                this.hudIngame.heldItemTooltipElement.setString("Lightmap: Off");
                                this.renderGlobal.loadRenderers();
                            }
                        } else if (this.gameSettings.keyCollisionBoxes.isPressEvent()) {
                            this.gameSettings.showCollisionBoxes.toggle();
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(this.gameSettings.showCollisionBoxes);
                        } else if (this.gameSettings.keyChunkBorders.isPressEvent()) {
                            this.gameSettings.showChunkBorders.toggle();
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(this.gameSettings.showChunkBorders);
                        } else if (this.gameSettings.keyClearChat.isPressEvent()) {
                            this.hudIngame.clearChatMessages();
                        } else if (this.gameSettings.keyPauseLostFocus.isPressEvent()) {
                            this.gameSettings.pauseOnLostFocus.toggle();
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(this.gameSettings.pauseOnLostFocus);
                        } else if (this.gameSettings.keyToggleItemInfo.isPressEvent()) {
                            this.gameSettings.showItemDebugInfo.toggle();
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(this.gameSettings.showItemDebugInfo);
                        } else if (this.gameSettings.keyReloadChunks.isPressEvent()) {
                            this.renderGlobal.loadRenderers();
                        } else if (this.gameSettings.keySmoothLighting.isPressEvent()) {
                            this.gameSettings.ambientOcclusion.toggle();
                            this.gameSettings.ambientOcclusion.onUpdate();
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(this.gameSettings.ambientOcclusion);
                        }
                        if (this.gameSettings.keyToggleDebug.isPressEvent()) continue;
                        this.f3Press = false;
                        continue;
                    }
                    if (this.gameSettings.keyReleaseCursor.isPressEvent()) {
                        this.mouseInput.releaseCursor();
                        continue;
                    }
                    if (this.gameSettings.keyShowConsole.isPressEvent() && ((Boolean)this.gameSettings.developerMode.value).booleanValue()) {
                        this.displayScreen(new ScreenConsole(this.currentScreen));
                        continue;
                    }
                    if (Keyboard.getEventKey() == Keyboard.KEY_ESCAPE) {
                        this.displayInGameMenu();
                        continue;
                    }
                    if (this.gameSettings.keyCommand.isPressed()) {
                        this.displayScreen(new ScreenChat("/"));
                        continue;
                    }
                    this.checkBoundInputs(InputDevice.keyboard);
                    continue;
                }
                this.checkBoundInputs(InputDevice.keyboard);
            }
            boolean breakBlockPressed = this.gameSettings.keyAttack.isPressed() || this.controllerInput != null && this.controllerInput.buttonRightTrigger.isPressed();
            boolean bl = placeBlockPressed = this.gameSettings.keyInteract.isPressed() || this.controllerInput != null && this.controllerInput.buttonLeftTrigger.isPressed();
            if (this.currentScreen == null) {
                if (breakBlockPressed && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 5.0f && this.inGameHasFocus) {
                    this.clickMouse(0, (Boolean)this.gameSettings.autoHit.value, true);
                }
                if (placeBlockPressed && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 5.0f && this.inGameHasFocus) {
                    this.clickMouse(1, (Boolean)this.gameSettings.autoHit.value, true);
                }
            }
            this.mineBlocks(0, this.currentScreen == null && breakBlockPressed && this.inGameHasFocus);
        }
        InputHandler.poll();
        if (this.controllerInput != null) {
            this.handleControllerInput();
        }
        Debug.change("misc");
        if (this.currentWorld != null) {
            if (this.thePlayer != null) {
                ++this.joinPlayerCounter;
                if (this.joinPlayerCounter == 30) {
                    this.joinPlayerCounter = 0;
                    this.currentWorld.joinEntityInSurroundings(this.thePlayer);
                }
                this.thePlayer.setFlySpeed(((Float)this.gameSettings.flightSpeed.value).floatValue());
                this.thePlayer.setFlightSmoothness(((Float)this.gameSettings.flightSmoothness.value).floatValue());
                this.thePlayer.turnWithVehicle = (Boolean)this.gameSettings.turnWithVehicle.value;
            }
            if (!this.isGamePaused) {
                this.worldRenderer.updateRenderer();
            }
            if (!this.isGamePaused) {
                this.renderGlobal.updateClouds();
            }
            if (!this.isGamePaused) {
                Debug.change("entity");
                if (this.currentWorld.lightningFlicker > 0) {
                    --this.currentWorld.lightningFlicker;
                }
                try {
                    this.currentWorld.updateEntities();
                }
                catch (StackOverflowError stackOverflowError) {
                    LOGGER.error("Stack overflow while updating world entities! Closing world!", stackOverflowError);
                    this.changeWorld(null);
                    throw new RuntimeException(stackOverflowError);
                }
                catch (Throwable t) {
                    LOGGER.error("Unhandled exception while updating world entities! Closing world!", t);
                    this.changeWorld(null);
                    throw t;
                }
                Debug.change("misc");
            }
            if (!this.isGamePaused || this.isMultiplayerWorld()) {
                Debug.change("world");
                try {
                    this.currentWorld.tick();
                }
                catch (StackOverflowError stackOverflowError) {
                    LOGGER.error("Stack overflow while updating world entities! Closing world!", stackOverflowError);
                    this.changeWorld(null);
                    throw new RuntimeException(stackOverflowError);
                }
                catch (Throwable t) {
                    LOGGER.error("Unhandled exception while ticking world! Closing world!", t);
                    this.changeWorld(null);
                    throw t;
                }
                Debug.change("misc");
            }
            if (!this.isGamePaused && this.currentWorld != null) {
                Debug.change("randomDisplayTick");
                this.currentWorld.randomDisplayUpdates(MathHelper.floor(this.thePlayer.x), MathHelper.floor(this.thePlayer.y), MathHelper.floor(this.thePlayer.z));
                Debug.change("misc");
            }
            if (!this.isGamePaused) {
                Debug.change("effects");
                this.particleEngine.tick();
                Debug.change("misc");
            }
        }
        this.systemTime = System.currentTimeMillis();
        Debug.pop();
    }

    private boolean checkBoundInputs(InputDevice currentInputDevice) {
        boolean control;
        boolean shift = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT);
        boolean bl = control = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
        if (this.gameSettings.keyAttack.isPressEvent(currentInputDevice)) {
            this.clickMouse(0, true, false);
            return true;
        }
        if (this.gameSettings.keyInteract.isPressEvent(currentInputDevice)) {
            this.clickMouse(1, true, false);
            return true;
        }
        if (this.gameSettings.keyPickBlock.isPressEvent(currentInputDevice)) {
            this.clickMiddleMouseButton(shift, control);
            return true;
        }
        if (this.gameSettings.keyToggleOverlay.isPressEvent(currentInputDevice)) {
            if (control) {
                OptionInteger optionInteger = this.gameSettings.overlayMode;
                Integer n = (Integer)optionInteger.value;
                optionInteger.value = (Integer)optionInteger.value + 1;
                optionInteger = this.gameSettings.overlayMode;
                optionInteger.value = (Integer)optionInteger.value % 3;
            } else {
                int i;
                boolean on = false;
                for (i = 0; i < this.gameSettings.overlayElements.length; ++i) {
                    if (!((Boolean)this.gameSettings.overlayElements[i].value).booleanValue()) continue;
                    on = true;
                    break;
                }
                for (i = 0; i < this.gameSettings.overlayElements.length; ++i) {
                    this.gameSettings.overlayElements[i].value = !on;
                }
            }
            return true;
        }
        if (this.gameSettings.keyHideGui.isPressEvent(currentInputDevice)) {
            this.gameSettings.immersiveMode.toggle();
            return true;
        }
        if (this.gameSettings.keySwitchPerspective.isPressEvent(currentInputDevice)) {
            this.gameSettings.thirdPersonView.value = ((Integer)this.gameSettings.thirdPersonView.value + 1) % 3;
            return true;
        }
        if (this.gameSettings.keyCinematicCamera.isPressEvent(currentInputDevice)) {
            this.gameSettings.smoothCamera.value = (Boolean)this.gameSettings.smoothCamera.value == false;
            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(this.gameSettings.smoothCamera);
            return true;
        }
        if (this.gameSettings.keyInventory.isPressEvent(currentInputDevice)) {
            this.displayScreen(this.getInventoryScreen());
            return true;
        }
        if (this.gameSettings.keyGuidebook.isPressEvent(currentInputDevice)) {
            this.thePlayer.triggerAchievement(Achievements.OPEN_GUIDEBOOK);
            this.thePlayer.displayGuidebookScreen();
            return true;
        }
        if (this.gameSettings.keyDrop.isPressEvent(currentInputDevice)) {
            this.thePlayer.dropCurrentItem(control);
            return true;
        }
        if (this.gameSettings.keyPhotoMode.isPressEvent(currentInputDevice)) {
            this.displayScreen(new ScreenPhotoMode());
            return true;
        }
        if (this.gameSettings.keyChat.isPressEvent(currentInputDevice)) {
            this.displayScreen(new ScreenChat());
            return true;
        }
        if (this.isMultiplayerWorld() && this.gameSettings.keyPlayerList.isPressEvent(currentInputDevice)) {
            if (control) {
                OptionInteger on = this.gameSettings.playerListPosition;
                Integer i = (Integer)on.value;
                on.value = (Integer)on.value + 1;
                on = this.gameSettings.playerListPosition;
                on.value = (Integer)on.value % 3;
            } else {
                this.gameSettings.showPlayerList.value = (Boolean)this.gameSettings.showPlayerList.value == false;
            }
            return true;
        }
        if (this.thePlayer.getGamemode().canPlayerFly() && this.gameSettings.keyFly.isPressEvent(currentInputDevice)) {
            if (!this.toggleFlyPressed) {
                this.toggleFlyPressed = true;
            }
            this.flyPressedTime = System.currentTimeMillis();
            return true;
        }
        if (this.gameSettings.keyHotBarSwitch.isPressEvent(currentInputDevice)) {
            if (!this.thePlayer.inventory.currentItemLocked()) {
                if (shift) {
                    this.thePlayer.setHotbarOffset((this.thePlayer.inventory.getHotbarOffset() + 27) % 36);
                    this.hotbarSwapAnimationProgress = -1.0f;
                } else {
                    this.thePlayer.setHotbarOffset((this.thePlayer.inventory.getHotbarOffset() + 9) % 36);
                    this.hotbarSwapAnimationProgress = 1.0f;
                }
                this.thePlayer.inventory.changeCurrentItem(0);
            }
            return true;
        }
        if (this.gameSettings.keyCenterView.isPressEvent(currentInputDevice)) {
            this.thePlayer.xRot = 0.0f;
            return true;
        }
        if (this.gameSettings.keyLockRotation.isPressEvent(currentInputDevice)) {
            if (control) {
                OptionInteger on = this.gameSettings.rotationOverlayMode;
                Integer i = (Integer)on.value;
                on.value = (Integer)on.value + 1;
                on = this.gameSettings.rotationOverlayMode;
                on.value = (Integer)on.value % 4;
            } else {
                if (this.thePlayer.rotationLock == null || this.thePlayer.rotationLock == Direction.NONE) {
                    this.thePlayer.rotationLock = Direction.getDirection(this.thePlayer);
                    this.thePlayer.rotationLockHorizontal = Direction.getHorizontalDirection(this.thePlayer);
                    this.thePlayer.rotationLockVertical = Direction.getVerticalDirection(this.thePlayer);
                } else {
                    this.thePlayer.rotationLock = null;
                    this.thePlayer.rotationLockHorizontal = null;
                    this.thePlayer.rotationLockVertical = null;
                }
                this.thePlayer.syncPlacementMode();
            }
            return true;
        }
        if (this.gameSettings.keyToggleFog.isPressEvent(currentInputDevice)) {
            int renderDistance = (Integer)this.gameSettings.renderDistance.value;
            int nextRenderDistance = !shift ? renderDistance / 8 * 8 + 8 : (renderDistance - 1) / 8 * 8;
            if (nextRenderDistance > this.gameSettings.renderDistance.highest && !shift) {
                nextRenderDistance = this.gameSettings.renderDistance.highest;
            }
            if (nextRenderDistance < this.gameSettings.renderDistance.lowest && shift) {
                nextRenderDistance = this.gameSettings.renderDistance.lowest;
            }
            if (renderDistance == this.gameSettings.renderDistance.highest && !shift) {
                nextRenderDistance = this.gameSettings.renderDistance.lowest;
            }
            if (renderDistance == this.gameSettings.renderDistance.lowest && shift) {
                nextRenderDistance = this.gameSettings.renderDistance.highest;
            }
            this.gameSettings.renderDistance.set(nextRenderDistance);
            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(this.gameSettings.renderDistance);
            return true;
        }
        if (this.gameSettings.keyToggleGamma.isPressEvent(currentInputDevice)) {
            int currentGammaStep = 2;
            if (((Float)this.gameSettings.gamma.value).floatValue() < 0.125f) {
                currentGammaStep = 0;
            } else if (((Float)this.gameSettings.gamma.value).floatValue() < 0.375f) {
                currentGammaStep = 1;
            } else if (((Float)this.gameSettings.gamma.value).floatValue() > 0.875f) {
                currentGammaStep = 4;
            } else if (((Float)this.gameSettings.gamma.value).floatValue() > 0.625f) {
                currentGammaStep = 3;
            }
            int newGammaStep = (currentGammaStep + (shift ? -1 : 1) + 5) % 5;
            this.gameSettings.gamma.value = Float.valueOf((float)newGammaStep * 0.25f);
            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(this.gameSettings.gamma);
            return true;
        }
        if (this.gameSettings.keyHotBarLeft.isPressEvent(currentInputDevice)) {
            this.thePlayer.inventory.changeCurrentItem(1);
            return true;
        }
        if (this.gameSettings.keyHotBarRight.isPressEvent(currentInputDevice)) {
            this.thePlayer.inventory.changeCurrentItem(-1);
            return true;
        }
        KeyBinding[] hotbarSlots = new KeyBinding[]{this.gameSettings.keyHotBarSlot1, this.gameSettings.keyHotBarSlot2, this.gameSettings.keyHotBarSlot3, this.gameSettings.keyHotBarSlot4, this.gameSettings.keyHotBarSlot5, this.gameSettings.keyHotBarSlot6, this.gameSettings.keyHotBarSlot7, this.gameSettings.keyHotBarSlot8, this.gameSettings.keyHotBarSlot9};
        for (int i = 0; i < hotbarSlots.length; ++i) {
            if (!hotbarSlots[i].isPressEvent(currentInputDevice)) continue;
            this.thePlayer.inventory.setCurrentItemIndex(i + this.thePlayer.inventory.getHotbarOffset(), false);
            return true;
        }
        if (this.gameSettings.keyZoom.isPressEvent(currentInputDevice)) {
            Mouse.getDWheel();
            this.worldRenderer.zooming = true;
            return true;
        }
        if (this.gameSettings.keyZoom.isReleaseEvent(currentInputDevice)) {
            this.worldRenderer.zooming = false;
            return true;
        }
        if (this.gameSettings.keyOpenAchievements.isPressEvent(currentInputDevice)) {
            this.displayScreen(new ScreenAchievements(null, this.statsCounter));
        }
        if (this.gameSettings.keyOpenStatistics.isPressEvent(currentInputDevice)) {
            this.displayScreen(new ScreenStats(null, this.statsCounter));
        }
        return false;
    }

    private ScreenInventory getInventoryScreen() {
        if (this.thePlayer.getGamemode() == Gamemode.creative) {
            return new ScreenInventoryCreative(this.thePlayer);
        }
        return new ScreenInventory(this.thePlayer);
    }

    public void handleControllerInput() {
        try {
            this.controllerInput.update();
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred while updating controller input! Disabling controller input!", e);
            this.controllerInput = null;
            this.setInputType(InputType.KEYBOARD);
            return;
        }
        for (Joystick joystick : this.controllerInput.joysticks) {
            if (!(joystick.getX() < -0.5f || joystick.getX() > 0.5f || joystick.getY() < -0.5f) && !(joystick.getY() > 0.5f)) continue;
            this.setInputType(InputType.CONTROLLER);
        }
        ControllerInput controller = this.controllerInput;
        if (this.currentScreen == null) {
            if (controller.buttonRightTrigger.pressedThisFrame()) {
                this.clickMouse(0, true, false);
                this.mouseTicksRan = this.ticksRan;
            }
            if (controller.buttonLeftTrigger.pressedThisFrame()) {
                this.clickMouse(1, true, false);
                this.mouseTicksRan = this.ticksRan;
            }
            if (controller.buttonB.pressedThisFrame()) {
                this.thePlayer.dropCurrentItem(false);
            }
            if (controller.buttonY.pressedThisFrame() || controller.buttonX.pressedThisFrame()) {
                this.displayScreen(this.getInventoryScreen());
            }
            if (controller.buttonBack.pressedThisFrame()) {
                this.gameSettings.showPlayerList.value = (Boolean)this.gameSettings.showPlayerList.value == false;
            }
            if (controller.buttonStart.pressedThisFrame()) {
                this.displayScreen(new ScreenPause());
            }
            if (controller.digitalPad.up.pressedThisFrame() && !this.thePlayer.inventory.currentItemLocked()) {
                this.thePlayer.setHotbarOffset((this.thePlayer.inventory.getHotbarOffset() + 27) % 36);
                this.hotbarSwapAnimationProgress = -1.0f;
                this.thePlayer.inventory.changeCurrentItem(0);
            }
            if (controller.digitalPad.down.pressedThisFrame() && !this.thePlayer.inventory.currentItemLocked()) {
                this.thePlayer.setHotbarOffset((this.thePlayer.inventory.getHotbarOffset() + 9) % 36);
                this.hotbarSwapAnimationProgress = 1.0f;
                this.thePlayer.inventory.changeCurrentItem(0);
            }
            if (controller.digitalPad.left.pressedThisFrame() && this.thePlayer.getGamemode().canPlayerFly()) {
                this.thePlayer.setNoclip(!this.thePlayer.noPhysics);
            }
            if (controller.buttonLeftShoulder.pressedThisFrame()) {
                this.thePlayer.inventory.changeCurrentItem(1);
            }
            if (controller.buttonRightShoulder.pressedThisFrame()) {
                this.thePlayer.inventory.changeCurrentItem(-1);
            }
            if (controller.joyLeft.getButton().pressedThisFrame()) {
                OptionInteger optionInteger = this.gameSettings.thirdPersonView;
                Integer n = (Integer)optionInteger.value;
                optionInteger.value = (Integer)optionInteger.value + 1;
                optionInteger = this.gameSettings.thirdPersonView;
                optionInteger.value = (Integer)optionInteger.value % 3;
            }
            if (this.controllerInput.digitalPad.right.pressedThisFrame()) {
                this.thePlayer.displayGuidebookScreen();
            }
        } else {
            try {
                this.currentScreen.controllerInput(controller);
            }
            catch (Exception e) {
                LOGGER.error("Exception occurred while running gui specific controller actions!", e);
            }
        }
    }

    private void forceReload() {
        long start = System.nanoTime();
        LOGGER.info("FORCING RELOAD!");
        this.sndManager = new SoundEngine();
        this.sndManager.init(this.gameSettings);
        this.texturePackList.refresh();
        this.renderer.reload();
        if (this.renderGlobal != null) {
            this.renderGlobal.loadRenderers();
        }
        LOGGER.debug("RELOAD TOOK '{}' SECONDS!", (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    public boolean isMultiplayerWorld() {
        return this.currentWorld != null && this.currentWorld.isClientSide;
    }

    public void startWorld(String worldDirName, String worldName, long seed) {
        this.startWorld(worldDirName, worldName, seed, null);
    }

    public void startWorld(String worldDirName, String worldName, long seed, WorldTypeGroups.Group worldTypeGroup) {
        this.changeWorld(null);
        System.gc();
        int worldSaveVersion = 0;
        try {
            LevelData info = new LevelData(new File(this.mcDataDir, "saves/" + worldDirName));
            worldSaveVersion = info.getSaveVersion();
        }
        catch (IOException e) {
            worldSaveVersion = this.saveFormat.getSaveVersion();
        }
        if (worldSaveVersion < 19134) {
            this.convertSaveVersion(worldSaveVersion, worldDirName, worldName);
        } else {
            I18n i18n = I18n.getInstance();
            LevelStorage saveHandler = this.saveFormat.getSaveHandler(worldDirName, false);
            if (worldTypeGroup != null) {
                for (Dimension dimension : Dimension.getDimensionList().values()) {
                    WorldType worldType = worldTypeGroup.get(dimension);
                    if (worldType == null) continue;
                    DimensionData data = saveHandler.getDimensionData(dimension.id);
                    if (data == null) {
                        data = new DimensionData(worldType);
                    } else {
                        data.setWorldType(worldType);
                    }
                    saveHandler.saveDimensionData(dimension.id, data);
                }
            }
            WorldClient world = new WorldClient(saveHandler, worldName, seed, null, null);
            if (world.isNewWorld) {
                this.statsCounter.add(StatList.createWorldStat, 1);
                this.statsCounter.add(StatList.startGameStat, 1);
                this.changeWorld(world, i18n.translateKey("gui.loading.label.generating"));
            } else {
                this.statsCounter.add(StatList.loadWorldStat, 1);
                this.statsCounter.add(StatList.startGameStat, 1);
                this.changeWorld(world, i18n.translateKey("gui.loading.label.loading"));
            }
        }
    }

    public void usePortal(int dim, @Nullable DyeColor portalColor) {
        double dz;
        double dy;
        double dx;
        double distSqr;
        Dimension lastDim = Dimension.getDimensionList().get(this.thePlayer.dimension);
        Dimension newDim = Dimension.getDimensionList().get(dim);
        LOGGER.info("Switching to dimension \"{}\"!!", (Object)newDim.getTranslatedName());
        this.thePlayer.dimension = dim;
        this.currentWorld.setEntityDead(this.thePlayer);
        this.thePlayer.removed = false;
        double x = this.thePlayer.x;
        double z = this.thePlayer.z;
        double y = this.thePlayer.y;
        this.thePlayer.moveTo(x *= (double)Dimension.getCoordScale(lastDim, newDim), y, z *= (double)Dimension.getCoordScale(lastDim, newDim), this.thePlayer.yRot, this.thePlayer.xRot);
        ChunkCoordinates newCoordinates = new ChunkCoordinates(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
        if (this.thePlayer.isAlive() && this.thePlayer.dimensionEnterCoordinate != null && (distSqr = (dx = (double)this.thePlayer.dimensionEnterCoordinate.x - x) * dx + (dy = (double)this.thePlayer.dimensionEnterCoordinate.y - y) * dy + (dz = (double)this.thePlayer.dimensionEnterCoordinate.z - z) * dz) > 6.4E7) {
            this.thePlayer.addStat(Achievements.FAST_TRAVEL, 1);
        }
        this.thePlayer.dimensionEnterCoordinate = newCoordinates;
        if (this.thePlayer.isAlive()) {
            this.currentWorld.updateEntityWithOptionalForce(this.thePlayer, false);
        }
        WorldClient world = new WorldClient(this.currentWorld, newDim);
        I18n i18n = I18n.getInstance();
        if (newDim == lastDim.homeDim) {
            this.changeWorld(world, i18n.translateKeyAndFormat("gui.loading.label.leaving", lastDim.getTranslatedName()), this.thePlayer);
        } else {
            this.changeWorld(world, i18n.translateKeyAndFormat("gui.loading.label.entering", newDim.getTranslatedName()), this.thePlayer);
        }
        this.thePlayer.world = this.currentWorld;
        if (this.thePlayer.isAlive()) {
            this.thePlayer.moveTo(x, y, z, this.thePlayer.yRot, this.thePlayer.xRot);
            this.currentWorld.updateEntityWithOptionalForce(this.thePlayer, false);
            new PortalHandler().teleportEntity(this.currentWorld, this.thePlayer, portalColor, lastDim, newDim);
        }
    }

    public void changeWorld(WorldClient world) {
        this.changeWorld(world, "");
    }

    public void changeWorld(WorldClient world, String loadingTitle) {
        this.changeWorld(world, loadingTitle, null);
    }

    public void changeWorld(WorldClient world, String loadingTitle, Player player) {
        this.mainMenuBackground.deleteTextures();
        this.gameSettings.showCollisionBoxes.value = false;
        this.fullbright = false;
        this.statsCounter.fetchStats();
        this.statsCounter.saveStats();
        if (world != null) {
            this.loadingScreen.updateLoadingBackground(world.dimension);
            this.loadingScreen.progressStart(loadingTitle);
            this.loadingScreen.progressStage("");
        }
        this.sndManager.stopMusic();
        if (this.currentWorld != null) {
            this.currentWorld.saveWorldIndirectly(this.loadingScreen);
            if (this.currentWorld.saveHandler != null) {
                IChunkLoader loader = this.currentWorld.saveHandler.getChunkLoader(this.currentWorld.dimension);
                if (loader != null) {
                    while (loader.isSaving()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                this.currentWorld.getChunkProvider().unloadAllChunks();
                this.currentWorld.onUnload();
            }
        }
        this.currentWorld = world;
        if (this.currentWorld != null) {
            Colorizers.update(true);
        }
        if (world != null) {
            this.playerController.initWorld(world);
            if (!this.isMultiplayerWorld()) {
                if (player == null) {
                    this.thePlayer = (PlayerLocal)world.findSubclassOf(PlayerLocal.class);
                }
            } else if (this.thePlayer != null) {
                this.thePlayer.resetPos();
                world.entityJoinedWorld(this.thePlayer);
            }
            if (!world.isClientSide) {
                this.prepareLevel(loadingTitle);
            }
            if (this.thePlayer == null) {
                this.thePlayer = (PlayerLocal)this.playerController.createPlayer(world);
                this.thePlayer.resetPos();
                this.playerController.initPlayer(this.thePlayer);
            }
            this.thePlayer.input = new PlayerInput(this);
            if (this.renderGlobal != null) {
                this.renderGlobal.changeWorld(world);
            }
            if (this.particleEngine != null) {
                this.particleEngine.setWorld(world);
            }
            this.playerController.adjustPlayer(this.thePlayer);
            IChunkProvider ichunkprovider = world.getChunkProvider();
            int i = MathHelper.floor_float((int)this.thePlayer.x) >> 4;
            int j = MathHelper.floor_float((int)this.thePlayer.z) >> 4;
            ichunkprovider.setCurrentChunkOver(i, j);
            world.spawnPlayerWithLoadedChunks(this.thePlayer);
            if (world.isNewWorld) {
                world.saveWorldIndirectly(this.loadingScreen);
            }
            this.activeCamera = new EntityCameraFirstPerson(this, this.thePlayer);
            this.thePlayer.syncPlacementMode();
        } else {
            this.thePlayer = null;
        }
        System.gc();
        this.systemTime = 0L;
        if (world != null) {
            this.loadingScreen.progressStop();
        }
        this.worldRenderer.lightmapHelper.setup();
    }

    private void convertSaveVersion(int fromVersion, String worldDirName, String worldName) {
        ISaveFormat fromWorldFormat = SaveFormats.createSaveFormat(fromVersion, new File(this.mcDataDir, "saves"));
        if (fromWorldFormat != null) {
            ISaveFormat toWorldFormat;
            ISaveConverter converterToUse = null;
            for (ISaveConverter converter : SaveConverters.saveConverters) {
                if (converter.fromVersion() != fromVersion || converterToUse != null && converter.toVersion() <= converterToUse.toVersion()) continue;
                converterToUse = converter;
            }
            if (converterToUse != null && (toWorldFormat = SaveFormats.createSaveFormat(converterToUse.toVersion(), new File(this.mcDataDir, "saves"))) != null) {
                this.loadingScreen.updateLoadingBackground(null);
                this.loadingScreen.progressStartNoAbort("Converting world from " + fromWorldFormat.getFormatName() + " to " + toWorldFormat.getFormatName() + ".");
                this.loadingScreen.progressStage("This may take a while :)");
                CompoundTag levelDataTag = toWorldFormat.getLevelDataRaw(worldDirName);
                converterToUse.convertSave(levelDataTag, new File(this.mcDataDir, "saves"), worldDirName, this.loadingScreen);
                this.loadingScreen.progressStop();
                levelDataTag.putInt("version", toWorldFormat.getSaveVersion());
                LevelStorage saveHandler = toWorldFormat.getSaveHandler(worldDirName, false);
                saveHandler.saveLevelDataRaw(levelDataTag);
                this.startWorld(worldDirName, worldName, 0L);
            }
        }
    }

    private void prepareLevel(String loadingTitle) {
        this.loadingScreen.updateLoadingBackground(this.currentWorld.dimension);
        this.loadingScreen.progressStartNoAbort(loadingTitle);
        this.loadingScreen.progressStage("Building terrain");
        int c = 128;
        int i = 0;
        int j = c * 2 / 16 + 1;
        j *= j;
        IChunkProvider ichunkprovider = this.currentWorld.getChunkProvider();
        ChunkCoordinates chunkcoordinates = this.currentWorld.getSpawnPoint();
        if (this.thePlayer != null) {
            chunkcoordinates.x = (int)this.thePlayer.x;
            chunkcoordinates.z = (int)this.thePlayer.z;
        }
        ichunkprovider.setCurrentChunkOver(Math.floorDiv(chunkcoordinates.x, 16), Math.floorDiv(chunkcoordinates.z, 16));
        for (int k = -c; k <= c; k += 16) {
            for (int l = -c; l <= c; l += 16) {
                this.loadingScreen.progressStagePercentage(i++ * 100 / j);
                this.currentWorld.getBlockId(chunkcoordinates.x + k, 64, chunkcoordinates.z + l);
                while (this.currentWorld.updatingLighting()) {
                }
            }
        }
        this.loadingScreen.progressStage("Simulating world for a bit...");
        this.loadingScreen.progressStop();
        this.currentWorld.dropOldChunks();
    }

    public String getRendererDebugInfo() {
        return this.renderGlobal.getRendererDebugInfo();
    }

    public String getEntityDebugInfoString() {
        return this.renderGlobal.getEntityDebugInfo();
    }

    public String getChunkProviderInfoString() {
        return this.currentWorld.getChunkProviderInfoString();
    }

    public String getEntityCountsInfoString() {
        return "P: " + this.particleEngine.countParticles() + ". T: " + this.currentWorld.getNumLoadedEntitiesString();
    }

    public void respawn(boolean multiplayer, int targetDimension) {
        @Nullable PlayerLocal previousPlayer = this.thePlayer;
        if (!this.currentWorld.isClientSide && !this.currentWorld.dimension.defaultWorldType.mayRespawn()) {
            this.usePortal(targetDimension, null);
        }
        ChunkCoordinates spawnCoordinates = null;
        ChunkCoordinates bedSpawnCoordinates = null;
        ChunkCoordinates lastDeathCoordinates = null;
        boolean canRespawnAtBed = true;
        if (this.thePlayer != null && !multiplayer) {
            spawnCoordinates = this.thePlayer.getPlayerSpawnCoordinate();
            lastDeathCoordinates = this.thePlayer.getLastDeathCoordinate();
            if (spawnCoordinates != null && (bedSpawnCoordinates = Player.getValidBedSpawnCoordinates(this.currentWorld, spawnCoordinates)) == null) {
                this.thePlayer.sendTranslatedChatMessage("bed.notValid");
            }
        }
        if (bedSpawnCoordinates == null) {
            bedSpawnCoordinates = this.currentWorld.getSpawnPoint();
            canRespawnAtBed = false;
        }
        IChunkProvider ichunkprovider = this.currentWorld.getChunkProvider();
        ichunkprovider.setCurrentChunkOver(bedSpawnCoordinates.x >> 4, bedSpawnCoordinates.z >> 4);
        this.currentWorld.getRespawnLocation();
        this.currentWorld.updateEntityList();
        int j = 0;
        Gamemode playerGamemode = Gamemode.survival;
        if (this.thePlayer != null) {
            j = this.thePlayer.id;
            this.currentWorld.setEntityDead(this.thePlayer);
            playerGamemode = this.thePlayer.getGamemode();
        }
        this.thePlayer = (PlayerLocal)this.playerController.createPlayer(this.currentWorld);
        this.thePlayer.dimension = targetDimension;
        this.thePlayer.setGamemode(playerGamemode);
        if (previousPlayer != null && previousPlayer.getHeldObject() != null) {
            this.thePlayer.setHeldObject(previousPlayer.getHeldObject());
            this.thePlayer.inventory.setCurrentItemIndex(previousPlayer.inventory.getCurrentItemIndex(), true);
            this.thePlayer.inventory.setHotbarOffset(previousPlayer.inventory.getHotbarOffset(), true);
        }
        this.activeCamera = new EntityCameraFirstPerson(this, this.thePlayer);
        this.thePlayer.resetPos();
        if (previousPlayer != null) {
            this.thePlayer.messageHistory = previousPlayer.messageHistory;
            if (!this.currentWorld.isClientSide) {
                this.thePlayer.inventory.transferAllContents(previousPlayer.inventory);
            }
        }
        if (canRespawnAtBed) {
            this.thePlayer.setPlayerSpawnCoordinate(spawnCoordinates);
            this.thePlayer.moveTo((float)bedSpawnCoordinates.x + 0.5f, (float)bedSpawnCoordinates.y + 0.1f, (float)bedSpawnCoordinates.z + 0.5f, 0.0f, 0.0f);
        }
        this.thePlayer.setLastDeathCoordinate(lastDeathCoordinates);
        this.playerController.initPlayer(this.thePlayer);
        this.currentWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.input = new PlayerInput(this);
        this.thePlayer.id = j;
        this.thePlayer.animate4();
        this.playerController.adjustPlayer(this.thePlayer);
        this.prepareLevel("Respawning");
        if (this.currentScreen instanceof ScreenGameOver) {
            this.displayScreen(null);
        }
    }

    public PacketHandlerClient getSendQueue() {
        if (this.thePlayer instanceof PlayerLocalMultiplayer) {
            return ((PlayerLocalMultiplayer)this.thePlayer).sendQueue;
        }
        return null;
    }

    public void setRenderer(Renderer renderer) {
        if (this.renderer != null) {
            this.renderer.delete();
        }
        this.renderer = renderer;
        this.renderer.reload();
    }

    public static void startMainThread(@Nullable String username, @Nullable String sessionId, @Nullable String uuid, @Nullable String server, @Nullable Integer port, @Nullable Integer width, @Nullable Integer height) {
        GameWindowGLFW gameWindow = new GameWindowGLFW();
        Minecraft mc = new Minecraft(gameWindow, false);
        mc.minecraftUri = "www.minecraft.net";
        String string = sessionId = sessionId == null ? "" : sessionId;
        if (uuid == null) {
            UUID nameUUID;
            if (username != null && (nameUUID = UUIDHelper.getUUIDFromName(username)) != null) {
                uuid = nameUUID.toString();
            }
            if (uuid == null) {
                uuid = "00000000-0000-0000-0000-000000000000";
            }
        }
        username = username == null ? "Player" + System.currentTimeMillis() % 1000L : username;
        mc.session = new Session(username, uuid, sessionId);
        if (server != null) {
            mc.setServer(server, port == null ? 25565 : port);
        }
        if (width != null) {
            mc.overrideWidth = width;
        }
        if (height != null) {
            mc.overrideHeight = height;
        }
        mc.run();
    }

    public static void main(String[] args) {
        Minecraft.checkLwjglVersion();
        if (Minecraft.isClientASteamDeck()) {
            System.out.println("Client is a Steam Deck!");
        }
        String playerName = null;
        String sessionId = null;
        Object gameDirectory = null;
        String uuid = null;
        String server = null;
        Integer port = null;
        Integer width = null;
        Integer height = null;
        int pointer = 0;
        block36: while (pointer < args.length) {
            switch (args[pointer]) {
                case "--username": {
                    try {
                        playerName = args[pointer + 1];
                        ++pointer;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pointer;
                    continue block36;
                }
                case "--session": {
                    try {
                        sessionId = args[pointer + 1];
                        ++pointer;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pointer;
                    continue block36;
                }
                case "--uuid": {
                    try {
                        uuid = args[pointer + 1];
                        ++pointer;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pointer;
                    continue block36;
                }
                case "--gameDir": {
                    try {
                        minecraftDir = new File(args[pointer + 1]);
                        ++pointer;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pointer;
                    continue block36;
                }
                case "--server": {
                    try {
                        server = args[pointer + 1];
                        ++pointer;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pointer;
                    continue block36;
                }
                case "--port": {
                    try {
                        port = Integer.parseInt(args[pointer + 1]);
                        ++pointer;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pointer;
                    continue block36;
                }
                case "--width": {
                    try {
                        width = Integer.parseInt(args[pointer + 1]);
                        ++pointer;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pointer;
                    continue block36;
                }
                case "--height": {
                    try {
                        height = Integer.parseInt(args[pointer + 1]);
                        ++pointer;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pointer;
                    continue block36;
                }
            }
            ++pointer;
        }
        Minecraft.startMainThread(playerName, sessionId, uuid, server, port, width, height);
    }

    public void setInputType(InputType inputType) {
        if (inputType != this.inputType) {
            LOGGER.info("Set input type to {}", (Object)inputType.name());
        }
        this.inputType = inputType;
        if (inputType == InputType.CONTROLLER) {
            this.mouseInput.grabCursor();
        }
        if (inputType == InputType.KEYBOARD) {
            if (this.inGameHasFocus && !Mouse.isGrabbed()) {
                this.mouseInput.grabCursor();
            }
            if (!this.inGameHasFocus && Mouse.isGrabbed()) {
                this.mouseInput.releaseCursor();
            }
        }
    }

    @Override
    public SkinVariantList getSkinVariantList() {
        return this.skinVariantList;
    }

    @Override
    public Collection<String> getAvailableSoundKeys() {
        return SoundRepository.allKeys;
    }

    public boolean isAmbientOcclusionEnabled() {
        return (Boolean)this.gameSettings.ambientOcclusion.value;
    }

    public boolean isTreeShadingEnabled() {
        return (Boolean)this.gameSettings.treeShadows.value;
    }

    public boolean isDebugInfoEnabled() {
        return (Boolean)this.gameSettings.showDebugScreen.value;
    }

    @Override
    public boolean isFullbrightEnabled() {
        return this.fullbright;
    }

    public boolean canRenderEntityLabel() {
        return this.isDebugInfoEnabled() && this.thePlayer != null && this.thePlayer.getGamemode() == Gamemode.creative;
    }

    public float getOutlineWidth() {
        return ((Float)Minecraft.INSTANCE.gameSettings.blockOutlineWidth.value).floatValue();
    }

    @Override
    public int getAutosaveTimer() {
        return INSTANCE != null ? (int)(((Float)Minecraft.INSTANCE.gameSettings.autosaveTimer.value).floatValue() * 24.0f) * 5 : 0;
    }

    @Override
    public void copyToClipboard(String str) {
        GLFW.glfwSetClipboardString((long)this.gameWindow.getHandle(), (CharSequence)str);
    }

    @Override
    public String readFromClipboard() {
        return GLFW.glfwGetClipboardString((long)this.gameWindow.getHandle());
    }

    public static Minecraft getMinecraft() {
        return INSTANCE;
    }

    static {
        numRecordedFrameTimes = 0;
        hasPaidCheckTime = 0L;
        minecraftDir = null;
        System.setProperty("java.awt.headless", "true");
    }
}

