/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.glfw;

import java.nio.ByteBuffer;
import net.minecraft.client.input.Gamepad;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;

public class GlfwGamepad
implements Gamepad {
    private final int id;
    private final int vid;
    private final int did;
    private GLFWGamepadState state = null;

    public GlfwGamepad(int id) {
        int did;
        int vid;
        this.id = id;
        String guid = this.getGuid();
        try {
            String lower = guid.substring(8, 10);
            String upper = guid.substring(10, 12);
            vid = Integer.parseInt(upper + lower, 16);
        }
        catch (Exception e) {
            System.out.println("Controller " + id + " has weird GUID!");
            this.vid = 0;
            this.did = 0;
            return;
        }
        try {
            String lower = guid.substring(16, 18);
            String upper = guid.substring(18, 20);
            did = Integer.parseInt(upper + lower, 16);
        }
        catch (Exception e) {
            System.out.println("Controller " + id + " has weird GUID!");
            this.vid = 0;
            this.did = 0;
            return;
        }
        this.vid = vid;
        this.did = did;
    }

    public int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getGuid() {
        return GLFW.glfwGetJoystickGUID((int)this.id);
    }

    @Override
    public int getVendorId() {
        return this.vid;
    }

    @Override
    public int getDeviceId() {
        return this.did;
    }

    @Override
    public void poll() {
        this.state = new GLFWGamepadState(ByteBuffer.allocateDirect(GLFWGamepadState.SIZEOF));
        GLFW.glfwGetGamepadState((int)this.getId(), (GLFWGamepadState)this.state);
    }

    @Override
    public boolean hasAnyInput() {
        int i;
        for (i = 0; i <= 14; ++i) {
            if (!this.isButtonPressed(i)) continue;
            return true;
        }
        for (i = 0; i <= 3; ++i) {
            if (!(Math.abs(this.getAxisValue(i)) > 0.5f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPresent() {
        return GLFW.glfwJoystickPresent((int)this.id);
    }

    @Override
    @NotNull
    public String getName() {
        if (this.getVendorId() == 29813) {
            return GLFW.glfwGetJoystickName((int)this.getId()) + " " + this.getId();
        }
        return GLFW.glfwGetGamepadName((int)this.getId());
    }

    @Override
    public float getAxisValue(int axis) {
        if (this.state != null && axis >= 0 && axis < this.state.axes().capacity()) {
            return this.state.axes().get(axis);
        }
        return 0.0f;
    }

    @Override
    public boolean isButtonPressed(int button) {
        if (this.state != null && button >= 0 && button < this.state.buttons().capacity()) {
            return this.state.buttons().get(button) == 1;
        }
        return false;
    }
}

