/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicBasket;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockModelBasket<T extends BlockLogicBasket>
extends BlockModelStandard<T> {
    protected IconCoordinate fillTexture = TextureRegistry.getTexture("minecraft:block/basket/fill");

    public BlockModelBasket(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        AABB bounds = this.block.getBounds();
        float onePix = 0.0625f;
        float basketHeight = 1.0f;
        bounds.set(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        renderBlocks.setRenderSide(Side.EAST, false);
        renderBlocks.setRenderSide(Side.WEST, false);
        renderBlocks.setRenderSide(Side.BOTTOM, false);
        bounds.set(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        bounds.set(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        BlockModelBasket.renderBlocks.renderBitMask = 0;
        renderBlocks.setRenderSide(Side.NORTH, false);
        renderBlocks.setRenderSide(Side.SOUTH, false);
        renderBlocks.setRenderSide(Side.BOTTOM, false);
        bounds.set(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        bounds.set(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        bounds.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        BlockModelBasket.renderBlocks.renderBitMask = 0;
        int height = ((BlockLogicBasket)this.block.getLogic()).getFillLevel(worldSource, x, y, z);
        if (height > 0) {
            renderBlocks.renderTopFace(tessellator, bounds, x, (float)(y - 1) + 0.0625f + 0.0625f * (float)height, z, this.fillTexture);
        }
        bounds.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

