/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFenceGate;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.DisplayPos;

public class BlockModelFenceGate<T extends BlockLogicFenceGate>
extends BlockModelStandard<T> {
    protected static final DisplayPos FENCE_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 135.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos FENCE_HEAD = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, 90.0f, 0.0f, 1.0f, 1.0f, 1.0f);

    public BlockModelFenceGate(Block<T> block) {
        super(block);
        this.setDisplayPos("gui", FENCE_GUI);
        this.setDisplayPos("head", FENCE_HEAD);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        AABB bounds = this.block.getBounds();
        boolean flag = true;
        int l = worldSource.getBlockMetadata(x, y, z);
        boolean flag1 = BlockLogicFenceGate.isOpen(l);
        int i1 = BlockLogicFenceGate.getDirection(l);
        if (i1 == 3 || i1 == 1) {
            float f = 0.4375f;
            float f4 = 0.5625f;
            float f8 = 0.0f;
            float f12 = 0.125f;
            bounds.set(f, 0.3125, f8, f4, 1.0, f12);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            f8 = 0.875f;
            f12 = 1.0f;
            bounds.set(f, 0.3125, f8, f4, 1.0, f12);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        } else {
            float f1 = 0.0f;
            float f5 = 0.125f;
            float f9 = 0.4375f;
            float f13 = 0.5625f;
            bounds.set(f1, 0.3125, f9, f5, 1.0, f13);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            f1 = 0.875f;
            f5 = 1.0f;
            bounds.set(f1, 0.3125, f9, f5, 1.0, f13);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        if (!flag1) {
            if (i1 == 3 || i1 == 1) {
                float f2 = 0.4375f;
                float f6 = 0.5625f;
                float f10 = 0.375f;
                float f14 = 0.5f;
                bounds.set(f2, 0.375, f10, f6, 0.9375, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
                f10 = 0.5f;
                f14 = 0.625f;
                bounds.set(f2, 0.375, f10, f6, 0.9375, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
                f10 = 0.625f;
                f14 = 0.875f;
                bounds.set(f2, 0.375, f10, f6, 0.5625, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
                bounds.set(f2, 0.75, f10, f6, 0.9375, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
                f10 = 0.125f;
                f14 = 0.375f;
                bounds.set(f2, 0.375, f10, f6, 0.5625, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
                bounds.set(f2, 0.75, f10, f6, 0.9375, f14);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            } else {
                float f3 = 0.375f;
                float f7 = 0.5f;
                float f11 = 0.4375f;
                float f15 = 0.5625f;
                bounds.set(f3, 0.375, f11, f7, 0.9375, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
                f3 = 0.5f;
                f7 = 0.625f;
                bounds.set(f3, 0.375, f11, f7, 0.9375, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
                f3 = 0.625f;
                f7 = 0.875f;
                bounds.set(f3, 0.375, f11, f7, 0.5625, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
                bounds.set(f3, 0.75, f11, f7, 0.9375, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
                f3 = 0.125f;
                f7 = 0.375f;
                bounds.set(f3, 0.375, f11, f7, 0.5625, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
                bounds.set(f3, 0.75, f11, f7, 0.9375, f15);
                renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            }
        } else if (i1 == 3) {
            bounds.set(0.8125, 0.375, 0.0, 0.9375, 0.9375, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.8125, 0.375, 0.875, 0.9375, 0.9375, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.5625, 0.375, 0.0, 0.8125, 0.5625, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.5625, 0.375, 0.875, 0.8125, 0.5625, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.5625, 0.75, 0.0, 0.8125, 0.9375, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.5625, 0.75, 0.875, 0.8125, 0.9375, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        } else if (i1 == 1) {
            bounds.set(0.0625, 0.375, 0.0, 0.1875, 0.9375, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.0625, 0.375, 0.875, 0.1875, 0.9375, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.1875, 0.375, 0.0, 0.4375, 0.5625, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.1875, 0.375, 0.875, 0.4375, 0.5625, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.1875, 0.75, 0.0, 0.4375, 0.9375, 0.125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.1875, 0.75, 0.875, 0.4375, 0.9375, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        } else if (i1 == 0) {
            bounds.set(0.0, 0.375, 0.8125, 0.125, 0.9375, 0.9375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.875, 0.375, 0.8125, 1.0, 0.9375, 0.9375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.0, 0.375, 0.5625, 0.125, 0.5625, 0.8125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.875, 0.375, 0.5625, 1.0, 0.5625, 0.8125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.0, 0.75, 0.5625, 0.125, 0.9375, 0.8125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.875, 0.75, 0.5625, 1.0, 0.9375, 0.8125);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        } else if (i1 == 2) {
            bounds.set(0.0, 0.375, 0.0625, 0.125, 0.9375, 0.1875);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.875, 0.375, 0.0625, 1.0, 0.9375, 0.1875);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.0, 0.375, 0.1875, 0.125, 0.5625, 0.4375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.875, 0.375, 0.1875, 1.0, 0.5625, 0.4375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.0, 0.75, 0.1875, 0.125, 0.9375, 0.4375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
            bounds.set(0.875, 0.75, 0.1875, 1.0, 0.9375, 0.4375);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        return flag;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (BlockModelFenceGate.renderBlocks.useInventoryTint) {
            int j = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata, 0);
            float f1 = (float)(j >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(j >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(j & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f1 * brightness), (float)(f3 * brightness), (float)(f5 * brightness), (float)alpha);
        }
        for (int k1 = 0; k1 < 3; ++k1) {
            float f6 = 0.0625f;
            AABB bounds = this.block.getBounds();
            if (k1 == 0) {
                bounds.set(0.5f - f6, 0.3f, 0.0, 0.5f + f6, 1.0, f6 * 2.0f);
            }
            if (k1 == 1) {
                bounds.set(0.5f - f6, 0.3f, 1.0f - f6 * 2.0f, 0.5f + f6, 1.0, 1.0);
            }
            if (k1 == 2) {
                bounds.set(0.5f - f6, 0.5, 0.0, 0.5f + f6, 1.0f - f6, 1.0);
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }
}

