/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.Nullable;

public class BlockModelPlanksPainted<T extends BlockLogic>
extends BlockModelStandard<T> {
    public static final IconCoordinate[] texCoords = new IconCoordinate[16];

    public BlockModelPlanksPainted(Block<T> block) {
        super(block);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int meta) {
        return texCoords[meta & 0xF];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            BlockModelPlanksPainted.texCoords[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/planks/" + c.colorID);
        }
    }
}

