/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.colorizer;

import com.mojang.logging.LogUtils;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.colorizer.ColorMap;
import net.minecraft.client.render.colorizer.Colorizer;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.SeasonManagerCycle;
import net.minecraft.core.world.season.Seasons;
import org.slf4j.Logger;

public class Colorizers {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Minecraft mc;
    private static List<Colorizer> allColorizers;
    public static Colorizer grass;
    public static Colorizer water;
    public static Colorizer sky;
    public static Colorizer stars;
    public static Colorizer fog;
    public static Colorizer oak;
    public static Colorizer birch;
    public static Colorizer pine;
    public static Colorizer cherry;
    public static Colorizer shrub;
    public static Colorizer eucalyptus;
    public static Colorizer cacao;
    public static Colorizer thorn;
    public static Colorizer palm;
    public static Colorizer crystal;
    private static Dimension lastDimension;
    private static Season lastSeason;
    private static float lastSeasonProgress;
    private static float fadeDuration;

    public static void init(Minecraft minecraft) {
        mc = minecraft;
        Colorizers.registerColorizers();
    }

    public static void reload() {
        List<Season> seasons = Seasons.getAllSeasons();
        for (int i = 0; i < allColorizers.size(); ++i) {
            Colorizer colorizer = allColorizers.get(i);
            colorizer.setup(mc, seasons);
            TexturePack texturePack = colorizer.getTexturePack();
            if (texturePack == null) continue;
            LOGGER.info("Using {} color from texture pack {}", (Object)colorizer.name, (Object)texturePack.fileName);
        }
    }

    public static void registerColorizers() {
        allColorizers = new ArrayList<Colorizer>();
        grass = Colorizers.add(new Colorizer("grass"));
        water = Colorizers.add(new Colorizer("water"));
        sky = Colorizers.add(new Colorizer("sky"));
        stars = Colorizers.add(new Colorizer("stars"));
        fog = Colorizers.add(new Colorizer("fog"));
        oak = Colorizers.add(new Colorizer("oak"));
        birch = Colorizers.add(new Colorizer("birch"));
        pine = Colorizers.add(new Colorizer("pine"));
        cherry = Colorizers.add(new Colorizer("cherry"));
        shrub = Colorizers.add(new Colorizer("shrub"));
        eucalyptus = Colorizers.add(new Colorizer("eucalyptus"));
        cacao = Colorizers.add(new Colorizer("cacao"));
        thorn = Colorizers.add(new Colorizer("thorn"));
        palm = Colorizers.add(new Colorizer("palm"));
        crystal = Colorizers.add(new Colorizer("crystal"));
    }

    public static void update(boolean force) {
        float blendFactor;
        Season season2;
        Season season1;
        WorldClient world = Colorizers.mc.currentWorld;
        if (world == null) {
            lastDimension = null;
            return;
        }
        Season currentSeason = world.seasonManager.getCurrentSeason();
        Dimension currentDimension = world.dimension;
        float seasonProgress = Colorizers.getSeasonProgress(world);
        boolean update = force ? true : (currentDimension != lastDimension ? true : (currentSeason != lastSeason ? true : seasonProgress != lastSeasonProgress));
        if (!update) {
            return;
        }
        if (currentDimension != lastDimension) {
            Colorizers.reload();
        }
        lastDimension = currentDimension;
        lastSeason = currentSeason;
        lastSeasonProgress = seasonProgress;
        LOGGER.info("Updating Colorizers");
        float fadeDurationInverse = 1.0f - fadeDuration;
        if (seasonProgress == 0.5f) {
            for (int i = 0; i < allColorizers.size(); ++i) {
                allColorizers.get(i).update(currentDimension, currentSeason, currentSeason, 0.5f);
            }
            return;
        }
        if (seasonProgress < 0.5f) {
            season1 = world.getSeasonManager().getPreviousSeason();
            season2 = currentSeason;
            if (fadeDuration == 0.0f) {
                blendFactor = 1.0f;
            } else {
                blendFactor = seasonProgress * 2.0f;
                blendFactor /= fadeDuration;
                blendFactor = MathHelper.clamp(blendFactor, 0.0f, 1.0f);
                blendFactor = blendFactor * 0.5f + 0.5f;
            }
        } else {
            season1 = currentSeason;
            season2 = world.getSeasonManager().getNextSeason();
            blendFactor = seasonProgress - 0.5f;
            if (fadeDuration == 0.0f) {
                blendFactor = 0.0f;
            } else if (fadeDuration != 1.0f) {
                blendFactor = (seasonProgress - 0.5f) * 2.0f;
                blendFactor /= fadeDurationInverse;
                blendFactor -= 1.0f / fadeDurationInverse * fadeDuration;
                blendFactor = MathHelper.clamp(blendFactor, 0.0f, 1.0f);
            }
        }
        for (int i = 0; i < allColorizers.size(); ++i) {
            allColorizers.get(i).update(currentDimension, season1, season2, blendFactor);
        }
    }

    public static Colorizer add(Colorizer colorizer) {
        allColorizers.add(colorizer);
        return colorizer;
    }

    public static TexturePack findTexturePackWithFile(Minecraft mc, String path) {
        ArrayList<TexturePack> texturePacks = new ArrayList<TexturePack>();
        texturePacks.add(mc.texturePackList.getDefaultTexturePack());
        texturePacks.addAll(mc.texturePackList.selectedPacks);
        for (int i = texturePacks.size() - 1; i >= 0; --i) {
            TexturePack texturePack = (TexturePack)texturePacks.get(i);
            if (!texturePack.hasFile(path)) continue;
            return texturePack;
        }
        return null;
    }

    public static ColorMap loadColorData(TexturePack texturePack, String path) {
        if (texturePack == null) {
            throw new NullPointerException();
        }
        InputStream in = null;
        BufferedImage image = null;
        try {
            in = texturePack.getResourceAsStream(path);
            if (in == null) {
                ColorMap colorMap = null;
                return colorMap;
            }
            image = ImageIO.read(in);
        }
        catch (Exception e) {
            throw new RuntimeException("Loading colormap: '" + path + "'", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        ColorMap colorMap = new ColorMap();
        if (image.getWidth() == 1 && image.getHeight() == 1) {
            int rgb = image.getRGB(0, 0);
            for (int i = 0; i < colorMap.buffer.length; ++i) {
                colorMap.buffer[i] = rgb;
            }
            return colorMap;
        }
        if (image.getWidth() != 256 || image.getHeight() != 256) {
            BufferedImage fixedImage = new BufferedImage(256, 256, 1);
            Graphics g = fixedImage.getGraphics();
            g.drawImage(image, 0, 0, 256, 256, null);
            g.dispose();
            image = fixedImage;
        }
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                int rgb;
                colorMap.buffer[y << 8 | x] = rgb = image.getRGB(x, y);
            }
        }
        return colorMap;
    }

    public static float getSeasonProgress(World world) {
        if (world.seasonManager instanceof SeasonManagerCycle) {
            SeasonManagerCycle seasonManager = (SeasonManagerCycle)world.seasonManager;
            Season currentSeason = seasonManager.getCurrentSeason();
            int dayInSeason = seasonManager.getDayInSeason();
            int dayLengthTicks = 24000;
            int seasonLengthDays = seasonManager.getSeasonLengthTicks(currentSeason) / dayLengthTicks;
            return (float)dayInSeason / (float)seasonLengthDays;
        }
        return 0.5f;
    }

    static {
        allColorizers = null;
        fadeDuration = 1.0f;
    }
}

