/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.animal.MobButterfly;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class MobRendererButterfly
extends EntityRenderer<MobButterfly> {
    private static final Random sizeRandom = new Random();

    @Override
    public void render(Tessellator tessellator, MobButterfly butterfly, double x, double y, double z, float yaw, float partialTick) {
        sizeRandom.setSeed((long)butterfly.getSkinVariant() << 16);
        float scale = 0.45f + sizeRandom.nextFloat() * 0.35f;
        float yRot = MathHelper.lerp(butterfly.yRotO, butterfly.yRot, partialTick);
        MobRendererButterfly.drawButterfly(tessellator, butterfly.tickCount, scale, yRot, x, y, z, partialTick, this.renderDispatcher.textureManager, this.getTexture(butterfly));
    }

    @Override
    public void renderPreview(Tessellator tessellator, MobButterfly butterfly, double x, double y, double z, float yaw, float partialTick) {
        float yRot = MathHelper.lerp(butterfly.yRotO, butterfly.yRot, partialTick);
        MobRendererButterfly.drawButterfly(tessellator, butterfly.tickCount, 1.25f, -yRot, x, y + 0.5, z, partialTick, this.renderDispatcher.textureManager, this.getTexture(butterfly));
    }

    public static void drawButterfly(Tessellator tessellator, int ticksAlive, float scale, float yRot, double x, double y, double z, float partialTick, TextureManager textureManager, String texture) {
        textureManager.bindTexture(textureManager.loadTexture(texture));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y + 0.25f), (float)((float)z));
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glScalef((float)(0.5f * scale), (float)(0.5f * scale), (float)(0.5f * scale));
        GL11.glRotatef((float)yRot, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        float xOff = -0.5f;
        float zOff = -0.5f;
        float flapAngle = (MathHelper.sin((float)ticksAlive + partialTick) + 1.0f) * 22.5f + 5.0f;
        GL11.glPushMatrix();
        GL11.glRotatef((float)(-flapAngle), (float)0.0f, (float)0.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(xOff, 0.0, zOff, 0.0, 1.0);
        tessellator.addVertexWithUV((double)xOff + 0.5, 0.0, zOff, 0.5, 1.0);
        tessellator.addVertexWithUV((double)xOff + 0.5, 0.0, (double)zOff + 1.0, 0.5, 0.0);
        tessellator.addVertexWithUV(xOff, 0.0, (double)zOff + 1.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)flapAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)xOff + 0.5, 0.0, zOff, 0.5, 1.0);
        tessellator.addVertexWithUV((double)xOff + 1.0, 0.0, zOff, 1.0, 1.0);
        tessellator.addVertexWithUV((double)xOff + 1.0, 0.0, (double)zOff + 1.0, 1.0, 0.0);
        tessellator.addVertexWithUV((double)xOff + 0.5, 0.0, (double)zOff + 1.0, 0.5, 0.0);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public String getTexture(MobButterfly butterfly) {
        if (!((Boolean)Minecraft.getMinecraft().gameSettings.mobVariants.value).booleanValue()) {
            return butterfly.getDefaultEntityTexture();
        }
        return butterfly.getEntityTexture();
    }
}

