/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import com.mojang.logging.LogUtils;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.entity.animal.MobSheep;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.slf4j.Logger;

public class MobRendererSheep
extends MobRenderer<MobSheep> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public MobRendererSheep(ModelBase body, ModelBase wool, ModelBase overlay, float f) {
        super(body, f);
        this.setArmorModel(wool);
        this.setOverlayModel(overlay, "/assets/minecraft/textures/entity/sheep_overlay.png");
    }

    @Override
    public void render(Tessellator tessellator, MobSheep entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.mainModel.swingProgress = this.getSwingProgress(entity, partialTick);
        if (this.armorModel != null) {
            this.armorModel.swingProgress = this.mainModel.swingProgress;
        }
        if (this.overlayModel != null) {
            this.overlayModel.swingProgress = this.mainModel.swingProgress;
        }
        this.mainModel.isRiding = entity.isPassenger();
        if (this.armorModel != null) {
            this.armorModel.isRiding = this.mainModel.isRiding;
        }
        if (this.overlayModel != null) {
            this.overlayModel.isRiding = this.mainModel.isRiding;
        }
        try {
            float bodyYaw = entity.yBodyRotO + (entity.yBodyRot - entity.yBodyRotO) * partialTick;
            float headYaw = entity.yRotO + (entity.yRot - entity.yRotO) * partialTick;
            float headPitch = entity.xRotO + (entity.xRot - entity.xRotO) * partialTick;
            this.translateModel(entity, x, y, z);
            float limbSway = this.limbSway(entity, partialTick);
            this.setupRotations(entity, limbSway, bodyYaw, partialTick);
            float scale = 0.0625f;
            GL12.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.setupScale(entity, partialTick);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * scale - 0.0078125f), (float)0.0f);
            float walkSpeed = entity.walkAnimSpeedO + (entity.walkAnimSpeed - entity.walkAnimSpeedO) * partialTick;
            float walkProgress = entity.walkAnimPos - entity.walkAnimSpeed * (1.0f - partialTick);
            if (walkSpeed > 1.0f) {
                walkSpeed = 1.0f;
            }
            this.loadEntityTexture(entity);
            GL11.glEnable((int)3008);
            this.mainModel.render(entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
            if (this.overlayModel != null) {
                this.bindTexture(this.overlayTexture);
                this.overlayModel.render(entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
            }
            for (int renderPass = 0; renderPass < 4; ++renderPass) {
                if (!this.prepareArmor(entity, renderPass, partialTick)) continue;
                this.armorModel.render(entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
            }
            this.renderAdditional(entity, partialTick);
            float brightness = entity.getBrightness(partialTick);
            if (Global.accessor.isFullbrightEnabled() || LightmapHelper.isLightmapEnabled()) {
                brightness = 1.0f;
            }
            if (entity.hurtTime > 0 || entity.deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (entity.hurtTime > 0 || entity.deathTime > 0) {
                    GL11.glColor4f((float)brightness, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.mainModel.render(entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                    if (this.overlayModel != null) {
                        this.overlayModel.render(null, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                    }
                    for (int k = 0; k < 4; ++k) {
                        if (!this.prepareArmor(entity, k, partialTick)) continue;
                        GL11.glColor4f((float)brightness, (float)0.0f, (float)0.0f, (float)0.4f);
                        this.armorModel.render(entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception exception) {
            LOGGER.error("Render exception in class '{}'!", (Object)this.getClass().getSimpleName(), (Object)exception);
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        this.renderSpecials(tessellator, entity, x, y, z);
    }

    @Override
    public void onUnload() {
        this.overlayModel.onUnload();
    }

    @Override
    protected boolean prepareArmor(MobSheep mobSheep, int renderPass, float partialTick) {
        if (renderPass == 0 && !mobSheep.getSheared()) {
            this.bindTexture("/assets/minecraft/textures/entity/sheep_fur.png");
            float brightness = LightmapHelper.isLightmapEnabled() || Global.accessor.isFullbrightEnabled() ? 1.0f : mobSheep.getBrightness(partialTick);
            int j = mobSheep.getFleeceColor().blockMeta;
            GL11.glColor3f((float)(brightness * MobSheep.FLEECE_COLOR_TABLE[j][0]), (float)(brightness * MobSheep.FLEECE_COLOR_TABLE[j][1]), (float)(brightness * MobSheep.FLEECE_COLOR_TABLE[j][2]));
            return true;
        }
        return false;
    }
}

