/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.Nullable;

public class ModelSpider
extends ModelBase {
    public Cube spiderHead;
    public Cube spiderNeck;
    public Cube spiderBody;
    public Cube spiderLeg1;
    public Cube spiderLeg2;
    public Cube spiderLeg3;
    public Cube spiderLeg4;
    public Cube spiderLeg5;
    public Cube spiderLeg6;
    public Cube spiderLeg7;
    public Cube spiderLeg8;

    public ModelSpider(float expandAmount) {
        int yOff = 15;
        this.spiderHead = new Cube(32, 4);
        this.spiderHead.addBox(-4.0f, -4.0f, -8.0f, 8, 8, 8, expandAmount);
        this.spiderHead.setRotationPoint(0.0f, yOff, -3.0f);
        this.spiderNeck = new Cube(0, 0);
        this.spiderNeck.addBox(-3.0f, -3.0f, -3.0f, 6, 6, 6, expandAmount);
        this.spiderNeck.setRotationPoint(0.0f, yOff, 0.0f);
        this.spiderBody = new Cube(0, 12);
        this.spiderBody.addBox(-5.0f, -4.0f, -6.0f, 10, 8, 12, expandAmount);
        this.spiderBody.setRotationPoint(0.0f, yOff, 9.0f);
        this.spiderLeg1 = new Cube(18, 0);
        this.spiderLeg1.addBox(-15.0f, -1.0f, -1.0f, 16, 2, 2, expandAmount);
        this.spiderLeg1.setRotationPoint(-4.0f, yOff, 2.0f);
        this.spiderLeg2 = new Cube(18, 0);
        this.spiderLeg2.addBox(-1.0f, -1.0f, -1.0f, 16, 2, 2, expandAmount);
        this.spiderLeg2.setRotationPoint(4.0f, yOff, 2.0f);
        this.spiderLeg3 = new Cube(18, 0);
        this.spiderLeg3.addBox(-15.0f, -1.0f, -1.0f, 16, 2, 2, expandAmount);
        this.spiderLeg3.setRotationPoint(-4.0f, yOff, 1.0f);
        this.spiderLeg4 = new Cube(18, 0);
        this.spiderLeg4.addBox(-1.0f, -1.0f, -1.0f, 16, 2, 2, expandAmount);
        this.spiderLeg4.setRotationPoint(4.0f, yOff, 1.0f);
        this.spiderLeg5 = new Cube(18, 0);
        this.spiderLeg5.addBox(-15.0f, -1.0f, -1.0f, 16, 2, 2, expandAmount);
        this.spiderLeg5.setRotationPoint(-4.0f, yOff, 0.0f);
        this.spiderLeg6 = new Cube(18, 0);
        this.spiderLeg6.addBox(-1.0f, -1.0f, -1.0f, 16, 2, 2, expandAmount);
        this.spiderLeg6.setRotationPoint(4.0f, yOff, 0.0f);
        this.spiderLeg7 = new Cube(18, 0);
        this.spiderLeg7.addBox(-15.0f, -1.0f, -1.0f, 16, 2, 2, expandAmount);
        this.spiderLeg7.setRotationPoint(-4.0f, yOff, -1.0f);
        this.spiderLeg8 = new Cube(18, 0);
        this.spiderLeg8.addBox(-1.0f, -1.0f, -1.0f, 16, 2, 2, expandAmount);
        this.spiderLeg8.setRotationPoint(4.0f, yOff, -1.0f);
    }

    @Override
    public void render(@Nullable Mob mob, float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale, float partialTick) {
        this.setupAnimation(mob, limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale, partialTick);
        this.spiderHead.render(scale);
        this.spiderNeck.render(scale);
        this.spiderBody.render(scale);
        this.spiderLeg1.render(scale);
        this.spiderLeg2.render(scale);
        this.spiderLeg3.render(scale);
        this.spiderLeg4.render(scale);
        this.spiderLeg5.render(scale);
        this.spiderLeg6.render(scale);
        this.spiderLeg7.render(scale);
        this.spiderLeg8.render(scale);
    }

    @Override
    public void setupAnimation(@Nullable Mob mob, float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale, float partialTick) {
        this.spiderHead.yRot = headYaw / 57.29578f;
        this.spiderHead.xRot = headPitch / 57.29578f;
        float f6 = 0.7853982f;
        this.spiderLeg1.zRot = -f6;
        this.spiderLeg2.zRot = f6;
        this.spiderLeg3.zRot = -f6 * 0.74f;
        this.spiderLeg4.zRot = f6 * 0.74f;
        this.spiderLeg5.zRot = -f6 * 0.74f;
        this.spiderLeg6.zRot = f6 * 0.74f;
        this.spiderLeg7.zRot = -f6;
        this.spiderLeg8.zRot = f6;
        float f7 = -0.0f;
        float f8 = 0.3926991f;
        this.spiderLeg1.yRot = f8 * 2.0f + f7;
        this.spiderLeg2.yRot = -f8 * 2.0f - f7;
        this.spiderLeg3.yRot = f8 + f7;
        this.spiderLeg4.yRot = -f8 - f7;
        this.spiderLeg5.yRot = -f8 + f7;
        this.spiderLeg6.yRot = f8 - f7;
        this.spiderLeg7.yRot = -f8 * 2.0f + f7;
        this.spiderLeg8.yRot = f8 * 2.0f - f7;
        float pair1Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + 0.0f) * 0.4f) * limbYaw;
        float pair2Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + (float)Math.PI) * 0.4f) * limbYaw;
        float pair3Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + 1.5707964f) * 0.4f) * limbYaw;
        float pair4Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + 4.712389f) * 0.4f) * limbYaw;
        float pair1Z = Math.abs(MathHelper.sin(limbSwing * 0.6662f + 0.0f) * 0.4f) * limbYaw;
        float pair2Z = Math.abs(MathHelper.sin(limbSwing * 0.6662f + (float)Math.PI) * 0.4f) * limbYaw;
        float pair3Z = Math.abs(MathHelper.sin(limbSwing * 0.6662f + 1.5707964f) * 0.4f) * limbYaw;
        float pair4Z = Math.abs(MathHelper.sin(limbSwing * 0.6662f + 4.712389f) * 0.4f) * limbYaw;
        this.spiderLeg1.yRot += pair1Y;
        this.spiderLeg2.yRot += -pair1Y;
        this.spiderLeg3.yRot += pair2Y;
        this.spiderLeg4.yRot += -pair2Y;
        this.spiderLeg5.yRot += pair3Y;
        this.spiderLeg6.yRot += -pair3Y;
        this.spiderLeg7.yRot += pair4Y;
        this.spiderLeg8.yRot += -pair4Y;
        this.spiderLeg1.zRot += pair1Z;
        this.spiderLeg2.zRot += -pair1Z;
        this.spiderLeg3.zRot += pair2Z;
        this.spiderLeg4.zRot += -pair2Z;
        this.spiderLeg5.zRot += pair3Z;
        this.spiderLeg6.zRot += -pair3Z;
        this.spiderLeg7.zRot += pair4Z;
        this.spiderLeg8.zRot += -pair4Z;
    }
}

