/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.Nullable;

public class ModelZombie
extends ModelBiped {
    public ModelZombie() {
        this(0.0f);
    }

    public ModelZombie(float var1) {
        this.parts(var1, 0.0f);
    }

    public void parts(float expansion, float var2) {
        this.holdingLeftHand = false;
        this.holdingRightHand = false;
        this.sneaking = false;
        this.cloak = new Cube(0, 0);
        this.cloak.addBox(-5.0f, 0.0f, -1.0f, 10, 16, 1, expansion);
        this.ear = new Cube(24, 0);
        this.ear.addBox(-4.0f, -7.0f, -1.0f, 7, 7, 1, expansion);
        this.head = new Cube(0, 0);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, expansion);
        this.head.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.hair = new Cube(32, 0);
        this.hair.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, expansion + 0.5f);
        this.hair.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.body = new Cube(16, 16);
        this.body.addBox(-4.0f, 0.0f, -2.0f, 8, 12, 4, expansion);
        this.body.setRotationPoint(0.0f, 0.0f + var2, 0.0f);
        this.armRight = new Cube(40, 16);
        this.armRight.addBox(-3.0f, -2.0f, -2.0f, 4, 12, 4, expansion);
        this.armRight.setRotationPoint(-5.0f, 2.0f + var2, 0.0f);
        this.armLeft = new Cube(40, 16);
        this.armLeft.mirror = true;
        this.armLeft.addBox(-1.0f, -2.0f, -2.0f, 4, 12, 4, expansion);
        this.armLeft.setRotationPoint(5.0f, 2.0f + var2, 0.0f);
        this.legRight = new Cube(0, 16);
        this.legRight.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, expansion);
        this.legRight.setRotationPoint(-2.0f, 12.0f + var2, 0.0f);
        this.legLeft = new Cube(0, 16);
        this.legLeft.mirror = true;
        this.legLeft.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4, expansion);
        this.legLeft.setRotationPoint(2.0f, 12.0f + var2, 0.0f);
    }

    @Override
    public void setupAnimation(@Nullable Mob mob, float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale, float partialTick) {
        super.setupAnimation(mob, limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale, partialTick);
        float var7 = MathHelper.sin(this.swingProgress * (float)Math.PI);
        float var8 = MathHelper.sin((1.0f - (1.0f - this.swingProgress) * (1.0f - this.swingProgress)) * (float)Math.PI);
        this.armRight.zRot = 0.0f;
        this.armLeft.zRot = 0.0f;
        this.armRight.yRot = -(0.1f - var7 * 0.6f);
        this.armLeft.yRot = 0.1f - var7 * 0.6f;
        this.armRight.xRot = -1.5707964f;
        this.armLeft.xRot = -1.5707964f;
        this.armRight.xRot -= var7 * 1.2f - var8 * 0.4f;
        this.armLeft.xRot -= var7 * 1.2f - var8 * 0.4f;
        this.armRight.zRot += MathHelper.cos(limbPitch * 0.09f) * 0.05f + 0.05f;
        this.armLeft.zRot -= MathHelper.cos(limbPitch * 0.09f) * 0.05f + 0.05f;
        this.armRight.xRot += MathHelper.sin(limbPitch * 0.067f) * 0.05f;
        this.armLeft.xRot -= MathHelper.sin(limbPitch * 0.067f) * 0.05f;
    }
}

