/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.model.ModelSign;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererSign
extends TileEntityRenderer<TileEntitySign> {
    private final Minecraft mc = Minecraft.getMinecraft();
    private final ModelSign modelSign = new ModelSign();

    @Override
    public void doRender(Tessellator tessellator, TileEntitySign tileEntity, double x, double y, double z, float partialTick) {
        float angle;
        Block<?> block = tileEntity.getBlock();
        if (block == null || !(block.getLogic() instanceof BlockLogicSign)) {
            return;
        }
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        float scale = 0.6666667f;
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f * scale), (float)((float)z + 0.5f));
        if (((BlockLogicSign)block.getLogic()).isFreeStanding) {
            angle = (float)(tileEntity.getBlockMeta() * 360) / 16.0f;
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelSign.signStick.visible = true;
        } else {
            switch (tileEntity.getBlockMeta()) {
                case 2: {
                    angle = 180.0f;
                    break;
                }
                case 3: {
                    angle = 0.0f;
                    break;
                }
                case 4: {
                    angle = 90.0f;
                    break;
                }
                default: {
                    angle = -90.0f;
                }
            }
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.4375f);
            this.modelSign.signStick.visible = false;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)(-scale), (float)(-scale));
        this.loadTexture("/assets/minecraft/textures/entity/sign.png");
        this.modelSign.render();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.33545f, (float)0.04375f);
        GL11.glDepthMask((boolean)false);
        EnumSignPicture picture = tileEntity.getPicture();
        this.drawTexturedModalRect(1.0, 0.5, TextureRegistry.getTexture(picture.getTextureKey()));
        GL11.glPopMatrix();
        Font font = this.getFont();
        float lightLevel = LightmapHelper.isLightmapEnabled() ? 1.0f : this.mc.currentWorld.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
        float lightOffset = 0.0f;
        if (tileEntity.isGlowing()) {
            lightLevel = 1.0f;
            lightOffset = 96.0f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 15));
            }
        }
        GL11.glPushMatrix();
        float scale2 = 0.01666667f * scale;
        GL11.glTranslatef((float)0.0f, (float)(0.5f * scale), (float)(0.065f * scale));
        GL11.glScalef((float)scale2, (float)(-scale2), (float)scale2);
        GL11.glDepthMask((boolean)false);
        int color = Colors.allSignColors[tileEntity.getColor().id].getARGB();
        int r = (int)MathHelper.clamp((float)(color >> 16 & 0xFF) * lightLevel + lightOffset, 0.0f, 255.0f);
        int g = (int)MathHelper.clamp((float)(color >> 8 & 0xFF) * lightLevel + lightOffset, 0.0f, 255.0f);
        int b = (int)MathHelper.clamp((float)(color >> 0 & 0xFF) * lightLevel + lightOffset, 0.0f, 255.0f);
        color = r << 16 | g << 8 | b << 0;
        for (int line = 0; line < tileEntity.signText.length; ++line) {
            String text = tileEntity.signText[line];
            if (line == tileEntity.lineBeingEdited) {
                text = "> " + text + " <";
            }
            font.drawString(text, -font.getStringWidth(text) / 2, line * 10 - tileEntity.signText.length * 5, color);
        }
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
    }

    private void drawTexturedModalRect(double width, double height, IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-width / 2.0, height / 2.0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(-width / 2.0, -height / 2.0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(width / 2.0, -height / 2.0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(width / 2.0, height / 2.0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.draw();
    }
}

