/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LongArrayTag
extends Tag<long[]> {
    public LongArrayTag() {
        this(new long[0]);
    }

    public LongArrayTag(long[] array) {
        super(array);
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        dos.writeInt(((long[])this.getValue()).length);
        byte[] bytes = new byte[((long[])this.getValue()).length * 8];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().put((long[])this.getValue());
        dos.write(bytes);
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        int length = dis.readInt();
        this.setValue(new long[length]);
        byte[] bytes = new byte[length * 8];
        dis.readFully(bytes);
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().get((long[])this.getValue());
    }

    @Override
    public byte getId() {
        return 13;
    }

    public String toString() {
        if (((long[])this.getValue()).length > 16) {
            return "\"" + this.getTagName() + "\": [ " + ((long[])this.getValue()).length + " longs ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getTagName()).append("\": [ ");
        for (long l : (long[])this.getValue()) {
            sb.append(l).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LongArrayTag)) {
            return false;
        }
        LongArrayTag otherTag = (LongArrayTag)obj;
        long[] thisData = (long[])this.getValue();
        long[] otherData = (long[])otherTag.getValue();
        return Arrays.equals(thisData, otherData);
    }
}

