/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.HubComponentSubtitles;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentArmorBar;
import net.minecraft.client.gui.hud.component.HudComponentCrosshair;
import net.minecraft.client.gui.hud.component.HudComponentFireBar;
import net.minecraft.client.gui.hud.component.HudComponentHealthBar;
import net.minecraft.client.gui.hud.component.HudComponentHotbar;
import net.minecraft.client.gui.hud.component.HudComponentLog;
import net.minecraft.client.gui.hud.component.HudComponentOxygenBar;
import net.minecraft.client.gui.hud.component.HudComponentRotationLock;
import net.minecraft.client.gui.hud.component.layout.LayoutAbsolute;
import net.minecraft.client.gui.hud.component.layout.LayoutSnap;
import org.slf4j.Logger;

public class HudComponents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static String DEFAULT_LAYOUT = null;
    public static final HudComponents INSTANCE = new HudComponents();
    private final List<HudComponent> components = new ArrayList<HudComponent>();
    public static final HudComponent HOTBAR = HudComponents.register(new HudComponentHotbar("hotbar", new LayoutAbsolute(0.5f, 1.0f, ComponentAnchor.BOTTOM_CENTER)));
    public static final HudComponent CROSSHAIR = HudComponents.register(new HudComponentCrosshair("crosshair", new LayoutAbsolute(0.5f, 0.5f, ComponentAnchor.CENTER)));
    public static final HudComponent HEALTH_BAR = HudComponents.register(new HudComponentHealthBar("health_bar", new LayoutSnap(HOTBAR, ComponentAnchor.TOP_LEFT, ComponentAnchor.BOTTOM_LEFT)));
    public static final HudComponent ARMOR_BAR = HudComponents.register(new HudComponentArmorBar("armor_bar", new LayoutSnap(HOTBAR, ComponentAnchor.TOP_RIGHT, ComponentAnchor.BOTTOM_RIGHT)));
    public static final HudComponent OXYGEN_BAR = HudComponents.register(new HudComponentOxygenBar("oxygen_bar", new LayoutSnap(HEALTH_BAR, ComponentAnchor.TOP_LEFT, ComponentAnchor.BOTTOM_LEFT)));
    public static final HudComponent FIRE_BAR = HudComponents.register(new HudComponentFireBar("fire_bar", new LayoutSnap(OXYGEN_BAR, ComponentAnchor.TOP_LEFT, ComponentAnchor.BOTTOM_LEFT)));
    public static final HudComponent ROTATION_LOCK = HudComponents.register(new HudComponentRotationLock("rotation_lock", new LayoutSnap(CROSSHAIR, ComponentAnchor.CENTER_RIGHT, ComponentAnchor.CENTER_LEFT)));
    public static final HudComponent SUBTITLES = HudComponents.register(new HubComponentSubtitles("subtitles_box", 100, 50, new LayoutAbsolute(1.0f, 0.75f, ComponentAnchor.BOTTOM_RIGHT)));
    public static final HudComponent LOG = HudComponents.register(new HudComponentLog("log", new LayoutAbsolute(1.0f, 0.0f, ComponentAnchor.TOP_RIGHT)));

    public static HudComponent register(HudComponent component) {
        HudComponents.INSTANCE.components.add(component);
        return component;
    }

    private HudComponents() {
    }

    public List<HudComponent> getComponents() {
        return this.components;
    }

    public HudComponent getComponent(String key) {
        for (HudComponent component : this.components) {
            if (!component.getKey().equals(key)) continue;
            return component;
        }
        return null;
    }

    public String toSettingsString() {
        StringBuilder builder = new StringBuilder();
        for (HudComponent component : this.components) {
            builder.append(component.toSettingsString()).append('|');
        }
        return builder.toString();
    }

    public void fromSettingsString(String settings) {
        String[] parts;
        for (String part : parts = settings.split("\\|")) {
            String key = part.substring(0, part.indexOf(123));
            HudComponent component = this.getComponent(key);
            if (component == null) {
                LOGGER.warn("Unknown component: {}", (Object)key);
                continue;
            }
            String componentSettings = part.substring(part.indexOf(123) + 1, part.lastIndexOf(125));
            component.fromSettingsString(componentSettings);
        }
    }
}

