/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.render.window.CursorShape;

public class KeyBindingComponent
extends ButtonComponent {
    private final KeyBinding keyBinding;
    private final ButtonElement keyButton;
    private final ButtonElement clearButton;

    public KeyBindingComponent(KeyBinding keyBinding) {
        super(keyBinding.getId());
        this.keyBinding = keyBinding;
        this.keyButton = new ButtonElement(0, 0, 0, 150, 20, keyBinding.getKeyName());
        this.clearButton = new ButtonElement(0, 0, 0, 12, 20, "X");
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        if (this.clearButton.mouseClicked(mc, this.clearButton.xPosition + (relativeMouseX - this.keyButton.width), this.clearButton.yPosition + relativeMouseY)) {
            this.keyBinding.unbind();
            this.keyButton.displayString = this.keyBinding.getKeyName();
        } else {
            ScreenOptions.pickingKeyBinding = this.keyBinding;
            ScreenOptions.pickingKeyBindingComponent = this;
        }
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.keyButton.xPosition = x + relativeButtonX;
        this.keyButton.yPosition = y + relativeButtonY;
        this.keyButton.width = buttonWidth - this.clearButton.width;
        this.keyButton.height = buttonHeight;
        this.keyButton.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth - this.clearButton.width && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            KeyBindingComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
        this.clearButton.xPosition = x + relativeButtonX + this.keyButton.width;
        this.clearButton.yPosition = y + relativeButtonY;
        this.clearButton.enabled = this.keyBinding.isBound();
        this.clearButton.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (this.clearButton.enabled && relativeMouseX >= relativeButtonX + this.keyButton.width && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            KeyBindingComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }

    public void update() {
        this.keyButton.displayString = this.keyBinding.getKeyName();
    }

    @Override
    public void resetValue() {
        this.keyBinding.resetToDefault();
        this.keyButton.displayString = this.keyBinding.getKeyName();
    }

    @Override
    public boolean isDefault() {
        return this.keyBinding.isDefault();
    }
}

