/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.sound.SoundCategory;
import org.lwjgl.opengl.GL11;

public class SelectedTexturePackListComponent
implements OptionsComponent {
    protected static final int BUTTON_HEIGHT = 32;
    private final List<TexturePackButton> selectedPacks = new ArrayList<TexturePackButton>();
    private int size;
    TexturePackButton draggedButton;

    @Override
    public void init(Minecraft mc) {
        this.createTexturePackButtons();
    }

    @Override
    public void tick() {
        if (this.size != ButtonComponent.mc.texturePackList.selectedPacks.size()) {
            this.size = ButtonComponent.mc.texturePackList.selectedPacks.size();
            this.createTexturePackButtons();
        }
    }

    public void createTexturePackButtons() {
        this.selectedPacks.clear();
        TexturePackButton prevButton = new TexturePackButton(0, 3, false, ButtonComponent.mc.texturePackList.getDefaultTexturePack());
        this.selectedPacks.add(prevButton);
        List<TexturePack> texturePacks = ButtonComponent.mc.texturePackList.selectedPacks;
        for (TexturePack texturePack : texturePacks) {
            prevButton = new TexturePackButton(prevButton.xPos, prevButton.yPos + 35, true, texturePack);
            this.selectedPacks.add(prevButton);
        }
    }

    @Override
    public int getHeight() {
        if (this.selectedPacks.isEmpty()) {
            return 20;
        }
        return 3 + this.selectedPacks.size() * 35;
    }

    @Override
    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.selectedPacks.isEmpty()) {
            ButtonComponent.mc.font.renderCentered(Tessellator.instance, I18n.getInstance().translateKey("gui.options.page.texture_packs.label.no_packs"), x + width / 2, y + 4).setShadow().setColor(0x5F7F7F7F).call();
        }
        for (TexturePackButton button : this.selectedPacks) {
            if (button == this.draggedButton) continue;
            int yOff = 0;
            if (button.draggable && this.draggedButton != null && relativeMouseX > 0 && relativeMouseX < width && relativeMouseY > 0 && relativeMouseY < this.getHeight()) {
                int shiftAmount = this.draggedButton.shiftAmount(relativeMouseY);
                if (shiftAmount < 0 && button.yPos < this.draggedButton.yPos && button.yPos >= this.draggedButton.yPos + shiftAmount * 35) {
                    yOff += 35;
                }
                if (shiftAmount > 0 && button.yPos > this.draggedButton.yPos && button.yPos <= this.draggedButton.yPos + shiftAmount * 35) {
                    yOff -= 35;
                }
            }
            button.render(this, x, y + yOff, width, relativeMouseX, relativeMouseY);
        }
        if (this.draggedButton != null) {
            this.draggedButton.render(this, x, y, width, relativeMouseX, relativeMouseY);
        }
    }

    @Override
    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        TexturePackButton button;
        Iterator<TexturePackButton> iterator = this.selectedPacks.iterator();
        while (!(!iterator.hasNext() || (button = iterator.next()).isClickable() && button.isHovered(relativeMouseX, relativeMouseY, width) && button.onClick(this, mouseButton, x, y, width, relativeMouseX, relativeMouseY))) {
        }
    }

    @Override
    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        for (TexturePackButton button : this.selectedPacks) {
            if (button.onRelease(this, mouseButton, x, y, width, relativeMouseX, relativeMouseY)) break;
        }
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
    }

    @Override
    public void onClose() {
        this.draggedButton = null;
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return false;
    }

    private static class TexturePackButton {
        private ButtonElement button;
        public boolean draggable;
        public final TexturePack texturePack;
        public final int height = 32;
        public int xPos;
        public int yPos;
        private int clickX = -1;
        private int clickY = -1;

        public TexturePackButton(int xPos, int yPos, boolean draggable, TexturePack texturePack) {
            this.draggable = draggable;
            this.texturePack = texturePack;
            this.xPos = xPos;
            this.yPos = yPos;
            this.button = new ButtonElement(0, 0, 0, 20, 20, "-");
        }

        public boolean isClickable() {
            return true;
        }

        public boolean isHovered(int mouseX, int mouseY, int width) {
            if (this.isDragged()) {
                int dX = mouseX - this.clickX;
                int dY = mouseY - this.clickY;
                mouseX -= dX;
                mouseY -= dY;
            }
            return mouseX >= 0 && mouseX <= width && mouseY >= this.yPos && mouseY <= this.yPos + 32;
        }

        public boolean isDragged() {
            return this.clickX > 0 || this.clickY > 0;
        }

        public boolean onClick(SelectedTexturePackListComponent component, int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
            this.setupButton(x, y, width, relativeMouseX, relativeMouseY);
            if (this.texturePack != ButtonComponent.mc.texturePackList.getDefaultTexturePack()) {
                if (mouseButton == 0 && this.button.isHovered(x + relativeMouseX, y + relativeMouseY)) {
                    this.unsetPack(component);
                    ButtonComponent.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                    component.draggedButton = null;
                    return true;
                }
                if (mouseButton == 1) {
                    this.unsetPack(component);
                    ButtonComponent.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                    return true;
                }
            }
            if (!this.draggable) {
                return false;
            }
            this.clickX = relativeMouseX;
            this.clickY = relativeMouseY;
            component.draggedButton = this;
            return true;
        }

        public boolean onRelease(SelectedTexturePackListComponent component, int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
            if (this.isDragged()) {
                if (relativeMouseX < 0 || relativeMouseX > x + width || relativeMouseY < 0 || relativeMouseY > y + component.getHeight()) {
                    this.unsetPack(component);
                    return true;
                }
                ButtonComponent.mc.texturePackList.shiftPack(this.texturePack, this.shiftAmount(relativeMouseY));
                this.clickX = -1;
                this.clickY = -1;
                component.draggedButton = null;
                component.createTexturePackButtons();
                return true;
            }
            this.clickX = -1;
            this.clickY = -1;
            return false;
        }

        public void unsetPack(SelectedTexturePackListComponent component) {
            ButtonComponent.mc.texturePackList.unsetTexturePack(this.texturePack);
            component.draggedButton = null;
            component.createTexturePackButtons();
        }

        public int draggedX(int mouseX) {
            return mouseX - this.clickX;
        }

        public int draggedY(int mouseY) {
            return mouseY - this.clickY;
        }

        public int shiftAmount(int mouseY) {
            return this.draggedY(mouseY) / 32;
        }

        public void render(SelectedTexturePackListComponent component, int x, int y, int width, int mouseX, int mouseY) {
            Tessellator tessellator = Tessellator.instance;
            this.setupButton(x, y, width, mouseX, mouseY);
            if (this.isDragged()) {
                int dX = this.draggedX(mouseX);
                int dY = this.draggedY(mouseY);
                x += dX;
                y += dY;
            }
            if (this.isDragged() || this.isHovered(mouseX, mouseY, width) && component.draggedButton == null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                tessellator.startDrawingQuads();
                tessellator.setColorOpaque_I(2139127936);
                tessellator.addVertexWithUV(x + this.xPos - 2, y + this.yPos + 32 + 2, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(x + this.xPos + width + 2, y + this.yPos + 32 + 2, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x + this.xPos + width + 2, y + this.yPos - 2, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x + this.xPos - 2, y + this.yPos - 2, 0.0, 0.0, 0.0);
                tessellator.setColorOpaque_I(0);
                tessellator.addVertexWithUV(x + this.xPos - 1, y + this.yPos + 32 + 1, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(x + this.xPos + width + 1, y + this.yPos + 32 + 1, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x + this.xPos + width + 1, y + this.yPos - 1, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x + this.xPos - 1, y + this.yPos - 1, 0.0, 0.0, 0.0);
                tessellator.draw();
                GL11.glEnable((int)3553);
            }
            this.texturePack.bindThumbnailTexture(ButtonComponent.mc);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0xFFFFFF);
            tessellator.addVertexWithUV(x + this.xPos, y + this.yPos + 32, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(x + this.xPos + 32, y + this.yPos + 32, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(x + this.xPos + 32, y + this.yPos, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(x + this.xPos, y + this.yPos, 0.0, 0.0, 0.0);
            tessellator.draw();
            int rgbVersion = 0x808080;
            int format = this.texturePack.manifest.getFormat();
            if (format == 4) {
                ButtonComponent.mc.font.render(Tessellator.instance, this.texturePack.manifest.getName(), x + this.xPos + this.height + 2, y + this.yPos + 1).call();
                ButtonComponent.mc.font.render(Tessellator.instance, this.texturePack.manifest.getDescriptionLine1(), x + this.xPos + this.height + 2, y + this.yPos + 12).setColor(0x808080).call();
                ButtonComponent.mc.font.render(Tessellator.instance, this.texturePack.manifest.getDescriptionLine2(), x + this.xPos + this.height + 2, y + this.yPos + 22).setColor(0x808080).call();
            } else if (format == -1) {
                ButtonComponent.mc.font.render(Tessellator.instance, TextFormatting.RED + this.texturePack.manifest.getName(), x + this.xPos + this.height + 2, y + this.yPos + 1).call();
                ButtonComponent.mc.font.render(Tessellator.instance, this.texturePack.manifest.getDescriptionLine1(), x + this.xPos + this.height + 2, y + this.yPos + 12).setColor(0x808080).call();
                ButtonComponent.mc.font.render(Tessellator.instance, this.texturePack.manifest.getDescriptionLine2(), x + this.xPos + this.height + 2, y + this.yPos + 22).setColor(0x808080).call();
                rgbVersion = Colors.allChatColors[TextFormatting.RED.id].getARGB();
            } else {
                I18n i18n = I18n.getInstance();
                ButtonComponent.mc.font.render(Tessellator.instance, TextFormatting.RED + this.texturePack.manifest.getName(), x + this.xPos + this.height + 2, y + this.yPos + 1).call();
                ButtonComponent.mc.font.render(Tessellator.instance, i18n.translateKey("gui.options.page.texture_packs.label.outdated_pack.1"), x + this.xPos + this.height + 2, y + this.yPos + 12).setColor(0x808080).call();
                ButtonComponent.mc.font.render(Tessellator.instance, i18n.translateKey("gui.options.page.texture_packs.label.outdated_pack.2"), x + this.xPos + this.height + 2, y + this.yPos + 22).setColor(0x808080).call();
                rgbVersion = Colors.allChatColors[TextFormatting.RED.id].getARGB();
            }
            if (this.isHovered(mouseX, mouseY, width) && component.draggedButton == null && this.texturePack != ButtonComponent.mc.texturePackList.getDefaultTexturePack()) {
                this.button.drawButton(ButtonComponent.mc, mouseX + x, mouseY + y);
                x -= this.button.width + 3;
            }
            String version = this.texturePack.manifest.getPackVersion();
            int versionWidth = ButtonComponent.mc.font.stringWidth(version);
            ButtonComponent.mc.font.render(Tessellator.instance, this.texturePack.manifest.getPackVersion(), x + this.xPos + width - versionWidth - 2, y + this.yPos + 1).setColor(rgbVersion).call();
        }

        public void setupButton(int x, int y, int width, int mouseX, int mouseY) {
            this.button.setX(x + this.xPos + width - this.button.width - 1);
            this.button.setY(y + this.yPos + (32 - this.button.height) / 2);
        }
    }
}

