/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class ItemRenderer {
    private final Minecraft mc;
    private ItemStack itemToRender = null;
    private float height = 0.0f;
    private float oHeight = 0.0f;
    private int lastSlot = -1;

    public ItemRenderer(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public float getEquippedProgress(float partialTick) {
        return this.oHeight + (this.height - this.oHeight) * partialTick;
    }

    public void renderItemInFirstPerson(float partialTick) {
        float equipProgress = this.getEquippedProgress(partialTick);
        PlayerLocal player = this.mc.thePlayer;
        float rotationPitch = player.xRotO + (player.xRot - player.xRotO) * partialTick;
        GL11.glPushMatrix();
        GL11.glRotatef((float)rotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(player.yRotO + (player.yRot - player.yRotO) * partialTick), (float)0.0f, (float)1.0f, (float)0.0f);
        Lighting.enableLight();
        GL11.glPopMatrix();
        ItemStack itemstack = this.itemToRender;
        if (itemstack != null) {
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled() || this.mc.fullbright) {
                LightmapHelper.setLightmapCoord(this.mc.thePlayer.getLightmapCoord(partialTick));
            } else {
                brightness = this.mc.currentWorld.getLightBrightness(MathHelper.floor(player.x), MathHelper.floor(player.y), MathHelper.floor(player.z));
            }
            ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(itemstack.getItem())).renderFirstPerson(Tessellator.instance, this, player, itemstack, brightness, 1.0f, partialTick);
        } else {
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled() || this.mc.fullbright) {
                LightmapHelper.setLightmapCoord(this.mc.thePlayer.getLightmapCoord(partialTick));
            } else if (!this.mc.fullbright) {
                brightness = this.mc.currentWorld.getLightBrightness(MathHelper.floor(player.x), MathHelper.floor(player.y), MathHelper.floor(player.z));
            }
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            EntityRenderer<PlayerLocal> render = EntityRenderDispatcher.instance.getRenderer(this.mc.thePlayer);
            MobRendererPlayer playerRenderer = (MobRendererPlayer)render;
            if (player.getHeldObject() == null) {
                if (player.isLeftHanded()) {
                    float f6 = 0.8f;
                    float swingProgress = player.getSwingProgress(partialTick);
                    float f14 = MathHelper.sin(swingProgress * (float)Math.PI);
                    float f18 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
                    GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-f18 * 0.3f), (float)(MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.4f), (float)(-f14 * 0.4f));
                    GL11.glTranslatef((float)(0.8f * f6), (float)(-0.75f * f6 - (1.0f - equipProgress) * 0.6f), (float)(-0.9f * f6));
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    f14 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
                    f18 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
                    GL11.glRotatef((float)(f18 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-f14 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    this.mc.textureManager.bindDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), PlayerSkinParser.instance);
                    GL11.glTranslatef((float)-1.0f, (float)3.6f, (float)3.5f);
                    GL11.glRotatef((float)120.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)5.6f, (float)0.0f, (float)0.0f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.0625f, (float)0.0625f, (float)-0.0625f);
                    GL11.glTranslatef((float)0.0f, (float)16.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)-16.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)8.0f, (float)0.0f);
                    playerRenderer.drawFirstPersonHand(Tessellator.instance, this.mc.thePlayer, true);
                    GL11.glPopMatrix();
                    GL11.glPopMatrix();
                } else {
                    float f6 = 0.8f;
                    float swingProgress = player.getSwingProgress(partialTick);
                    float f14 = MathHelper.sin(swingProgress * (float)Math.PI);
                    float f18 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
                    GL11.glTranslatef((float)(-f18 * 0.3f), (float)(MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.4f), (float)(-f14 * 0.4f));
                    GL11.glTranslatef((float)(0.8f * f6), (float)(-0.75f * f6 - (1.0f - equipProgress) * 0.6f), (float)(-0.9f * f6));
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    f14 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
                    f18 = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
                    GL11.glRotatef((float)(f18 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-f14 * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    this.mc.textureManager.bindDownloadableTexture(this.mc.thePlayer.skinURL, this.mc.thePlayer.getEntityTexture(), PlayerSkinParser.instance);
                    GL11.glTranslatef((float)-1.0f, (float)3.6f, (float)3.5f);
                    GL11.glRotatef((float)120.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)5.6f, (float)0.0f, (float)0.0f);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.0625f, (float)0.0625f, (float)-0.0625f);
                    GL11.glTranslatef((float)0.0f, (float)16.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)-16.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)8.0f, (float)0.0f);
                    playerRenderer.drawFirstPersonHand(Tessellator.instance, this.mc.thePlayer, false);
                    GL11.glPopMatrix();
                }
            } else {
                GL11.glPushMatrix();
                float swingProgress = player.getSwingProgress(partialTick);
                GL11.glTranslatef((float)0.0f, (float)(MathHelper.sin(swingProgress * (float)Math.PI * 2.0f - 1.5707964f) / 33.0f), (float)0.0f);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)(-MathHelper.sin(swingProgress * (float)Math.PI * 2.0f) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                playerRenderer.drawHeldObject(this.mc.thePlayer, partialTick);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            GL11.glDisable((int)32826);
        }
        Lighting.disable();
    }

    public void renderOverlays(float partialTicks) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        if (this.mc.thePlayer.isOnFire()) {
            TextureRegistry.blockAtlas.bind();
            this.renderFireInFirstPerson(partialTicks);
        }
        if (this.mc.thePlayer.isInWall() && !this.mc.thePlayer.noPhysics) {
            int blockX = MathHelper.floor(this.mc.thePlayer.x);
            int blockY = MathHelper.floor(this.mc.thePlayer.y);
            int blockZ = MathHelper.floor(this.mc.thePlayer.z);
            TextureRegistry.blockAtlas.bind();
            int id = this.mc.currentWorld.getBlockId(blockX, blockY, blockZ);
            int meta = this.mc.currentWorld.getBlockMetadata(blockX, blockY, blockZ);
            Block<?> block = Blocks.blocksList[id];
            BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
            if (this.mc.currentWorld.isBlockNormalCube(blockX, blockY, blockZ)) {
                this.renderInsideOfBlock(partialTicks, model.getOverlayTexture(meta));
            } else {
                id = 0;
                for (int i = 0; i < 8; ++i) {
                    int z1;
                    int y1;
                    float x0 = ((float)((i >> 0) % 2) - 0.5f) * this.mc.thePlayer.bbWidth * 0.9f;
                    float y0 = ((float)((i >> 1) % 2) - 0.5f) * this.mc.thePlayer.bbHeight * 0.2f;
                    float z0 = ((float)((i >> 2) % 2) - 0.5f) * this.mc.thePlayer.bbWidth * 0.9f;
                    int x1 = MathHelper.floor_float((float)blockX + x0);
                    if (!this.mc.currentWorld.isBlockNormalCube(x1, y1 = MathHelper.floor_float((float)blockY + y0), z1 = MathHelper.floor_float((float)blockZ + z0))) continue;
                    id = this.mc.currentWorld.getBlockId(x1, y1, z1);
                    meta = this.mc.currentWorld.getBlockMetadata(x1, y1, z1);
                    break;
                }
                if (Blocks.blocksList[id] != null) {
                    model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.blocksList[id]);
                    this.renderInsideOfBlock(partialTicks, model.getOverlayTexture(meta));
                }
            }
        }
        if (this.mc.thePlayer.isUnderLiquid(Material.water)) {
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/misc/water.png").bind();
            this.renderWarpedTextureOverlay(partialTicks);
        }
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2929);
    }

    private void renderInsideOfBlock(float partialTicks, IconCoordinate texture) {
        if (texture == null) {
            return;
        }
        Tessellator tessellator = Tessellator.instance;
        float brightness = 0.1f;
        if (this.mc.fullbright) {
            brightness = 1.0f;
        }
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)0.5f);
        GL11.glPushMatrix();
        float x0 = -1.0f;
        float x1 = 1.0f;
        float y0 = -1.0f;
        float y1 = 1.0f;
        float z = -0.5f;
        float u0 = (float)texture.getIconUMin();
        float v0 = (float)texture.getIconVMin();
        float u1 = (float)texture.getIconUMax();
        float v1 = (float)texture.getIconVMax();
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-1.0, -1.0, -0.5, u1, v1);
        tessellator.addVertexWithUV(1.0, -1.0, -0.5, u0, v1);
        tessellator.addVertexWithUV(1.0, 1.0, -0.5, u0, v0);
        tessellator.addVertexWithUV(-1.0, 1.0, -0.5, u1, v0);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderWarpedTextureOverlay(float f) {
        Tessellator tessellator = Tessellator.instance;
        float f1 = this.mc.thePlayer.getBrightness(f);
        if (this.mc.fullbright) {
            f1 = 1.0f;
        }
        GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        float f2 = 4.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -1.0f;
        float f6 = 1.0f;
        float f7 = -0.5f;
        float f8 = -this.mc.thePlayer.yRot / 64.0f;
        float f9 = this.mc.thePlayer.xRot / 64.0f;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(f3, f5, f7, f2 + f8, f2 + f9);
        tessellator.addVertexWithUV(f4, f5, f7, 0.0f + f8, f2 + f9);
        tessellator.addVertexWithUV(f4, f6, f7, 0.0f + f8, 0.0f + f9);
        tessellator.addVertexWithUV(f3, f6, f7, f2 + f8, 0.0f + f9);
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    private void renderFireInFirstPerson(float f) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float scale = 1.5f;
        for (int i = 0; i < 2; ++i) {
            GL11.glPushMatrix();
            IconCoordinate texture = TextureRegistry.getTexture("minecraft:block/fire");
            float uMin = (float)texture.getIconUMin();
            float uMax = (float)texture.getIconUMax();
            float vMin = (float)texture.getIconVMin();
            float vMax = (float)texture.getIconVMax();
            float xMin = (0.0f - scale) / 2.0f;
            float xMax = xMin + scale;
            float yMin = 0.0f - scale / 2.0f;
            float yMax = yMin + scale;
            float f10 = -0.5f;
            GL11.glTranslatef((float)((float)(-(i * 2 - 1)) * 0.4f), (float)-0.3f, (float)0.0f);
            GL11.glRotatef((float)((float)(i * 2 - 1) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(xMin, (double)yMin - 0.5, f10, uMax, vMax);
            tessellator.addVertexWithUV(xMax, (double)yMin - 0.5, f10, uMin, vMax);
            tessellator.addVertexWithUV(xMax, yMax, f10, uMin, vMin);
            tessellator.addVertexWithUV(xMin, yMax, f10, uMax, vMin);
            tessellator.draw();
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public void updateEquippedItem() {
        float f;
        float f1;
        float f2;
        boolean flag;
        this.oHeight = this.height;
        PlayerLocal entityplayersp = this.mc.thePlayer;
        ItemStack itemstack = entityplayersp.inventory.getCurrentItem();
        boolean bl = flag = this.lastSlot == entityplayersp.inventory.getCurrentItemIndex() && itemstack == this.itemToRender;
        if (this.itemToRender == null && itemstack == null) {
            flag = true;
        }
        if (itemstack != null && this.itemToRender != null && itemstack != this.itemToRender && itemstack.itemID == this.itemToRender.itemID && itemstack.getMetadata() == this.itemToRender.getMetadata()) {
            this.itemToRender = itemstack;
            flag = true;
        }
        if ((f2 = (f1 = flag ? 1.0f : 0.0f) - this.height) < -(f = 0.4f)) {
            f2 = -f;
        }
        if (f2 > f) {
            f2 = f;
        }
        this.height += f2;
        if (this.height < 0.1f) {
            this.itemToRender = itemstack;
            this.lastSlot = entityplayersp.inventory.getCurrentItemIndex();
        }
    }

    public void resetEquippedProgress() {
        this.height = 0.0f;
    }
}

