/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.MinecraftError;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.ProgressListener;
import org.lwjgl.opengl.GL11;

public class LoadingScreenRenderer
implements ProgressListener {
    private String stage = "";
    private Minecraft minecraft;
    private String title = "";
    private long startTime = System.currentTimeMillis();
    private boolean canStop = false;
    private String backgroundPath = "/assets/minecraft/textures/gui/background.png";
    private int startStackDepth = 0;
    private String tip = "";

    public LoadingScreenRenderer(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void progressStartNoAbort(String title) {
        ++this.startStackDepth;
        this.canStop = false;
        this.initialize(title);
    }

    @Override
    public void progressStart(String title) {
        ++this.startStackDepth;
        this.canStop = true;
        this.initialize(title);
    }

    @Override
    public void progressStop() {
        --this.startStackDepth;
    }

    private String parseTip(String tip) {
        String[] split;
        for (String s : split = tip.split(" ")) {
            if (!s.startsWith("%")) continue;
            KeyBinding binding = null;
            String sub = s.substring(1);
            GameSettings cfr_ignored_0 = this.minecraft.gameSettings;
            for (KeyBinding b : GameSettings.keys) {
                if (!b.getId().equals(sub)) continue;
                binding = b;
                break;
            }
            if (binding == null) continue;
            return tip.replace(s, TextFormatting.BOLD + binding.getKeyName() + TextFormatting.RESET);
        }
        return tip;
    }

    private void initialize(String title) {
        if (!this.minecraft.running) {
            if (!this.canStop) {
                throw new MinecraftError();
            }
        } else {
            this.title = title;
            if (this.startStackDepth <= 1) {
                List<String> tips = I18n.getInstance().getCurrentLanguage().getTips();
                String tipPre = TextFormatting.YELLOW + I18n.getInstance().translateKey("progress.tip");
                String tipText = this.parseTip(tips.get(new Random().nextInt(tips.size())));
                String tipMain = TextFormatting.WHITE + tipText;
                this.tip = tipPre.replace("%s", tipMain);
            }
            GL11.glClear((int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)this.minecraft.resolution.getExactScaledWidthScreenCoords(), (double)this.minecraft.resolution.getExactScaledHeightScreenCoords(), (double)0.0, (double)100.0, (double)300.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        }
    }

    public void updateLoadingBackground(Dimension dimension) {
        this.backgroundPath = dimension == Dimension.NETHER ? "/assets/minecraft/textures/gui/background-loading-nether.png" : (dimension == Dimension.PARADISE ? "/assets/minecraft/textures/gui/background-loading-paradise.png" : "/assets/minecraft/textures/gui/background.png");
    }

    @Override
    public void progressStage(String stage) {
        if (!this.minecraft.running) {
            if (!this.canStop) {
                throw new MinecraftError();
            }
        } else {
            this.startTime = 0L;
            this.stage = stage;
            this.progressStagePercentage(-1);
            this.startTime = 0L;
        }
    }

    @Override
    public void progressStagePercentage(int progress) {
        if (!this.minecraft.running && !this.canStop) {
            throw new MinecraftError();
        }
        long time = System.currentTimeMillis();
        if (time - this.startTime < 20L) {
            return;
        }
        this.startTime = time;
        this.minecraft.renderer.beginRenderGame(1.0f);
        GL11.glEnable((int)3008);
        int width = this.minecraft.resolution.getScaledWidthScreenCoords();
        int height = this.minecraft.resolution.getScaledHeightScreenCoords();
        GL11.glDisable((int)2929);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.minecraft.resolution.getExactScaledWidthScreenCoords(), (double)this.minecraft.resolution.getExactScaledHeightScreenCoords(), (double)0.0, (double)100.0, (double)300.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-200.0f);
        Tessellator t = Tessellator.instance;
        this.minecraft.textureManager.loadTexture(this.backgroundPath).bind();
        float f = 32.0f;
        t.startDrawingQuads();
        t.setColorOpaque_I(0x404040);
        t.addVertexWithUV(0.0, height, 0.0, 0.0, (float)height / f);
        t.addVertexWithUV(width, height, 0.0, (float)width / f, (float)height / f);
        t.addVertexWithUV(width, 0.0, 0.0, (float)width / f, 0.0);
        t.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        t.draw();
        if (progress >= 0) {
            int barWidth = 100;
            int barHeight = 2;
            int x = width / 2 - barWidth / 2;
            int y = height / 2 + 16;
            GL11.glDisable((int)3553);
            t.startDrawingQuads();
            t.setColorOpaque_I(0x808080);
            t.addVertex(x, y, 0.0);
            t.addVertex(x, y + barHeight, 0.0);
            t.addVertex(x + barWidth, y + barHeight, 0.0);
            t.addVertex(x + barWidth, y, 0.0);
            t.setColorOpaque_I(0x80FF80);
            t.addVertex(x, y, 0.0);
            t.addVertex(x, y + barHeight, 0.0);
            t.addVertex(x + progress, y + barHeight, 0.0);
            t.addVertex(x + progress, y, 0.0);
            t.draw();
            GL11.glEnable((int)3553);
        }
        this.minecraft.font.renderCentered(t, this.title, width / 2, height / 2 - 4 - 16).setShadow().call();
        this.minecraft.font.renderCentered(t, this.stage, width / 2, height / 2 - 4 + 8).setShadow().call();
        this.minecraft.font.renderCentered(t, this.tip, width / 2, height / 2 - 4 + 32).setShadow().call();
        this.minecraft.renderer.endRenderGame(1.0f);
        this.minecraft.gameWindow.update();
    }
}

