/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLamp;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;

public class BlockModelLamp<T extends BlockLogicLamp>
extends BlockModelStandard<T> {
    private static final IconCoordinate[] texCoordsInactive = new IconCoordinate[16];
    private static final IconCoordinate[] texCoordsActive = new IconCoordinate[16];

    public BlockModelLamp(Block<T> block) {
        super(block);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(WorldSource worldSource, int x, int y, int z, Side side) {
        int color = worldSource.getBlockMetadata(x, y, z) & 0xF;
        if (((BlockLogicLamp)this.block.getLogic()).isActive) {
            return texCoordsActive[color];
        }
        return texCoordsInactive[color];
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return texCoordsActive[data & 0xF];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            BlockModelLamp.texCoordsInactive[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/lamp/" + c.colorID + "_idle");
            BlockModelLamp.texCoordsActive[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/lamp/" + c.colorID + "_active");
        }
    }
}

