/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.MobRendererBiped;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.IArmorWearing;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemQuiver;
import net.minecraft.core.item.ItemQuiverEndless;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public abstract class MobRendererBipedArmored<T extends Mob>
extends MobRendererBiped<T> {
    public MobRendererBipedArmored(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull T entity, float brightness, float partialTick, int layer) {
        StaticEntityModel model;
        if (layer == 0) {
            return super.getAndSetupModelForLayer(entity, brightness, partialTick, layer);
        }
        ItemStack itemstack = ((IArmorWearing)entity).getItemInArmorSlot(HumanArmorShape.values()[((IArmorWearing)entity).getNumArmorSlots() - 1 - (layer - 1)]);
        if (itemstack == null) {
            return null;
        }
        Item item = itemstack.getItem();
        if (item instanceof ItemQuiver) {
            this.bindTexture("/assets/minecraft/textures/armor/quiver.png");
        } else if (item instanceof ItemQuiverEndless) {
            this.bindTexture("/assets/minecraft/textures/armor/quiver_golden.png");
        } else if (item == Items.ARMOR_BOOTS_ICESKATES) {
            this.bindTexture("/assets/minecraft/textures/armor/skates.png");
        } else if (item instanceof IArmorItem) {
            IArmorItem armorItem = (IArmorItem)((Object)item);
            if (armorItem.getArmorMaterial() == null) {
                return null;
            }
            this.bindTexture(String.format("/assets/%s/textures/armor/%s_%d.png", armorItem.getArmorMaterial().identifier.namespace, armorItem.getArmorMaterial().identifier.value, layer != 3 ? 1 : 2));
        } else {
            return null;
        }
        switch (layer) {
            case 4: {
                model = this.getModel("armor.boots");
                break;
            }
            case 3: {
                model = this.getModel("armor.leggings");
                break;
            }
            case 2: {
                model = this.getModel("armor.chestplate");
                break;
            }
            case 1: {
                model = this.getModel("armor.helmet");
                break;
            }
            default: {
                return null;
            }
        }
        return this.setupAnimations(entity, model, partialTick, layer);
    }

    @Override
    @Nullable
    protected StaticEntityModel setupAnimations(@NotNull T entity, @Nullable StaticEntityModel model, float partialTick, int layer) {
        StaticEntityModel model1 = super.setupAnimations(entity, model, partialTick, layer);
        switch (layer) {
            case 4: {
                assert (model != null);
                model.getTransform((String)"chest").visible = false;
            }
            case 3: {
                assert (model != null);
                model.getTransform((String)"head").visible = false;
                model.getTransform((String)"rightArm").visible = false;
                model.getTransform((String)"leftArm").visible = false;
                break;
            }
            case 2: {
                assert (model != null);
                model.getTransform((String)"head").visible = false;
                model.getTransform((String)"rightLeg").visible = false;
                model.getTransform((String)"leftLeg").visible = false;
                break;
            }
            case 1: {
                assert (model != null);
                model.getTransform((String)"chest").visible = false;
                model.getTransform((String)"rightArm").visible = false;
                model.getTransform((String)"leftArm").visible = false;
                model.getTransform((String)"rightLeg").visible = false;
                model.getTransform((String)"leftLeg").visible = false;
            }
        }
        return model1;
    }

    @Override
    protected void renderAdditional(@NotNull Tessellator tessellator, @NotNull T entity, float partialTick) {
        @Nullable ItemStack stack = ((IArmorWearing)entity).getItemInArmorSlot(HumanArmorShape.HEAD);
        StaticEntityModel model = this.getActiveModel(entity);
        if (stack != null) {
            GL11.glPushMatrix();
            if (model != null) {
                model.translateToBone("head");
            }
            if (!(stack.getItem() instanceof IArmorItem)) {
                GL11.glPushMatrix();
                GL11.glEnable((int)2884);
                GL11.glScalef((float)-16.0f, (float)16.0f, (float)16.0f);
                GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
                GL11.glTranslatef((float)0.0f, (float)0.4375f, (float)0.0f);
                ItemModelDispatcher.getInstance().getDispatch(stack).render(Tessellator.instance, null, stack, "head", true, 1, LightmapHelper.isLightmapEnabled() ? 1.0f : ((Entity)entity).getBrightness(partialTick), 1.0f, partialTick, true);
                GL11.glDisable((int)2884);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        super.renderAdditional(tessellator, entity, partialTick);
    }

    @Override
    protected int maxRenderLayer(@NotNull T entity) {
        return 4;
    }
}

