/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.entity.MobRendererBiped;
import net.minecraft.core.entity.monster.MobHuman;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererHuman
extends MobRendererBiped<MobHuman> {
    public MobRendererHuman() {
        super(0.5f);
    }

    @Override
    protected void preRenderTransform(@NotNull MobHuman entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotatef((float)(-this.getBodyYaw(entity, partialTick) * MathHelper.RAD_TO_DEG), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)-0.0625f);
        float scale = 0.9375f;
        GL11.glScalef((float)0.9375f, (float)0.9375f, (float)0.9375f);
        if (entity.deathTime > 0) {
            float rotationProgress = ((float)entity.deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            if ((rotationProgress = MathHelper.sqrt_float(rotationProgress)) > 1.0f) {
                rotationProgress = 1.0f;
            }
            GL11.glRotatef((float)(rotationProgress * this.getMaxDeathRotation(entity)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @Override
    public void loadEntityTexture(@NotNull MobHuman entity) {
        this.bindDownloadableTexture(entity.skinUrl, entity.getEntityTexture(), PlayerSkinParser.instance);
    }

    @Override
    @Nullable
    protected StaticEntityModel getActiveModel(@NotNull MobHuman entity) {
        return entity.slimModel ? this.getModel("main.slim") : this.getModel("main");
    }
}

