/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.render.texture.meta.TextureMetaHandler;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.util.helper.Textures;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class TextureFile
extends Texture {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final String sourcePath;
    protected TextureMetaHandler metaHandler = new TextureMetaHandler();

    public TextureFile() {
        this.sourcePath = null;
    }

    public TextureFile(String path) {
        this.generate();
        this.sourcePath = path;
    }

    @Override
    public boolean hasMeta(String key) {
        return this.metaHandler.has(key);
    }

    @Override
    @Nullable
    public <T> T getMeta(String key, Class<T> aClass) {
        return this.metaHandler.get(key, aClass);
    }

    @Override
    public <T> T getOrDefaultMeta(String key, T metaDefault, Class<T> aClass) {
        return this.metaHandler.getOrDefault(key, metaDefault, aClass);
    }

    @Override
    public void init() {
        this.initFileTex(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean initFileTex(boolean defaultMissingTex) {
        this.metaHandler.reset();
        if (this.sourcePath == null) return false;
        Minecraft mc = Minecraft.getMinecraft();
        TexturePack pack = mc.texturePackList.getHighestPriorityTexturePackWithFile(this.sourcePath);
        if (pack == null) {
            if (!defaultMissingTex) return false;
            this.setupTexture(Textures.missingTexture);
            return false;
        }
        try (InputStream stream = pack.getResourceAsStream(this.sourcePath + ".mcmeta");){
            if (stream != null) {
                this.metaHandler.loadFromStream(stream);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load data for '{}.mcmeta'!", (Object)this.sourcePath, (Object)e);
        }
        try (InputStream imageStream = pack.getResourceAsStream(this.sourcePath);){
            if (imageStream == null) {
                if (defaultMissingTex) {
                    this.setupTexture(Textures.missingTexture);
                }
                boolean bl = false;
                return bl;
            }
            this.setupTexture(Textures.readImage(imageStream));
            return true;
        }
        catch (IOException e) {
            if (!defaultMissingTex) return false;
            this.setupTexture(Textures.missingTexture);
            return false;
        }
    }

    public String toString() {
        return "Source: " + this.sourcePath + "\nMeta: \n" + this.metaHandler;
    }
}

