/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.worldtype;

import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.type.WorldType;

public class WorldTypeFXEmpty
extends WorldTypeFX {
    public WorldTypeFXEmpty(WorldType worldType) {
        super(worldType);
    }

    @Override
    public Vec3 getFogColor(World world, double x, double y, double z, float celestialAngle, float partialTick) {
        float f2 = MathHelper.cos(celestialAngle * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float r = 0.7529412f;
        float g = 0.8470588f;
        float b = 1.0f;
        return Vec3.getTempVec3(r *= f2 * 0.94f + 0.06f, g *= f2 * 0.94f + 0.06f, b *= f2 * 0.91f + 0.09f);
    }

    @Override
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        float f4;
        float[] sunriseCol = new float[4];
        float f2 = 0.4f;
        float f3 = MathHelper.cos(timeOfDay * (float)Math.PI * 2.0f) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float c = (f3 - f4) / f2 * 0.5f + 0.5f;
            float a = 1.0f - (1.0f - MathHelper.sin(c * (float)Math.PI)) * 0.99f;
            a *= a;
            sunriseCol[0] = c * 0.3f + 0.7f;
            sunriseCol[1] = c * c * 0.7f + 0.2f;
            sunriseCol[2] = c * c * 0.0f + 0.2f;
            sunriseCol[3] = a;
            return sunriseCol;
        }
        return null;
    }
}

