/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public final class FileOpener {
    public static boolean toClipboard(String path) {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (os.contains("win")) {
            return FileOpener.run("powershell", "-Command %s", "Get-ChildItem \"" + path + "\" | Set-Clipboard");
        }
        if (os.contains("mac")) {
            return FileOpener.run("osascript", "-e %s", "set the clipboard to (read (POSIX file \"" + path + "\") as {\u00abclass PNGf\u00bb})");
        }
        return FileOpener.run("xclip-copyfile", "%s", path);
    }

    public static void open(File file) {
        if (!FileOpener.openSystem(file.getPath()) && !FileOpener.openDESKTOP(file)) {
            System.err.println("unable to open file " + System.getProperty("os.name"));
        }
    }

    private static boolean openSystem(String what) {
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (os.contains("win")) {
            return FileOpener.run("explorer", "%s", what);
        }
        if (os.contains("mac")) {
            return FileOpener.run("open", "%s", what);
        }
        return FileOpener.run("kde-open", "%s", what) || FileOpener.run("gnome-open", "%s", what) || FileOpener.run("xdg-open", "%s", what);
    }

    private static boolean openDESKTOP(File file) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            try {
                Desktop.getDesktop().open(file);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static boolean run(String command, String arg, String file) {
        String[] args = arg.split(" ");
        CharSequence[] parts = new String[args.length + 1];
        parts[0] = command;
        for (int i = 0; i < args.length; ++i) {
            parts[i + 1] = String.format(args[i], file).trim();
        }
        System.out.println(String.join((CharSequence)" ", parts));
        try {
            Process p = Runtime.getRuntime().exec((String[])parts);
            if (p == null) {
                return false;
            }
            try {
                return p.exitValue() == 0;
            }
            catch (IllegalThreadStateException itse) {
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
    }
}

