/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobMonsterArmored;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobSkeleton
extends MobMonsterArmored<HumanArmorShape> {
    private static final ItemStack DEFAULT_HELD_ITEM = new ItemStack(Items.TOOL_BOW, 1);
    public static final int DATA_ATTACK_TIME = 15;

    public MobSkeleton(World world) {
        super(world);
        this.setTextureIdentifier("minecraft", "skeleton");
        this.scoreValue = 500;
        this.mobDrops.add(new WeightedRandomLootObject(Items.AMMO_ARROW.getDefaultStack(), 0, 2));
        this.mobDrops.add(new WeightedRandomLootObject(Items.BONE.getDefaultStack(), 0, 2));
    }

    @Override
    public String getLivingSound() {
        return "mob.skeleton";
    }

    @Override
    protected String getHurtSound() {
        return "mob.skeletonhurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.skeletonhurt";
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(15, this.attackTime, Integer.class);
    }

    @Override
    public void spawnInit() {
        super.spawnInit();
        this.setHeldItem(DEFAULT_HELD_ITEM.copy());
    }

    @Override
    public void onLivingUpdate() {
        Weather weather;
        float f;
        if (this.world.isClientSide) {
            this.attackTime = this.entityData.getInt(15);
        } else {
            this.entityData.set(15, this.attackTime);
        }
        if (this.world.isDaytime() && (f = this.getBrightness(1.0f)) > 0.5f && this.world.canBlockSeeTheSky(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z)) && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && (weather = this.world.getCurrentWeather()) != null && !weather.isDamp() && (weather != Weathers.OVERWORLD_FOG || this.world.weatherManager.getWeatherPower() < 0.75f)) {
            this.remainingFireTicks = 300;
        }
        super.onLivingUpdate();
    }

    @Override
    protected void attackEntity(@NotNull Entity entity, float distance) {
        if (distance < 10.0f) {
            double d = entity.x - this.x;
            double d1 = entity.z - this.z;
            if (this.attackTime == 0) {
                if (!this.world.isClientSide) {
                    ProjectileArrow arrow = new ProjectileArrow(this.world, this, false, 0);
                    double d2 = entity.y + (double)entity.getHeadHeight() - 0.2 - arrow.y;
                    float f1 = MathHelper.sqrt(d * d + d1 * d1) * 0.2f;
                    this.world.playSoundAtEntity(null, this, "random.bow", 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 0.8f));
                    arrow.setHeading(d, d2 + (double)f1, d1, 0.6f, 12.0f);
                    this.world.entityJoinedWorld(arrow);
                }
                this.attackTime = 30;
            }
            this.yRot = (float)(Math.atan2(d1, d) * 180.0 / Math.PI) - 90.0f;
            this.hasAttacked = true;
        }
    }

    @Override
    public int getNumArmorSlots() {
        return HumanArmorShape.values().length;
    }

    @Override
    @Nullable
    public HumanArmorShape getArmorSlotByIndex(int index) {
        if (index < 0 || index >= HumanArmorShape.values().length) {
            return null;
        }
        return HumanArmorShape.values()[index];
    }

    @Override
    @Nullable
    public ItemStack getHeldItem() {
        return DEFAULT_HELD_ITEM;
    }
}

