/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelPumice<T extends BlockLogic>
extends BlockModelStandard<T> {
    private boolean lavaFlag = false;

    public BlockModelPumice(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        this.lavaFlag = true;
        boolean ob = BlockModelPumice.renderBlocks.overbright;
        BlockModelPumice.renderBlocks.overbright = true;
        boolean rendered = super.render(tessellator, worldSource, x, y, z);
        BlockModelPumice.renderBlocks.overbright = ob;
        this.lavaFlag = false;
        return rendered |= super.render(tessellator, worldSource, x, y, z);
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (BlockModelPumice.renderBlocks.useInventoryTint) {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        }
        float yOffset = 0.5f;
        GL11.glTranslatef((float)-0.5f, (float)(0.0f - yOffset), (float)-0.5f);
        this.lavaFlag = true;
        boolean ob = BlockModelPumice.renderBlocks.overbright;
        BlockModelPumice.renderBlocks.overbright = true;
        double depthFixOffset = 0.001;
        AABB bounds = AABB.getTemporaryBB(0.001, 0.001, 0.001, 0.999, 0.999, 0.999);
        this.renderBlockWithBounds(tessellator, bounds, metadata, brightness, alpha, LightmapHelper.getLightmapCoord(15, 15));
        BlockModelPumice.renderBlocks.overbright = ob;
        this.lavaFlag = false;
        if (LightmapHelper.isLightmapEnabled()) {
            lightmapCoordinate = Minecraft.getMinecraft().thePlayer.getLightmapCoord(1.0f);
        }
        bounds.set(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.renderBlockWithBounds(tessellator, bounds, metadata, brightness, alpha, lightmapCoordinate);
        GL11.glTranslatef((float)0.5f, (float)yOffset, (float)0.5f);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (this.lavaFlag) {
            return TextureRegistry.getTexture("minecraft:block/lava_still");
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockOverbrightTextureFromSideAndMeta(Side side, int data) {
        if (this.lavaFlag) {
            return TextureRegistry.getTexture("minecraft:block/lava_still");
        }
        return super.getBlockOverbrightTextureFromSideAndMeta(side, data);
    }
}

