/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.Global;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.EntityPrimedTNT;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class EntityRendererTNT
extends EntityRenderer<EntityPrimedTNT> {
    public EntityRendererTNT() {
        this.shadowSize = 0.5f;
    }

    @Override
    public void render(@NotNull Tessellator tessellator, @NotNull EntityPrimedTNT tnt, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        if ((float)tnt.fuse - partialTick + 1.0f < 10.0f) {
            float f2 = 1.0f - ((float)tnt.fuse - partialTick + 1.0f) / 10.0f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            f2 *= f2;
            f2 *= f2;
            float f4 = 1.0f + f2 * 0.3f;
            GL11.glScalef((float)f4, (float)f4, (float)f4);
        }
        float f3 = (1.0f - ((float)tnt.fuse - partialTick + 1.0f) / 100.0f) * 0.8f;
        TextureRegistry.blockAtlas.bind();
        float brightness = tnt.getBrightness(partialTick);
        if (Global.accessor.isFullbrightEnabled()) {
            brightness = 1.0f;
        }
        BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.TNT);
        model.renderStandalone(tessellator, 0, brightness, 1.0f, null);
        if (tnt.fuse / 5 % 2 == 0) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)772);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f3);
            model.renderStandalone(tessellator, 0, 1.0f, 1.0f, null);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
        }
        GL11.glPopMatrix();
    }
}

