/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.IItemHolding;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public abstract class MobRendererBiped<T extends Mob>
extends MobRenderer<T> {
    public MobRendererBiped(float shadowSize) {
        super(shadowSize);
    }

    @Nullable
    protected abstract StaticEntityModel getActiveModel(@NotNull T var1);

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull T entity, float brightness, float partialTick, int layer) {
        return this.setupAnimations(entity, this.getActiveModel(entity), partialTick, layer);
    }

    @Nullable
    protected StaticEntityModel setupAnimations(@NotNull T entity, @Nullable StaticEntityModel model, float partialTick, int layer) {
        double rotX;
        if (model == null) {
            return null;
        }
        model.resetBones();
        BoneTransform rightArm = model.getTransform("rightArm");
        BoneTransform leftArm = model.getTransform("leftArm");
        BoneTransform rightLeg = model.getTransform("rightLeg");
        BoneTransform leftLeg = model.getTransform("leftLeg");
        BoneTransform torso = model.getTransform("torso");
        BoneTransform waist = model.getTransform("waist");
        BoneTransform head = model.getTransform("head");
        float bodyYaw = this.getBodyYaw(entity, partialTick);
        float headYaw = this.getHeadYaw(entity, partialTick) - bodyYaw;
        float headPitch = this.getHeadPitch(entity, partialTick);
        float limbSwing = this.getLimbSwing(entity, partialTick);
        float limbYaw = this.getLimbYaw(entity, partialTick);
        float limbPitch = this.getLimbPitch(entity, partialTick);
        float swingProgress = ((Mob)entity).getSwingProgress(partialTick);
        head.rotX = headPitch;
        head.rotY = headYaw;
        if (((Entity)entity).getHeldObject() != null) {
            rightArm.rotX = rotX = Math.cos(limbSwing / 2.0f * 0.6662f) * 2.0 * (double)limbYaw * 0.125 - (double)0.65f;
            leftArm.rotX = rotX;
            limbPitch = 180.0f;
        } else {
            rightArm.rotX = Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbYaw * 0.5;
            leftArm.rotX = Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbYaw * 0.5;
        }
        rightLeg.rotX = Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbYaw;
        leftLeg.rotX = Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbYaw;
        if (((Mob)entity).vehicle != null) {
            rightArm.rotX += (double)(-36.0f * MathHelper.DEG_TO_RAD);
            leftArm.rotX += (double)(-36.0f * MathHelper.DEG_TO_RAD);
            rightLeg.rotX = -72.0f * MathHelper.DEG_TO_RAD;
            leftLeg.rotX = -72.0f * MathHelper.DEG_TO_RAD;
            rightLeg.rotY = 18.0f * MathHelper.DEG_TO_RAD;
            leftLeg.rotY = -18.0f * MathHelper.DEG_TO_RAD;
        }
        if (entity instanceof IItemHolding) {
            boolean hasItem;
            boolean bl = hasItem = ((IItemHolding)entity).getHeldItem() != null;
            if (hasItem) {
                if (((IItemHolding)entity).isLeftHanded()) {
                    leftArm.rotX = leftArm.rotX * 0.5 - (double)(18.0f * MathHelper.DEG_TO_RAD);
                } else {
                    rightArm.rotX = rightArm.rotX * 0.5 - (double)(18.0f * MathHelper.DEG_TO_RAD);
                }
            }
        }
        if (((Entity)entity).getHeldObject() != null) {
            rotX = Math.sin(Math.sqrt(swingProgress) * Math.PI * -2.0) * (double)0.4f;
            rightArm.rotX += rotX;
            leftArm.rotX += rotX;
        } else if (entity instanceof IItemHolding && ((IItemHolding)entity).isLeftHanded()) {
            torso.rotY = Math.sin(Math.sqrt(swingProgress) * Math.PI * -2.0) * (double)0.2f;
            float f6 = 1.0f - swingProgress;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            double f7 = Math.sin((double)f6 * Math.PI);
            double f8 = Math.sin((double)swingProgress * Math.PI) * -(Math.toRadians(headPitch) - (double)0.7f) * 0.75;
            leftArm.rotX -= f7 * 1.2 + f8;
            leftArm.rotY += torso.rotY * 2.0;
            leftArm.rotZ = Math.sin((double)swingProgress * Math.PI) * (double)0.4f;
        } else {
            torso.rotY = Math.sin(Math.sqrt(swingProgress) * Math.PI * 2.0) * (double)0.2f;
            float f6 = 1.0f - swingProgress;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            double f7 = Math.sin((double)f6 * Math.PI);
            double f8 = Math.sin((double)swingProgress * Math.PI) * -(Math.toRadians(headPitch) - (double)0.7f) * 0.75;
            rightArm.rotX -= f7 * 1.2 + f8;
            rightArm.rotY += torso.rotY * 2.0;
            rightArm.rotZ = Math.sin((double)swingProgress * Math.PI) * (double)-0.4f;
        }
        if (((Entity)entity).isSneaking()) {
            leftLeg.posZ += 5.0;
            rightLeg.posZ += 5.0;
            head.posY -= 2.0;
            torso.posY -= 2.0;
            torso.rotX = 0.5;
            rightArm.rotX -= (double)0.2f;
            leftArm.rotX -= (double)0.2f;
            if (((Entity)entity).getHeldObject() != null) {
                rightArm.rotX -= (double)0.4f;
                leftArm.rotX -= (double)0.4f;
            }
        }
        rightArm.rotZ += Math.cos(limbPitch * 0.09f) * (double)0.05f + (double)0.05f;
        leftArm.rotZ -= Math.cos(limbPitch * 0.09f) * (double)0.05f + (double)0.05f;
        rightArm.rotX += Math.sin(limbPitch * 0.067f) * (double)0.05f;
        leftArm.rotX -= Math.sin(limbPitch * 0.067f) * (double)0.05f;
        return model;
    }

    @Override
    protected void renderAdditional(@NotNull Tessellator tessellator, @NotNull T entity, float partialTick) {
        if (entity instanceof IItemHolding) {
            IItemHolding itemHolder = (IItemHolding)entity;
            ItemStack itemstack = itemHolder.getHeldItem();
            StaticEntityModel model = this.getActiveModel(entity);
            if (itemstack != null) {
                GL11.glPushMatrix();
                if (((IItemHolding)entity).isLeftHanded()) {
                    if (model != null) {
                        model.translateToBone("leftItem");
                    }
                    GL11.glScalef((float)-1.0f, (float)1.0f, (float)-1.0f);
                    GL11.glScalef((float)16.0f, (float)16.0f, (float)16.0f);
                    ItemModelDispatcher.getInstance().getDispatch(itemstack).render(tessellator, (Entity)entity, itemstack, "thirdperson_lefthand", true, 1, LightmapHelper.isLightmapEnabled() ? 1.0f : ((Entity)entity).getBrightness(partialTick), 1.0f, partialTick, true);
                } else {
                    if (model != null) {
                        model.translateToBone("rightItem");
                    }
                    GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
                    GL11.glScalef((float)16.0f, (float)16.0f, (float)16.0f);
                    ItemModelDispatcher.getInstance().getDispatch(itemstack).render(tessellator, (Entity)entity, itemstack, "thirdperson_righthand", true, 1, LightmapHelper.isLightmapEnabled() ? 1.0f : ((Entity)entity).getBrightness(partialTick), 1.0f, partialTick, false);
                }
                GL11.glPopMatrix();
            }
        }
    }
}

