/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import java.util.HashSet;
import java.util.List;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.terrain.RenderRegion;
import net.minecraft.client.render.terrain.TerrainRendererMultiDraw;
import net.minecraft.client.render.terrain.VertexBuffer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tessellator.TessellatorStandard;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCache;

public class ChunkRendererMultiDraw
extends ChunkRenderer {
    public final TerrainRendererMultiDraw terrainRenderer;
    public final VertexBuffer.Entry[] renderListEntries;

    public ChunkRendererMultiDraw(TerrainRendererMultiDraw terrainRenderer, World world, List<TileEntity> globalRenderableTileEntities, int x, int y, int z, int size, int lists) {
        super(world, globalRenderableTileEntities, x, y, z, size, lists);
        if (terrainRenderer == null) {
            throw new NullPointerException("TerrainRenderer is null!");
        }
        this.terrainRenderer = terrainRenderer;
        this.renderListEntries = new VertexBuffer.Entry[terrainRenderer.MAX_RENDER_PASSES];
    }

    @Override
    public void rebuild() {
        if (!this.dirty) {
            return;
        }
        ++updates;
        int minX = this.posX;
        int minY = this.posY;
        int minZ = this.posZ;
        int maxX = this.posX + this.sizeX;
        int maxY = this.posY + this.sizeY;
        int maxZ = this.posZ + this.sizeZ;
        int renderPassCount = this.terrainRenderer.MAX_RENDER_PASSES;
        this.terrainRenderer.chunkDeleted(this);
        Chunk.isLit = false;
        HashSet lastSpecialTileEntities = new HashSet(this.renderableBlockEntities);
        this.renderableBlockEntities.clear();
        boolean cacheRadius = true;
        ChunkCache chunkCache = new ChunkCache(this.world, minX - 1, minY - 1, minZ - 1, maxX + 1, maxY + 1, maxZ + 1);
        TessellatorStandard tessellator = (TessellatorStandard)Tessellator.instance;
        for (int renderPass = 0; renderPass < renderPassCount; ++renderPass) {
            boolean needsMoreRenderPasses = false;
            boolean hasRenderedBlock = false;
            boolean hasStartedDrawing = false;
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        BlockModel model;
                        int blockRenderPass;
                        TileEntity tileentity;
                        int blockId = chunkCache.getBlockId(x, y, z);
                        if (blockId <= 0) continue;
                        if (!hasStartedDrawing) {
                            hasStartedDrawing = true;
                            tessellator.startDrawingQuads();
                            RenderRegion region = this.terrainRenderer.getRenderRegionAtBlockPos(this.posX, this.posZ);
                            tessellator.setTranslation(-(region.posX << this.terrainRenderer.REGION_SIZE), 0.0, -(region.posZ << this.terrainRenderer.REGION_SIZE));
                            if (LightmapHelper.isLightmapEnabled()) {
                                tessellator.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 15));
                            }
                            tessellator.setColorRGBA(255, 255, 255, 255);
                            tessellator.setTextureUV(0.0, 0.0);
                        }
                        if (renderPass == 0 && Blocks.isEntityTile[blockId] && TileEntityRenderDispatcher.instance.hasRenderer(tileentity = chunkCache.getTileEntity(x, y, z))) {
                            this.renderableBlockEntities.add(tileentity);
                        }
                        if ((blockRenderPass = (model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.blocksList[blockId])).renderLayer()) != renderPass) {
                            needsMoreRenderPasses = true;
                            continue;
                        }
                        hasRenderedBlock |= this.renderBlock(tessellator, this.world, model, x, y, z);
                    }
                }
            }
            if (hasStartedDrawing) {
                this.terrainRenderer.chunkRendered(this, tessellator, renderPass);
                tessellator.setTranslation(0.0, 0.0, 0.0);
            } else {
                hasRenderedBlock = false;
            }
            if (hasRenderedBlock) {
                this.empty[renderPass] = false;
            }
            if (!needsMoreRenderPasses) break;
        }
        HashSet newSpecialTileEntities = new HashSet(this.renderableBlockEntities);
        newSpecialTileEntities.removeAll(lastSpecialTileEntities);
        this.globalRenderableBlockEntities.addAll(newSpecialTileEntities);
        this.renderableBlockEntities.forEach(lastSpecialTileEntities::remove);
        this.globalRenderableBlockEntities.removeAll(lastSpecialTileEntities);
        this.skyLit = Chunk.isLit;
        this.compiled = true;
    }

    @Override
    public void cull(CameraFrustum frustum, float partialTick) {
        boolean wasVisible = this.visible;
        super.cull(frustum, partialTick);
        if (wasVisible != this.visible) {
            this.terrainRenderer.chunkVisibilityChanged(this);
        }
    }

    @Override
    public void reset() {
        if (this.terrainRenderer != null) {
            this.terrainRenderer.chunkDeleted(this);
        }
        super.reset();
    }

    public String toString() {
        return "[" + this.posX + "," + this.posY + "," + this.posZ + "]";
    }
}

