/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.net.packet.PacketAnimate;
import net.minecraft.core.net.packet.PacketBoatControl;
import net.minecraft.core.net.packet.PacketChat;
import net.minecraft.core.net.packet.PacketContainerClose;
import net.minecraft.core.net.packet.PacketCustomPayload;
import net.minecraft.core.net.packet.PacketGuidebook;
import net.minecraft.core.net.packet.PacketMovePlayer;
import net.minecraft.core.net.packet.PacketPlayerAction;
import net.minecraft.core.net.packet.PacketPlayerConfig;
import net.minecraft.core.net.packet.PacketRespawn;
import net.minecraft.core.net.packet.PacketSetHotbarOffset;
import net.minecraft.core.net.packet.PacketUpdateCreativeInventory;
import net.minecraft.core.net.packet.PacketUpdatePlayerState;
import net.minecraft.core.player.Session;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class PlayerLocalMultiplayer
extends PlayerLocal
implements Player.PlayerConfig.PlayerConfigListener {
    public PacketHandlerClient sendQueue;
    private int lastInventorySendTime = 0;
    private boolean flashOnSetHealth = false;
    private double oldPosX;
    private double oldPosY1;
    private double oldPosY2;
    private double oldPosZ;
    private float oldRotationYaw;
    private float oldRotationPitch;
    private boolean wasOnGround = false;
    private boolean wasSneaking = false;
    private int noSendTime = 0;

    public PlayerLocalMultiplayer(Minecraft minecraft, World world, Session session, PacketHandlerClient netclienthandler) {
        super(minecraft, world, session, 0);
        this.sendQueue = netclienthandler;
        this.playerConfig.assignListener(this);
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        return false;
    }

    @Override
    public void heal(int i) {
    }

    @Override
    public void tick() {
        if (!this.world.isBlockLoaded(MathHelper.floor(this.x), 64, MathHelper.floor(this.z))) {
            return;
        }
        super.tick();
        this.sendPosition();
    }

    public void sendPosition() {
        boolean flag2;
        boolean flag;
        if (this.lastInventorySendTime++ == 20) {
            this.sendInventoryChanged();
            this.lastInventorySendTime = 0;
        }
        if ((flag = this.isSneaking()) != this.wasSneaking) {
            if (flag) {
                this.sendQueue.addToSendQueue(new PacketUpdatePlayerState(1));
            } else {
                this.sendQueue.addToSendQueue(new PacketUpdatePlayerState(2));
            }
            this.wasSneaking = flag;
        }
        double d = this.x - this.oldPosX;
        double d1 = this.bb.minY - this.oldPosY1;
        double d2 = this.y - this.oldPosY2;
        double d3 = this.z - this.oldPosZ;
        double d4 = this.yRot - this.oldRotationYaw;
        double d5 = this.xRot - this.oldRotationPitch;
        boolean flag1 = d1 != 0.0 || d2 != 0.0 || d != 0.0 || d3 != 0.0;
        boolean bl = flag2 = d4 != 0.0 || d5 != 0.0;
        if (this.vehicle != null) {
            if (flag2) {
                this.sendQueue.addToSendQueue(new PacketMovePlayer.Pos(this.xd, -999.0, this.zd, this.onGround));
            } else {
                this.sendQueue.addToSendQueue(new PacketMovePlayer.PosRot(this.xd, -999.0, this.zd, this.yRot, this.xRot, this.onGround));
            }
            flag1 = false;
        } else if (flag1 && flag2) {
            this.sendQueue.addToSendQueue(new PacketMovePlayer.PosRot(this.x, this.bb.minY, this.z, this.yRot, this.xRot, this.onGround));
            this.noSendTime = 0;
        } else if (flag1) {
            this.sendQueue.addToSendQueue(new PacketMovePlayer.Pos(this.x, this.bb.minY, this.z, this.onGround));
            this.noSendTime = 0;
        } else if (flag2) {
            this.sendQueue.addToSendQueue(new PacketMovePlayer.Rot(this.yRot, this.xRot, this.onGround));
            this.noSendTime = 0;
        } else {
            this.sendQueue.addToSendQueue(new PacketMovePlayer(this.onGround));
            this.noSendTime = this.wasOnGround != this.onGround || this.noSendTime > 200 ? 0 : ++this.noSendTime;
        }
        this.wasOnGround = this.onGround;
        if (flag1) {
            this.oldPosX = this.x;
            this.oldPosY1 = this.bb.minY;
            this.oldPosY2 = this.y;
            this.oldPosZ = this.z;
        }
        if (flag2) {
            this.oldRotationYaw = this.yRot;
            this.oldRotationPitch = this.xRot;
        }
    }

    @Override
    public void dropCurrentItem(boolean dropFullStack) {
        this.sendQueue.addToSendQueue(new PacketPlayerAction(dropFullStack ? 5 : 4, 0, 0, 0, Side.NONE, 0.0, 0.0));
    }

    private void sendInventoryChanged() {
    }

    @Override
    protected void joinEntityItemWithWorld(EntityItem entityitem) {
    }

    @Override
    public void sendChatMessage(String s) {
        this.sendQueue.addToSendQueue(new PacketChat(s, AES.clientKeyChain));
        this.addToSendHistory(s);
    }

    @Override
    public void updateCreativeInventory(int page, String searchText) {
        this.sendQueue.addToSendQueue(new PacketUpdateCreativeInventory(this.craftingInventory.containerId, page, searchText));
    }

    @Override
    public void setHotbarOffset(int offset) {
        super.setHotbarOffset(offset);
        this.sendQueue.addToSendQueue(new PacketSetHotbarOffset(offset));
    }

    @Override
    public void displayGuidebookScreen() {
        this.mc.displayScreen(new ScreenGuidebook(this.mc.currentScreen));
        this.sendQueue.addToSendQueue(new PacketGuidebook(this.mc.currentScreen instanceof ScreenGuidebook));
    }

    @Override
    public void swingItem() {
        super.swingItem();
        this.sendQueue.addToSendQueue(new PacketAnimate(this, 1));
    }

    @Override
    public void respawnPlayer() {
        this.sendInventoryChanged();
        this.sendQueue.addToSendQueue(new PacketRespawn((byte)this.dimension, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(this.world.worldType)));
    }

    @Override
    protected void damageEntity(int i, DamageType damageType) {
        this.setHealthRaw(this.getHealth() - i);
    }

    @Override
    public void closeScreen() {
        this.sendQueue.addToSendQueue(new PacketContainerClose(this.craftingInventory.containerId));
        this.inventory.setHeldItemStack(null);
        super.closeScreen();
    }

    @Override
    public void setHealth(int i) {
        if (this.flashOnSetHealth) {
            super.setHealth(i);
        } else {
            this.setHealthRaw(i);
            this.flashOnSetHealth = true;
        }
    }

    @Override
    public int getStat(Stat stat) {
        if (stat.clientside) {
            return super.getStat(stat);
        }
        return 0;
    }

    @Override
    public void syncPlacementMode() {
        super.syncPlacementMode();
        byte[] data = new byte[]{(byte)(this.rotationLock != null ? this.rotationLock.getId() : -1), (byte)(this.rotationLockHorizontal != null ? this.rotationLockHorizontal.getId() : -1), (byte)(this.rotationLockVertical != null ? this.rotationLockVertical.getId() : -1), (byte)(this.placementModeOverride != null ? this.placementModeOverride.index() : -1)};
        this.sendQueue.addToSendQueue(new PacketCustomPayload("BTA|RotationLock", data));
    }

    @Override
    public void pickBlock(int x, int y, int z, boolean pickFully) {
        this.sendQueue.addToSendQueue(new PacketPlayerAction(pickFully ? 7 : 6, x, y, z, Side.NONE, 0.0, 0.0));
    }

    @Override
    public void sendSpecialVehiclePacket() {
        if (this.vehicle instanceof EntityBoat) {
            this.sendQueue.addToSendQueue(new PacketBoatControl((EntityBoat)this.vehicle));
        }
    }

    @Override
    public void onValueChange() {
        this.sendQueue.addToSendQueue(new PacketPlayerConfig(this.playerConfig));
    }
}

