/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.handler;

import com.b100.utils.StringUtils;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.ParticlePickupAnimation;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.entity.player.PlayerRemote;
import net.minecraft.client.gui.ScreenConnectFailed;
import net.minecraft.client.gui.ScreenDownloadTerrain;
import net.minecraft.client.gui.ScreenPause;
import net.minecraft.client.gui.chat.GuiElementChatSuggestions;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.gui.guidebook.search.GuidebookPageSearch;
import net.minecraft.client.player.controller.PlayerControllerMP;
import net.minecraft.client.world.WorldClientMP;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFurnace;
import net.minecraft.core.block.entity.TileEntityFurnaceBlast;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntityTrommel;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeRegistry;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.item.ItemMap;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.PlayerProfile;
import net.minecraft.core.net.entity.NetEntityHandler;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketAESSendKey;
import net.minecraft.core.net.packet.PacketAddEntity;
import net.minecraft.core.net.packet.PacketAddItemEntity;
import net.minecraft.core.net.packet.PacketAddMob;
import net.minecraft.core.net.packet.PacketAddPainting;
import net.minecraft.core.net.packet.PacketAddParticle;
import net.minecraft.core.net.packet.PacketAddPlayer;
import net.minecraft.core.net.packet.PacketAnimate;
import net.minecraft.core.net.packet.PacketBedMessage;
import net.minecraft.core.net.packet.PacketBlockEvent;
import net.minecraft.core.net.packet.PacketBlockRegionUpdate;
import net.minecraft.core.net.packet.PacketBlockUpdate;
import net.minecraft.core.net.packet.PacketBoatControl;
import net.minecraft.core.net.packet.PacketChat;
import net.minecraft.core.net.packet.PacketChunkBlocksUpdate;
import net.minecraft.core.net.packet.PacketChunkVisibility;
import net.minecraft.core.net.packet.PacketCommandManager;
import net.minecraft.core.net.packet.PacketContainerAck;
import net.minecraft.core.net.packet.PacketContainerClose;
import net.minecraft.core.net.packet.PacketContainerOpen;
import net.minecraft.core.net.packet.PacketContainerSetContent;
import net.minecraft.core.net.packet.PacketContainerSetData;
import net.minecraft.core.net.packet.PacketContainerSetSlot;
import net.minecraft.core.net.packet.PacketCustomPayload;
import net.minecraft.core.net.packet.PacketDisconnect;
import net.minecraft.core.net.packet.PacketEntityEvent;
import net.minecraft.core.net.packet.PacketEntityNickname;
import net.minecraft.core.net.packet.PacketEntityTagData;
import net.minecraft.core.net.packet.PacketExplosion;
import net.minecraft.core.net.packet.PacketFlagOpen;
import net.minecraft.core.net.packet.PacketGameRule;
import net.minecraft.core.net.packet.PacketLogin;
import net.minecraft.core.net.packet.PacketMapData;
import net.minecraft.core.net.packet.PacketMoveEntity;
import net.minecraft.core.net.packet.PacketMovePlayer;
import net.minecraft.core.net.packet.PacketPhotoMode;
import net.minecraft.core.net.packet.PacketPlaySoundEffect;
import net.minecraft.core.net.packet.PacketPlaySoundEffectDirect;
import net.minecraft.core.net.packet.PacketPlayerConfig;
import net.minecraft.core.net.packet.PacketPlayerGamemode;
import net.minecraft.core.net.packet.PacketPlayerList;
import net.minecraft.core.net.packet.PacketPreLogin;
import net.minecraft.core.net.packet.PacketRecipeSync;
import net.minecraft.core.net.packet.PacketRemoveEntity;
import net.minecraft.core.net.packet.PacketRespawn;
import net.minecraft.core.net.packet.PacketSetCarriedItem;
import net.minecraft.core.net.packet.PacketSetEntityData;
import net.minecraft.core.net.packet.PacketSetEntityMotion;
import net.minecraft.core.net.packet.PacketSetEquippedItem;
import net.minecraft.core.net.packet.PacketSetHealth;
import net.minecraft.core.net.packet.PacketSetHeldObject;
import net.minecraft.core.net.packet.PacketSetHotbarOffset;
import net.minecraft.core.net.packet.PacketSetMobSpawner;
import net.minecraft.core.net.packet.PacketSetRiding;
import net.minecraft.core.net.packet.PacketSetSpawnPosition;
import net.minecraft.core.net.packet.PacketSetTime;
import net.minecraft.core.net.packet.PacketSleep;
import net.minecraft.core.net.packet.PacketStatistic;
import net.minecraft.core.net.packet.PacketSyncIDs;
import net.minecraft.core.net.packet.PacketTakeItemEntity;
import net.minecraft.core.net.packet.PacketTeleportEntity;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.net.packet.PacketUpdatePlayerProfile;
import net.minecraft.core.net.packet.PacketWeatherEffect;
import net.minecraft.core.net.packet.PacketWeatherStatus;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.ContainerSimple;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.sound.SoundTypes;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.world.Explosion;
import net.minecraft.core.world.ExplosionCannonball;
import net.minecraft.core.world.ICarriable;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.data.SynchedEntityData;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.saveddata.SavedDataStorage;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.slf4j.Logger;

public class PacketHandlerClient
extends PacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private boolean disconnected = false;
    private final NetworkManager netManager;
    public String message;
    private final Minecraft mc;
    private WorldClientMP worldClientMP;
    private boolean started = false;
    public SavedDataStorage savedDataStorage;
    public List<PlayerProfile> players;
    public HashMap<String, String> playerList = new HashMap();
    Random rand;

    public PacketHandlerClient(Minecraft minecraft, String host, int port) throws UnknownHostException, IOException {
        this.savedDataStorage = new SavedDataStorage(null);
        this.rand = new Random();
        this.mc = minecraft;
        Socket socket = new Socket(InetAddress.getByName(host), port);
        this.netManager = new NetworkManager(socket, "Client", this);
        this.players = new ArrayList<PlayerProfile>();
    }

    public void tick() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    public int findPlayerInList(PlayerProfile playerProfile) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!this.players.get((int)i).playerName.equals(playerProfile.playerName)) continue;
            return i;
        }
        return -1;
    }

    public void addPlayer(PlayerProfile playerProfile) {
        this.players.add(playerProfile);
    }

    public PlayerProfile getPlayer(String username) {
        for (PlayerProfile player : this.players) {
            if (!player.playerName.equals(username)) continue;
            return player;
        }
        return null;
    }

    public void removePlayer(int index) {
        this.players.remove(index);
    }

    @Override
    public void handleLogin(PacketLogin loginPacket) {
        this.mc.playerController = new PlayerControllerMP(this.mc, this);
        this.mc.statsCounter.add(StatList.joinMultiplayerStat, 1);
        this.worldClientMP = new WorldClientMP(this, loginPacket.worldSeed, loginPacket.dimensionId, loginPacket.worldTypeId);
        this.worldClientMP.isClientSide = true;
        this.mc.changeWorld(this.worldClientMP);
        this.mc.thePlayer.dimension = loginPacket.dimensionId;
        this.mc.displayScreen(new ScreenDownloadTerrain(this));
        this.mc.thePlayer.id = loginPacket.playerEntityIdAndProtocolVersion;
        NetworkManager.PACKET_DELAY = loginPacket.packetDelay;
        Registries.RECIPES = new RecipeRegistry();
        this.addToSendQueue(new PacketPlayerConfig(this.mc.thePlayer.playerConfig));
    }

    @Override
    public void handlePlayerConfig(PacketPlayerConfig packetPlayerConfig) {
        Entity e;
        if (packetPlayerConfig.entityId >= 0 && packetPlayerConfig.entityId != this.mc.thePlayer.id && (e = this.getEntityByID(packetPlayerConfig.entityId)) instanceof Player) {
            ((Player)e).playerConfig.config = packetPlayerConfig.config;
        }
    }

    @Override
    public void handlePickupSpawn(PacketAddItemEntity addItemEntityPacket) {
        double x = (double)addItemEntityPacket.xPosition / 32.0;
        double y = (double)addItemEntityPacket.yPosition / 32.0;
        double z = (double)addItemEntityPacket.zPosition / 32.0;
        EntityItem entityItem = new EntityItem(this.worldClientMP, x, y, z, new ItemStack(addItemEntityPacket.itemID, addItemEntityPacket.count, addItemEntityPacket.itemDamage, addItemEntityPacket.tag));
        entityItem.xd = (double)addItemEntityPacket.xd / 128.0;
        entityItem.yd = (double)addItemEntityPacket.yd / 128.0;
        entityItem.zd = (double)addItemEntityPacket.zd / 128.0;
        entityItem.serverPosX = addItemEntityPacket.xPosition;
        entityItem.serverPosY = addItemEntityPacket.yPosition;
        entityItem.serverPosZ = addItemEntityPacket.zPosition;
        this.worldClientMP.addEntityToWorld(addItemEntityPacket.entityId, entityItem);
    }

    @Override
    public void handleVehicleSpawn(PacketAddEntity addEntityPacket) {
        if (!NetEntityHandler.hasType(addEntityPacket.type)) {
            return;
        }
        double xPosition = (double)addEntityPacket.xPosition / 32.0;
        double yPosition = (double)addEntityPacket.yPosition / 32.0;
        double zPosition = (double)addEntityPacket.zPosition / 32.0;
        Entity owner = addEntityPacket.ownerId >= 0 ? this.getEntityByID(addEntityPacket.ownerId) : null;
        Entity newEntity = NetEntityHandler.getTypeEntry(addEntityPacket.type).getEntity(this.worldClientMP, xPosition, yPosition, zPosition, addEntityPacket.metaData, addEntityPacket.hasVelocity, (double)addEntityPacket.xVelocity / 8000.0, (double)addEntityPacket.yVelocity / 8000.0, (double)addEntityPacket.zVelocity / 8000.0, owner, addEntityPacket.tag);
        if (newEntity != null) {
            List<SynchedEntityData.DataItem<?>> list;
            newEntity.serverPosX = addEntityPacket.xPosition;
            newEntity.serverPosY = addEntityPacket.yPosition;
            newEntity.serverPosZ = addEntityPacket.zPosition;
            newEntity.yRot = addEntityPacket.yaw;
            newEntity.xRot = addEntityPacket.pitch;
            newEntity.id = addEntityPacket.entityId;
            this.worldClientMP.addEntityToWorld(addEntityPacket.entityId, newEntity);
            if (owner instanceof Mob && newEntity instanceof Projectile) {
                ((Projectile)newEntity).owner = (Mob)owner;
            }
            if (addEntityPacket.hasVelocity) {
                newEntity.lerpMotion((double)addEntityPacket.xVelocity / 8000.0, (double)addEntityPacket.yVelocity / 8000.0, (double)addEntityPacket.zVelocity / 8000.0);
            }
            if ((list = addEntityPacket.getUnpackedData()) != null) {
                newEntity.getEntityData().assignValues(list);
            }
        }
    }

    @Override
    public void handleWeather(PacketWeatherEffect weatherEffectPacket) {
        double x = (double)weatherEffectPacket.x / 32.0;
        double y = (double)weatherEffectPacket.y / 32.0;
        double z = (double)weatherEffectPacket.z / 32.0;
        EntityLightning weatherEntity = null;
        if (weatherEffectPacket.effectId == 1) {
            weatherEntity = new EntityLightning(this.worldClientMP, x, y, z);
        }
        if (weatherEntity != null) {
            weatherEntity.serverPosX = weatherEffectPacket.x;
            weatherEntity.serverPosY = weatherEffectPacket.y;
            weatherEntity.serverPosZ = weatherEffectPacket.z;
            weatherEntity.yRot = 0.0f;
            weatherEntity.xRot = 0.0f;
            weatherEntity.id = weatherEffectPacket.id;
            this.worldClientMP.addWeatherEffect(weatherEntity);
        }
    }

    @Override
    public void handleWeatherStatus(PacketWeatherStatus packet) {
        if (this.worldClientMP.dimension.id != packet.dimId) {
            return;
        }
        Weather currentWeather = packet.id == -1 ? null : Weathers.WEATHERS[packet.id];
        Weather newWeather = packet.newId == -1 ? null : Weathers.WEATHERS[packet.newId];
        this.worldClientMP.weatherManager.overrideWeather(currentWeather, newWeather, packet.duration, packet.intensity, packet.power);
    }

    @Override
    public void handleEntityPainting(PacketAddPainting addPaintingPacket) {
        Entity entity = this.worldClientMP.getEntityFromId(addPaintingPacket.entityId);
        if (entity instanceof EntityPainting) {
            EntityPainting painting = (EntityPainting)entity;
            painting.blockX = addPaintingPacket.xPosition;
            painting.blockY = addPaintingPacket.yPosition;
            painting.blockZ = addPaintingPacket.zPosition;
            if (ArtType.map.containsKey(addPaintingPacket.key)) {
                painting.art = ArtType.map.get(addPaintingPacket.key);
            }
            painting.setDirection(addPaintingPacket.direction);
            if (addPaintingPacket.itemID > 0) {
                painting.setStack(new ItemStack(addPaintingPacket.itemID, 1, addPaintingPacket.meta));
            }
        } else {
            EntityPainting entitypainting = new EntityPainting(this.worldClientMP, addPaintingPacket.xPosition, addPaintingPacket.yPosition, addPaintingPacket.zPosition, addPaintingPacket.direction, addPaintingPacket.key);
            this.worldClientMP.addEntityToWorld(addPaintingPacket.entityId, entitypainting);
            if (addPaintingPacket.itemID > 0) {
                entitypainting.setStack(new ItemStack(addPaintingPacket.itemID, 1, addPaintingPacket.meta));
            }
        }
    }

    @Override
    public void handleEntityVelocity(PacketSetEntityMotion setEntityMotionPacket) {
        Entity entity = this.getEntityByID(setEntityMotionPacket.entityId);
        if (entity != null) {
            entity.lerpMotion((double)setEntityMotionPacket.motionX / 8000.0, (double)setEntityMotionPacket.motionY / 8000.0, (double)setEntityMotionPacket.motionZ / 8000.0);
        }
    }

    @Override
    public void handleEntityMetadata(PacketSetEntityData setEntityDataPacket) {
        Entity entity = this.getEntityByID(setEntityDataPacket.entityId);
        if (entity != null && setEntityDataPacket.getUnpackedData() != null) {
            entity.getEntityData().assignValues(setEntityDataPacket.getUnpackedData());
        }
    }

    @Override
    public void handleNamedEntitySpawn(PacketAddPlayer addPlayerPacket) {
        double d = (double)addPlayerPacket.xPosition / 32.0;
        double d1 = (double)addPlayerPacket.yPosition / 32.0;
        double d2 = (double)addPlayerPacket.zPosition / 32.0;
        float f = (float)(addPlayerPacket.rotation * 360) / 256.0f;
        float f1 = (float)(addPlayerPacket.pitch * 360) / 256.0f;
        PlayerRemote playerRemote = new PlayerRemote(this.mc.currentWorld, addPlayerPacket.name, addPlayerPacket.uuid);
        playerRemote.playerConfig.config = addPlayerPacket.playerConfig;
        playerRemote.serverPosX = addPlayerPacket.xPosition;
        playerRemote.xo = playerRemote.serverPosX;
        playerRemote.serverPosY = addPlayerPacket.yPosition;
        playerRemote.yo = playerRemote.serverPosY;
        playerRemote.serverPosZ = addPlayerPacket.zPosition;
        playerRemote.zo = playerRemote.serverPosZ;
        int i = addPlayerPacket.currentItem;
        playerRemote.inventory.mainInventory[playerRemote.inventory.getCurrentItemIndex()] = i == 0 ? null : new ItemStack(i, 1, 0);
        playerRemote.absMoveTo(d, d1, d2, f, f1);
        this.worldClientMP.addEntityToWorld(addPlayerPacket.entityId, playerRemote);
        playerRemote.nickname = StringUtils.substring(addPlayerPacket.nickname, 0, 32);
        playerRemote.chatColor = addPlayerPacket.chatColor;
        playerRemote.setHeldObject(addPlayerPacket.heldObjectTag == null ? null : ICarriable.createAndLoadCarriable(playerRemote, addPlayerPacket.heldObjectTag));
    }

    @Override
    public void handleEntityTeleport(PacketTeleportEntity teleportEntityPacket) {
        Entity entity = this.getEntityByID(teleportEntityPacket.id);
        if (entity != null) {
            entity.serverPosX = teleportEntityPacket.x;
            entity.serverPosY = teleportEntityPacket.y;
            entity.serverPosZ = teleportEntityPacket.z;
            double d = (double)entity.serverPosX / 32.0;
            double d1 = (double)entity.serverPosY / 32.0 + 0.015625;
            double d2 = (double)entity.serverPosZ / 32.0;
            float f = (float)(teleportEntityPacket.yaw * 360) / 256.0f;
            float f1 = (float)(teleportEntityPacket.pitch * 360) / 256.0f;
            entity.lerpTo(d, d1, d2, f, f1, 3);
        }
    }

    @Override
    public void handleEntity(PacketMoveEntity moveEntityPacket) {
        Entity entity = this.getEntityByID(moveEntityPacket.id);
        if (entity != null) {
            entity.serverPosX += moveEntityPacket.x;
            entity.serverPosY += moveEntityPacket.y;
            entity.serverPosZ += moveEntityPacket.z;
            double d = (double)entity.serverPosX / 32.0;
            double d1 = (double)entity.serverPosY / 32.0;
            double d2 = (double)entity.serverPosZ / 32.0;
            float f = moveEntityPacket.rotating ? (float)(moveEntityPacket.yaw * 360) / 256.0f : entity.yRot;
            float f1 = moveEntityPacket.rotating ? (float)(moveEntityPacket.pitch * 360) / 256.0f : entity.xRot;
            entity.lerpTo(d, d1, d2, f, f1, 3);
        }
    }

    @Override
    public void handleEntityTagData(PacketEntityTagData entityTagDataPacket) {
        Entity entity = this.getEntityByID(entityTagDataPacket.entityId);
        if (entity != null) {
            entity.readAdditionalSaveData(entityTagDataPacket.tag);
        }
    }

    @Override
    public void handleSetMobSpawner(PacketSetMobSpawner setMobSpawnerPacket) {
        TileEntity tileentity;
        if (this.mc.currentWorld.isBlockLoaded(setMobSpawnerPacket.xPosition, setMobSpawnerPacket.yPosition, setMobSpawnerPacket.zPosition) && (tileentity = this.mc.currentWorld.getTileEntity(setMobSpawnerPacket.xPosition, setMobSpawnerPacket.yPosition, setMobSpawnerPacket.zPosition)) instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)tileentity;
            NamespaceID namespaceID = EntityDispatcher.idForClass(setMobSpawnerPacket.entityClass);
            tileEntityMobSpawner.setMobId(namespaceID == null ? "none" : namespaceID.toString());
            tileEntityMobSpawner.setChanged();
        }
    }

    @Override
    public void handleSetHotbarOffset(PacketSetHotbarOffset setHotbarOffsetPacket) {
        this.mc.thePlayer.inventory.setHotbarOffset(setHotbarOffsetPacket.hotbarOffset, true);
    }

    @Override
    public void handleDestroyEntity(PacketRemoveEntity removeEntityPacket) {
        this.worldClientMP.removeEntityFromWorld(removeEntityPacket.entityId);
    }

    @Override
    public void handleFlying(PacketMovePlayer movePlayerPacket) {
        PlayerLocal entityplayersp = this.mc.thePlayer;
        double d = entityplayersp.x;
        double d1 = entityplayersp.y;
        double d2 = entityplayersp.z;
        float f = entityplayersp.yRot;
        float f1 = entityplayersp.xRot;
        if (movePlayerPacket.hasPosition) {
            d = movePlayerPacket.x;
            d1 = movePlayerPacket.y;
            d2 = movePlayerPacket.z;
        }
        if (movePlayerPacket.hasRotation) {
            f = movePlayerPacket.yaw;
            f1 = movePlayerPacket.pitch;
        }
        entityplayersp.ySlideOffset = 0.0f;
        entityplayersp.zd = 0.0;
        entityplayersp.yd = 0.0;
        entityplayersp.xd = 0.0;
        entityplayersp.absMoveTo(d, d1, d2, f, f1);
        movePlayerPacket.x = entityplayersp.x;
        movePlayerPacket.y = entityplayersp.bb.minY;
        movePlayerPacket.z = entityplayersp.z;
        this.netManager.addToSendQueue(movePlayerPacket);
        if (!this.started) {
            this.mc.thePlayer.xo = this.mc.thePlayer.x;
            this.mc.thePlayer.yo = this.mc.thePlayer.y;
            this.mc.thePlayer.zo = this.mc.thePlayer.z;
            this.started = true;
            this.mc.displayScreen(null);
        }
    }

    @Override
    public void handlePreChunk(PacketChunkVisibility chunkVisibilityPacket) {
        this.worldClientMP.doPreChunk(chunkVisibilityPacket.chunkX, chunkVisibilityPacket.chunkZ, chunkVisibilityPacket.playerAdded);
    }

    @Override
    public void handleMultiBlockChange(PacketChunkBlocksUpdate chunkBlocksUpdatePacket) {
        int xBase = chunkBlocksUpdatePacket.xChunk * 16;
        int zBase = chunkBlocksUpdatePacket.zChunk * 16;
        for (int k = 0; k < chunkBlocksUpdatePacket.size; ++k) {
            int coord = chunkBlocksUpdatePacket.coordinateArray[k];
            int type = chunkBlocksUpdatePacket.typeArray[k] & 0x3FFF;
            byte data = chunkBlocksUpdatePacket.metadataArray[k];
            int x = coord >> 0 & 0xF;
            int y = coord >> 8 & 0xFF;
            int z = coord >> 4 & 0xF;
            this.worldClientMP.setBlockAndMetadataWithNotify(x + xBase, y, z + zBase, type, data);
            this.worldClientMP.removePositionTypesInBounds(x + xBase, y, z + zBase, x + xBase, y, z + zBase);
            this.worldClientMP.markBlocksDirty(x + xBase, y, z + zBase, x + xBase, y, z + zBase);
        }
    }

    @Override
    public void handleMapChunk(PacketBlockRegionUpdate blockRegionUpdatePacket) {
        for (int x = blockRegionUpdatePacket.xPosition / 16; x <= blockRegionUpdatePacket.xPosition / 16 + blockRegionUpdatePacket.xSize / 16; ++x) {
            for (int z = blockRegionUpdatePacket.zPosition / 16; z <= blockRegionUpdatePacket.zPosition / 16 + blockRegionUpdatePacket.zSize / 16; ++z) {
                this.worldClientMP.doPreChunk(x, z, true);
            }
        }
        this.worldClientMP.removePositionTypesInBounds(blockRegionUpdatePacket.xPosition, blockRegionUpdatePacket.yPosition, blockRegionUpdatePacket.zPosition, blockRegionUpdatePacket.xPosition + blockRegionUpdatePacket.xSize - 1, blockRegionUpdatePacket.yPosition + blockRegionUpdatePacket.ySize - 1, blockRegionUpdatePacket.zPosition + blockRegionUpdatePacket.zSize - 1);
        this.worldClientMP.setChunkData(blockRegionUpdatePacket.xPosition, blockRegionUpdatePacket.yPosition, blockRegionUpdatePacket.zPosition, blockRegionUpdatePacket.xSize, blockRegionUpdatePacket.ySize, blockRegionUpdatePacket.zSize, blockRegionUpdatePacket.chunk);
    }

    @Override
    public void handleBlockUpdate(PacketBlockUpdate blockUpdatePacket) {
        this.worldClientMP.blockChange(blockUpdatePacket.xPosition, blockUpdatePacket.yPosition, blockUpdatePacket.zPosition, blockUpdatePacket.blockId, blockUpdatePacket.metadata);
    }

    @Override
    public void handleKickDisconnect(PacketDisconnect packet255KickdisconnectPacket) {
        this.netManager.networkShutdown("disconnect.kicked", new Object[0]);
        this.disconnected = true;
        this.mc.changeWorld(null);
        this.mc.displayScreen(new ScreenConnectFailed("disconnect.disconnected", "disconnect.genericReason", new Object[]{packet255KickdisconnectPacket.reason}));
    }

    @Override
    public void handleErrorMessage(String message, Object[] objects) {
        if (!this.disconnected) {
            this.disconnected = true;
            try {
                this.mc.changeWorld(null);
            }
            catch (Exception e) {
                LOGGER.error("Exception when leaving world!", e);
            }
            try {
                this.mc.displayScreen(null);
            }
            catch (Exception e) {
                LOGGER.error("Exception when leaving GUI!", e);
            }
            this.mc.displayScreen(new ScreenConnectFailed("disconnect.lost", message, objects));
        }
    }

    public void sendFinalPacket(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
            this.netManager.serverShutdown();
        }
    }

    public void addToSendQueue(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
        }
    }

    @Override
    public void handleCollect(PacketTakeItemEntity takeItemEntityPacket) {
        Entity item = this.getEntityByID(takeItemEntityPacket.collectedEntityId);
        Entity collector = this.getEntityByID(takeItemEntityPacket.collectorEntityId);
        if (collector == null) {
            collector = this.mc.thePlayer;
        }
        if (item != null) {
            this.worldClientMP.playSoundAtEntity(null, item, "item.pickup", 1.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 4.0f);
            this.mc.particleEngine.add(new ParticlePickupAnimation(this.mc.currentWorld, item, collector, -0.5f));
            this.worldClientMP.removeEntityFromWorld(takeItemEntityPacket.collectedEntityId);
        }
    }

    @Override
    public void handleChat(PacketChat packet) {
        String message;
        if (packet.encrypted) {
            try {
                message = AES.decrypt(packet.message, AES.clientKeyChain);
            }
            catch (Exception e) {
                throw new RuntimeException("This crash is caused by outdated Java, please update to 8u161 or newer! If your Java version is out of date due to a technical requirement, please add the JCE Unlimited Strength Jurisdiction Policy Files to your installation. https://www.oracle.com/java/technologies/javase-jce-all-downloads.html", e);
            }
        } else {
            message = packet.message;
        }
        int type = packet.type;
        if (type == 1) {
            this.mc.hudIngame.heldItemTooltipElement.setString(message);
        } else {
            this.mc.hudIngame.addChatMessage(message);
        }
    }

    public void handlePlayerJoin(PacketChat chatPacket) {
        this.mc.hudIngame.addChatMessage(chatPacket.message);
    }

    public void handlePlayerLeave(PacketChat chatPacket) {
        this.mc.hudIngame.addChatMessage(chatPacket.message);
    }

    @Override
    public void handleAnimation(PacketAnimate animatePacket) {
        Entity entity = this.getEntityByID(animatePacket.entityId);
        if (entity == null) {
            return;
        }
        if (animatePacket.animate == 1) {
            Player entityplayer = (Player)entity;
            entityplayer.swingItem();
        } else if (animatePacket.animate == 2) {
            entity.animateHurt();
        } else if (animatePacket.animate == 3) {
            Player player = (Player)entity;
            player.wakeUpPlayer(false, false);
        } else if (animatePacket.animate == 4) {
            Player player = (Player)entity;
            player.animate4();
        }
    }

    @Override
    public void handleBoatControl(PacketBoatControl boatControlPacket) {
        Entity e = this.worldClientMP.getEntityFromId(boatControlPacket.entityId);
        if (e instanceof EntityBoat) {
            ((EntityBoat)e).handleControlDirect(boatControlPacket.targetXD, boatControlPacket.targetZD, boatControlPacket.targetYRot);
        }
    }

    @Override
    public void handleSleep(PacketSleep sleepPacket) {
        Entity entity = this.getEntityByID(sleepPacket.entityID);
        if (entity == null) {
            return;
        }
        if (sleepPacket.field_22046_e == 0) {
            Player entityplayer = (Player)entity;
            entityplayer.sleepInBedAt(sleepPacket.x, sleepPacket.y, sleepPacket.z);
        }
    }

    @Override
    public void handleHandshake(PacketPreLogin preLoginPacket) {
        block8: {
            if (preLoginPacket.username.equals("-")) {
                try {
                    RSA.RSAKeyChain = RSA.generateKeyPair();
                    this.addToSendQueue(new PacketLogin(this.mc.session.username, this.mc.session.uuid, 29728, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                URL url = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.session.username + "&sessionId=" + this.mc.session.sessionId + "&serverId=" + preLoginPacket.username);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s = bufferedreader.readLine();
                bufferedreader.close();
                if (s.equalsIgnoreCase("ok")) {
                    try {
                        RSA.RSAKeyChain = RSA.generateKeyPair();
                        this.addToSendQueue(new PacketLogin(this.mc.session.username, this.mc.session.uuid, 29728, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                        break block8;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Exception while creating LoginPacket!", e);
                    }
                }
                this.netManager.networkShutdown("disconnect.loginFailedInfo", new Object[]{s});
            }
            catch (Exception exception) {
                LOGGER.error("Login Exception!", exception);
                this.netManager.networkShutdown("disconnect.genericReason", new Object[]{"Internal client error: " + exception});
            }
        }
    }

    @Override
    public void handleSendKey(PacketAESSendKey AESSendKeyPacket) {
        try {
            AES.clientKeyChain = AES.getKey(RSA.decrypt(AESSendKeyPacket.KEY, RSA.RSAKeyChain.getPrivate()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get AES key!", e);
        }
    }

    @Override
    public void handlePlayerList(PacketPlayerList playerListPacket) {
        this.playerList.clear();
        String[] players = playerListPacket.players;
        String[] scores = playerListPacket.scores;
        for (int i = 0; i < players.length; ++i) {
            this.playerList.put(players[i], scores[i]);
        }
    }

    public void disconnect() {
        this.disconnected = true;
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("disconnect.closed", new Object[0]);
    }

    @Override
    public void handleMobSpawn(PacketAddMob addMobPacket) {
        double d = (double)addMobPacket.x / 32.0;
        double d1 = (double)addMobPacket.y / 32.0;
        double d2 = (double)addMobPacket.z / 32.0;
        float f = (float)(addMobPacket.yaw * 360) / 256.0f;
        float f1 = (float)(addMobPacket.pitch * 360) / 256.0f;
        Mob mob = (Mob)EntityDispatcher.createEntity(addMobPacket.type, this.mc.currentWorld);
        mob.serverPosX = addMobPacket.x;
        mob.serverPosY = addMobPacket.y;
        mob.serverPosZ = addMobPacket.z;
        mob.id = addMobPacket.id;
        mob.absMoveTo(d, d1, d2, f, f1);
        mob.isMultiplayerEntity = true;
        this.worldClientMP.addEntityToWorld(addMobPacket.id, mob);
        List<SynchedEntityData.DataItem<?>> list = addMobPacket.getUnpackedData();
        if (list != null) {
            mob.getEntityData().assignValues(list);
        }
        mob.nickname = StringUtils.substring(addMobPacket.nickname, 0, 32);
        mob.chatColor = addMobPacket.chatColor;
    }

    @Override
    public void handleUpdateTime(PacketSetTime setTimePacket) {
        this.mc.currentWorld.setWorldTime(setTimePacket.time);
    }

    @Override
    public void handleSpawnPosition(PacketSetSpawnPosition setSpawnPositionPacket) {
        this.mc.thePlayer.setPlayerSpawnCoordinate(new ChunkCoordinates(setSpawnPositionPacket.x, setSpawnPositionPacket.y, setSpawnPositionPacket.z));
        this.mc.currentWorld.getLevelData().setSpawn(setSpawnPositionPacket.x, setSpawnPositionPacket.y, setSpawnPositionPacket.z);
    }

    @Override
    public void handleAttachEntity(PacketSetRiding setRidingPacket) {
        Entity passenger = this.getEntityByID(setRidingPacket.passengerId);
        if (setRidingPacket.passengerId == this.mc.thePlayer.id) {
            passenger = this.mc.thePlayer;
        }
        IVehicle vehicle = setRidingPacket.isTileEntity ? (IVehicle)((Object)this.worldClientMP.getTileEntity(setRidingPacket.x, setRidingPacket.y, setRidingPacket.z)) : this.getEntityByID(setRidingPacket.vehicleId);
        if (passenger != null && vehicle != null) {
            passenger.startRiding(vehicle);
        }
    }

    @Override
    public void handleEntityStatus(PacketEntityEvent enitityEventPacket) {
        Entity entity = this.getEntityByID(enitityEventPacket.entityId);
        if (entity != null) {
            entity.handleEntityEvent(enitityEventPacket.entityStatus, enitityEventPacket.attackedAtYaw);
        }
    }

    protected Entity getEntityByID(int i) {
        if (i == this.mc.thePlayer.id) {
            return this.mc.thePlayer;
        }
        return this.worldClientMP.getEntityFromId(i);
    }

    @Override
    public void handleUpdateHealth(PacketSetHealth setHealthPacket) {
        this.mc.thePlayer.setHealth(setHealthPacket.healthMP);
    }

    @Override
    public void handleUpdatePlayerProfile(PacketUpdatePlayerProfile profilePacket) {
        int index;
        PlayerProfile playerProfile = new PlayerProfile(profilePacket.username, profilePacket.nickname, profilePacket.uuid, profilePacket.score, profilePacket.chatColor, profilePacket.isOperator);
        if (playerProfile.uuid.equals(this.mc.thePlayer.uuid)) {
            this.mc.thePlayer.score = playerProfile.scoreTotal;
        }
        if ((index = this.findPlayerInList(playerProfile)) != -1) {
            if (!profilePacket.isOnline) {
                this.removePlayer(index);
            } else {
                this.players.set(index, playerProfile);
            }
        } else {
            this.addPlayer(playerProfile);
        }
    }

    @Override
    public void handleRespawn(PacketRespawn respawnPacket) {
        if (respawnPacket.respawnDimensionId != this.mc.thePlayer.dimension) {
            this.started = false;
            this.worldClientMP = new WorldClientMP(this, this.worldClientMP.getLevelData().getRandomSeed(), respawnPacket.respawnDimensionId, respawnPacket.respawnWorldTypeId);
            this.worldClientMP.isClientSide = true;
            this.mc.changeWorld(this.worldClientMP);
            this.mc.thePlayer.dimension = respawnPacket.respawnDimensionId;
            this.mc.displayScreen(new ScreenDownloadTerrain(this));
        }
        this.mc.respawn(true, respawnPacket.respawnDimensionId);
    }

    @Override
    public void handleExplosion(PacketExplosion explosionPacket) {
        Explosion explosion = explosionPacket.isCannonball ? new ExplosionCannonball(this.mc.currentWorld, null, explosionPacket.explosionX, explosionPacket.explosionY, explosionPacket.explosionZ, explosionPacket.explosionSize) : new Explosion(this.mc.currentWorld, null, explosionPacket.explosionX, explosionPacket.explosionY, explosionPacket.explosionZ, explosionPacket.explosionSize);
        explosion.destroyedBlockPositions = explosionPacket.destroyedBlockPositions;
        explosion.addEffects(true);
    }

    @Override
    public void handleOpenWindow(PacketContainerOpen containerOpenPacket) {
        switch (containerOpenPacket.inventoryType) {
            case 0: {
                ContainerSimple simpleContainer = new ContainerSimple(containerOpenPacket.windowTitle, containerOpenPacket.slotsCount);
                this.mc.thePlayer.displayContainerScreen(simpleContainer);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 2: {
                TileEntityFurnace tileEntityFurnace = new TileEntityFurnace();
                this.mc.thePlayer.displayFurnaceScreen(tileEntityFurnace);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 3: {
                TileEntityDispenser tileEntityDispenser = new TileEntityDispenser();
                this.mc.thePlayer.displayDispenserScreen(tileEntityDispenser);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 6: {
                TileEntityActivator tileEntityActivator = new TileEntityActivator();
                this.mc.thePlayer.displayActivatorScreen(tileEntityActivator);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 4: {
                TileEntityFurnaceBlast tileEntityFurnaceBlast = new TileEntityFurnaceBlast();
                this.mc.thePlayer.displayFurnaceScreen(tileEntityFurnaceBlast);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 5: {
                TileEntityTrommel tileEntityTrommel = new TileEntityTrommel();
                this.mc.thePlayer.displayTrommelScreen(tileEntityTrommel);
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            case 7: {
                this.mc.thePlayer.displayPaintingPickerScreen();
                break;
            }
            case 1: {
                PlayerLocal playerLocal = this.mc.thePlayer;
                this.mc.thePlayer.displayWorkbenchScreen(MathHelper.floor(playerLocal.x), MathHelper.floor(playerLocal.y), MathHelper.floor(playerLocal.z));
                this.mc.thePlayer.craftingInventory.containerId = containerOpenPacket.windowId;
                break;
            }
            default: {
                LOGGER.warn("No defined before for container open '{}' with type {}!", (Object)containerOpenPacket.windowId, (Object)containerOpenPacket.inventoryType);
            }
        }
    }

    @Override
    public void handleOpenFlagWindow(PacketFlagOpen flagOpenPacket) {
        TileEntity tileEntity = this.worldClientMP.getTileEntity(flagOpenPacket.x, flagOpenPacket.y, flagOpenPacket.z);
        if (tileEntity instanceof TileEntityFlag) {
            TileEntityFlag tileEntityFlag = (TileEntityFlag)tileEntity;
            this.mc.thePlayer.displayFlagEditorScreen(tileEntityFlag);
            this.mc.thePlayer.craftingInventory.containerId = flagOpenPacket.windowId;
        }
    }

    @Override
    public void handlePhotoMode(PacketPhotoMode photoModePacket) {
        ScreenPause.photoModeDisabled = photoModePacket.disabled;
    }

    @Override
    public void handleSetSlot(PacketContainerSetSlot containerSetslotPacket) {
        if (containerSetslotPacket.windowId == -1) {
            this.mc.thePlayer.inventory.setHeldItemStack(containerSetslotPacket.myItemStack);
        } else if (containerSetslotPacket.windowId == 0 && containerSetslotPacket.itemSlot >= 36 && containerSetslotPacket.itemSlot < 45) {
            ItemStack itemstack = this.mc.thePlayer.inventorySlots.getSlot(containerSetslotPacket.itemSlot).getItemStack();
            if (containerSetslotPacket.myItemStack != null && (itemstack == null || itemstack.stackSize < containerSetslotPacket.myItemStack.stackSize)) {
                containerSetslotPacket.myItemStack.animationsToGo = 5;
            }
            this.mc.thePlayer.inventorySlots.setItem(containerSetslotPacket.itemSlot, containerSetslotPacket.myItemStack);
        } else if (containerSetslotPacket.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            this.mc.thePlayer.craftingInventory.setItem(containerSetslotPacket.itemSlot, containerSetslotPacket.myItemStack);
        }
    }

    @Override
    public void handleTransaction(PacketContainerAck containerAckPacket) {
        MenuAbstract container = null;
        if (containerAckPacket.windowId == 0) {
            container = this.mc.thePlayer.inventorySlots;
        } else if (containerAckPacket.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            container = this.mc.thePlayer.craftingInventory;
        }
        if (container != null) {
            if (containerAckPacket.accepted) {
                container.deleteBackup(containerAckPacket.shortWindowId);
            } else {
                container.rollbackToBackup(containerAckPacket.shortWindowId);
                this.addToSendQueue(new PacketContainerAck(containerAckPacket.windowId, containerAckPacket.shortWindowId, true));
            }
        }
    }

    @Override
    public void handleWindowItems(PacketContainerSetContent containerSetContentPacket) {
        if (containerSetContentPacket.windowId == 0) {
            this.mc.thePlayer.inventorySlots.setAll(containerSetContentPacket.stackList);
        } else if (containerSetContentPacket.windowId == this.mc.thePlayer.craftingInventory.containerId) {
            this.mc.thePlayer.craftingInventory.setAll(containerSetContentPacket.stackList);
        }
    }

    @Override
    public void handleUpdateProgressbar(PacketContainerSetData containerSetDataPacket) {
        this.handleInvalidPacket(containerSetDataPacket);
        if (this.mc.thePlayer.craftingInventory != null && this.mc.thePlayer.craftingInventory.containerId == containerSetDataPacket.windowId) {
            this.mc.thePlayer.craftingInventory.setData(containerSetDataPacket.progressBar, containerSetDataPacket.progressBarValue);
        }
    }

    @Override
    public void handlePlayerInventory(PacketSetEquippedItem setEquippedItemPacket) {
        Entity entity = this.getEntityByID(setEquippedItemPacket.entityID);
        if (entity != null) {
            entity.setEquippedSlot(setEquippedItemPacket.slot, setEquippedItemPacket.itemID, setEquippedItemPacket.itemMeta, setEquippedItemPacket.itemData);
        }
    }

    @Override
    public void handlePlayerHeldObject(PacketSetHeldObject setHeldObjectPacket) {
        Entity entity = this.getEntityByID(setHeldObjectPacket.entityID);
        if (entity != null) {
            entity.setHeldObject(setHeldObjectPacket.objectTag == null ? null : ICarriable.createAndLoadCarriable(entity, setHeldObjectPacket.objectTag));
        }
    }

    @Override
    public void handleCloseWindow(PacketContainerClose containerClosePacket) {
        this.mc.thePlayer.closeScreen();
    }

    @Override
    public void handleBlockEvent(PacketBlockEvent blockEventPacket) {
        this.mc.currentWorld.triggerEvent(blockEventPacket.xLocation, blockEventPacket.yLocation, blockEventPacket.zLocation, blockEventPacket.index, blockEventPacket.data);
    }

    @Override
    public void handleBed(PacketBedMessage bedMessagePacket) {
        int state = bedMessagePacket.bedState;
        if (state >= 0 && state < PacketBedMessage.BED_MESSAGE_KEYS.length && PacketBedMessage.BED_MESSAGE_KEYS[state] != null) {
            this.mc.thePlayer.sendTranslatedChatMessage(PacketBedMessage.BED_MESSAGE_KEYS[state]);
        }
    }

    @Override
    public void handleMapData(PacketMapData mapdataPacket) {
        if (mapdataPacket.itemId == Items.MAP.id) {
            ItemMap.getOrCreateSavedData(mapdataPacket.meta, mapdataPacket.scale, this.mc.currentWorld).setColors(mapdataPacket.mapData);
        } else {
            LOGGER.warn("Unexpected itemId: {}", (Object)mapdataPacket.itemId);
        }
    }

    @Override
    public void handlePlaySoundEffect(PacketPlaySoundEffect playSoundEffectPacket) {
        this.mc.currentWorld.playBlockEvent(playSoundEffectPacket.soundID, playSoundEffectPacket.x, playSoundEffectPacket.y, playSoundEffectPacket.z, playSoundEffectPacket.data);
    }

    @Override
    public void handlePlaySoundDirectly(PacketPlaySoundEffectDirect packet) {
        String soundPath = SoundTypes.getSoundById(packet.soundId);
        if (soundPath == null) {
            return;
        }
        this.mc.sndManager.playSoundAt(soundPath, packet.soundType, (float)packet.x, (float)packet.y, (float)packet.z, packet.volume, packet.pitch);
    }

    @Override
    public void handleSpawnParticle(PacketAddParticle addParticlePacket) {
        if (addParticlePacket.isGroup) {
            for (int i = 0; i < addParticlePacket.amount; ++i) {
                this.mc.renderGlobal.addParticle(addParticlePacket.particleKey, addParticlePacket.x + this.rand.nextDouble() * (double)addParticlePacket.randOffX, addParticlePacket.y + this.rand.nextDouble() * (double)addParticlePacket.randOffY, addParticlePacket.z + this.rand.nextDouble() * (double)addParticlePacket.randOffZ, addParticlePacket.motionX + this.rand.nextGaussian() * (double)addParticlePacket.randMotionX, addParticlePacket.motionY + this.rand.nextGaussian() * (double)addParticlePacket.randMotionY, addParticlePacket.motionZ + this.rand.nextGaussian() * (double)addParticlePacket.randMotionZ, addParticlePacket.data, addParticlePacket.maxDistance);
            }
        } else {
            this.mc.renderGlobal.addParticle(addParticlePacket.particleKey, addParticlePacket.x, addParticlePacket.y, addParticlePacket.z, addParticlePacket.motionX, addParticlePacket.motionY, addParticlePacket.motionZ, addParticlePacket.data, addParticlePacket.maxDistance);
        }
    }

    @Override
    public void handleStatistic(PacketStatistic statisticPacket) {
        Stat stat = StatList.getStat(statisticPacket.statID);
        if (stat != null && stat.clientside) {
            return;
        }
        this.mc.thePlayer.addStat(StatList.getStat(statisticPacket.statID), statisticPacket.valueChange);
    }

    @Override
    public void handleEntityPlayerGamemode(PacketPlayerGamemode packet) {
        Entity entity = this.getEntityByID(packet.entityId);
        if (entity instanceof Player) {
            ((Player)entity).setGamemode(Gamemode.gamemodesList[packet.gamemodeId]);
        }
    }

    @Override
    public void handleEntityNickname(PacketEntityNickname entityNicknamePacket) {
        Entity entity = this.getEntityByID(entityNicknamePacket.entityId);
        if (entity instanceof Mob) {
            ((Mob)entity).nickname = StringUtils.substring(entityNicknamePacket.nickname, 0, 32);
            ((Mob)entity).chatColor = entityNicknamePacket.chatColor;
        }
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }

    @Override
    public void handleBlockItemSwitch(PacketSetCarriedItem setCarriedItemPacket) {
        this.mc.thePlayer.inventory.setCurrentItemIndex(setCarriedItemPacket.id, true);
    }

    @Override
    public void handleTileEntityData(PacketTileEntityData packetTileEntityData) {
        Class<? extends TileEntity> clazz = TileEntityDispatcher.getClassFromID(packetTileEntityData.tag.getString("id"));
        if (clazz == null) {
            return;
        }
        TileEntity existingTileEntity = this.worldClientMP.getTileEntity(packetTileEntityData.tag.getInteger("x"), packetTileEntityData.tag.getInteger("y"), packetTileEntityData.tag.getInteger("z"));
        if (existingTileEntity == null || existingTileEntity.getClass() != clazz) {
            TileEntity tileEntity = TileEntityDispatcher.createAndLoadEntity(packetTileEntityData.tag);
            if (tileEntity != null) {
                this.mc.currentWorld.setTileEntity(tileEntity.x, tileEntity.y, tileEntity.z, tileEntity);
            }
        } else {
            existingTileEntity.readFromNBT(packetTileEntityData.tag);
        }
        this.worldClientMP.markBlockDirty(packetTileEntityData.tag.getInteger("x"), packetTileEntityData.tag.getInteger("y"), packetTileEntityData.tag.getInteger("z"));
    }

    @Override
    public void handleGameRule(PacketGameRule packet) {
        LevelData levelData = this.mc.currentWorld.getLevelData();
        if (packet.getGameRules() != null) {
            levelData.getGameRules().setValues(packet.getGameRules());
        }
    }

    @Override
    public void handleSyncedRecipe(PacketRecipeSync recipeSyncPacket) {
        if (Registries.RECIPES.getAllSerializableRecipes().isEmpty()) {
            LOGGER.info("Receiving {} recipes from server..", (Object)recipeSyncPacket.maxRecipes);
        }
        DataLoader.loadRecipeFromServer(recipeSyncPacket);
        if ((long)Registries.RECIPES.getAllSerializableRecipes().size() == recipeSyncPacket.maxRecipes) {
            LOGGER.info("All recipes received!");
            Registries.RECIPES.invalidateCaches();
            GuidebookPageSearch.searchField.setText("_");
            GuidebookPageManager.searchQuery = SearchQuery.resolve(GuidebookPageSearch.searchField.getText());
            ScreenGuidebook.getPageManager().updatePages();
            GuidebookPageSearch.searchField.setText("");
            GuidebookPageManager.searchQuery = SearchQuery.resolve(GuidebookPageSearch.searchField.getText());
            ScreenGuidebook.getPageManager().updatePages();
        }
    }

    @Override
    public void handleIds(PacketSyncIDs syncIDsPacket) {
        if (syncIDsPacket.destinationId == 0) {
            SoundTypes.setSoundIds(syncIDsPacket.mapping);
        } else if (syncIDsPacket.destinationId == 1) {
            EntityDispatcher.setNumericIds(syncIDsPacket.mapping);
        }
    }

    @Override
    public void handleCustomPayload(PacketCustomPayload customPayloadPacket) {
        if ("BTA|RainbowStart".equals(customPayloadPacket.channel)) {
            int rainbowTicks = Byte.toUnsignedInt(customPayloadPacket.data[0]) << 24 | Byte.toUnsignedInt(customPayloadPacket.data[1]) << 16 | Byte.toUnsignedInt(customPayloadPacket.data[2]) << 8 | Byte.toUnsignedInt(customPayloadPacket.data[3]);
            this.worldClientMP.addRainbow(rainbowTicks);
        }
    }

    @Override
    public void handleCommandManagerPacket(PacketCommandManager commandManagerPacket) {
        GuiElementChatSuggestions.serverSuggestions = commandManagerPacket.suggestions;
    }
}

