/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelTransparent;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicPortal;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelPortal<T extends BlockLogicPortal>
extends BlockModelTransparent<T> {
    protected IconCoordinate[] colors = new IconCoordinate[16];

    public BlockModelPortal(Block<T> block, String rootTexKey) {
        super(block, false);
        for (DyeColor color : DyeColor.values()) {
            this.colors[color.blockMeta] = TextureRegistry.getTexture(rootTexKey + color.colorID);
        }
        this.onRenderLayer(1);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, AABB bounds, int x, int y, int z, @NotNull Side side) {
        if (blockAccess.getBlockId(x, y, z) == this.block.id()) {
            return false;
        }
        return super.shouldSideBeRendered(blockAccess, bounds, x, y, z, side);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return this.colors[((BlockLogicPortal)this.block.getLogic()).fromMetadata((int)data).blockMeta];
    }
}

