/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererSpider
extends MobRenderer<MobSpider> {
    public MobRendererSpider(float shadowSize) {
        super(shadowSize);
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull MobSpider entity, float brightness, float partialTick, int layer) {
        if (layer == 1) {
            this.bindTexture("/assets/minecraft/textures/entity/spider/eyes/" + entity.getTextureReference() + ".png");
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(LightmapHelper.getOverbrightLightmapCoord(15));
            }
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((1.0f - entity.getBrightness(partialTick)) * 0.5f));
        } else if (layer == 2) {
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            return null;
        }
        StaticEntityModel model = this.getModel("main");
        model.resetBones();
        float bodyYaw = this.getBodyYaw(entity, partialTick);
        float headYaw = this.getHeadYaw(entity, partialTick) - bodyYaw;
        float headPitch = this.getHeadPitch(entity, partialTick);
        float limbSwing = this.getLimbSwing(entity, partialTick);
        float limbYaw = this.getLimbYaw(entity, partialTick);
        BoneTransform head = model.getTransform("head");
        BoneTransform leg0 = model.getTransform("leg0");
        BoneTransform leg1 = model.getTransform("leg1");
        BoneTransform leg2 = model.getTransform("leg2");
        BoneTransform leg3 = model.getTransform("leg3");
        BoneTransform leg4 = model.getTransform("leg4");
        BoneTransform leg5 = model.getTransform("leg5");
        BoneTransform leg6 = model.getTransform("leg6");
        BoneTransform leg7 = model.getTransform("leg7");
        head.rotX = headPitch;
        head.rotY = headYaw;
        double rZ = 45.0f * MathHelper.DEG_TO_RAD;
        leg0.rotZ = -rZ;
        leg1.rotZ = rZ;
        leg2.rotZ = -rZ * (double)0.74f;
        leg3.rotZ = rZ * (double)0.74f;
        leg4.rotZ = -rZ * (double)0.74f;
        leg5.rotZ = rZ * (double)0.74f;
        leg6.rotZ = -rZ;
        leg7.rotZ = rZ;
        double ry = 22.5 * (double)MathHelper.DEG_TO_RAD;
        leg0.rotY = ry * 2.0;
        leg1.rotY = -ry * 2.0;
        leg2.rotY = ry;
        leg3.rotY = -ry;
        leg4.rotY = -ry;
        leg5.rotY = ry;
        leg6.rotY = -ry * 2.0;
        leg7.rotY = ry * 2.0;
        double pair1Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + 0.0f) * 0.4f) * limbYaw;
        double pair2Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + (float)Math.PI) * 0.4f) * limbYaw;
        double pair3Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + 1.5707964f) * 0.4f) * limbYaw;
        double pair4Y = -(MathHelper.cos(limbSwing * 0.6662f * 2.0f + 4.712389f) * 0.4f) * limbYaw;
        double pair1Z = Math.abs(MathHelper.sin(limbSwing * 0.6662f + 0.0f) * 0.4f) * limbYaw;
        double pair2Z = Math.abs(MathHelper.sin(limbSwing * 0.6662f + (float)Math.PI) * 0.4f) * limbYaw;
        double pair3Z = Math.abs(MathHelper.sin(limbSwing * 0.6662f + 1.5707964f) * 0.4f) * limbYaw;
        double pair4Z = Math.abs(MathHelper.sin(limbSwing * 0.6662f + 4.712389f) * 0.4f) * limbYaw;
        leg0.rotY += pair1Y;
        leg1.rotY -= pair1Y;
        leg2.rotY += pair2Y;
        leg3.rotY -= pair2Y;
        leg4.rotY += pair3Y;
        leg5.rotY -= pair3Y;
        leg6.rotY += pair4Y;
        leg7.rotY -= pair4Y;
        leg0.rotZ += pair1Z;
        leg1.rotZ -= pair1Z;
        leg2.rotZ += pair2Z;
        leg3.rotZ -= pair2Z;
        leg4.rotZ += pair3Z;
        leg5.rotZ -= pair3Z;
        leg6.rotZ += pair4Z;
        leg7.rotZ -= pair4Z;
        return model;
    }

    @Override
    protected float getMaxDeathRotation(@NotNull MobSpider entity) {
        return 180.0f;
    }

    @Override
    protected int maxRenderLayer(@NotNull MobSpider entity) {
        return 2;
    }
}

