/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.DisplayPos;

public class ItemModelBlock
extends ItemModelStandard {
    private final Block<?> block;
    private final BlockModel<?> blockModel;

    public ItemModelBlock(ItemBlock<?> itemBlock) {
        super(itemBlock, null);
        this.block = itemBlock.getBlock();
        this.blockModel = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(this.block);
        this.icon = this.blockModel.getOverlayTexture(0);
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(@Nullable Entity entity, ItemStack itemStack) {
        return this.blockModel.getOverlayTexture(itemStack.getMetadata());
    }

    @Override
    @NotNull
    public DisplayPos getDisplayPos(@NotNull String id) {
        return this.blockModel.shouldItemRender3d() ? this.blockModel.getItemDisplayPos(id) : super.getDisplayPos(id);
    }

    @Override
    public void render(@NotNull Tessellator tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, @NotNull String displayPosId, boolean items3d, int clusterSize, float brightness, float alpha, float partialTick, boolean mirrorX) {
        if (!this.blockModel.shouldItemRender3d()) {
            super.render(tessellator, holder, itemStack, displayPosId, items3d, clusterSize, brightness, alpha, partialTick, mirrorX);
            return;
        }
        random.setSeed(187L);
        DisplayPos displayPos = this.getDisplayPos(displayPosId);
        GL11.glTranslatef((float)displayPos.tx, (float)displayPos.ty, (float)displayPos.tz);
        GL11.glRotatef((float)displayPos.rx, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)displayPos.ry, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)displayPos.rz, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScalef((float)displayPos.sx, (float)displayPos.sy, (float)displayPos.sz);
        int color = this.getColor(itemStack);
        float r = (float)Color.redFromInt(color) / 255.0f;
        float g = (float)Color.greenFromInt(color) / 255.0f;
        float b = (float)Color.blueFromInt(color) / 255.0f;
        GL11.glColor4f((float)(brightness * r), (float)(brightness * g), (float)(brightness * b), (float)alpha);
        for (int i = 0; i < clusterSize; ++i) {
            float rOffX = 0.0f;
            float rOffY = 0.0f;
            float rOffZ = 0.0f;
            if (i > 0) {
                rOffX = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / displayPos.sx;
                rOffY = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / displayPos.sy;
                rOffZ = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / displayPos.sz;
            }
            GL11.glTranslatef((float)rOffX, (float)rOffY, (float)rOffZ);
            this.renderSingle(tessellator, holder, itemStack, items3d, brightness, alpha, partialTick, mirrorX);
            GL11.glTranslatef((float)(-rOffX), (float)(-rOffY), (float)(-rOffZ));
        }
    }

    @Override
    protected void renderSingle(@NotNull Tessellator tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, boolean items3d, float brightness, float alpha, float partialTick, boolean mirrorX) {
        if (!this.blockModel.shouldItemRender3d()) {
            super.renderSingle(tessellator, holder, itemStack, items3d, brightness, alpha, partialTick, mirrorX);
        } else {
            TextureRegistry.blockAtlas.bind();
            this.blockModel.renderStandalone(tessellator, itemStack.getMetadata(), brightness, alpha, null);
        }
    }

    @Override
    public void renderGui(@NotNull Tessellator tessellator, @Nullable Entity holder, @NotNull ItemStack itemStack, int x, int y, float brightness, float alpha, float partialTick) {
        if (!this.blockModel.shouldItemRender3d()) {
            super.renderGui(tessellator, holder, itemStack, x, y, brightness, alpha, partialTick);
            return;
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        GL11.glTranslatef((float)(x + 8), (float)(y + 8), (float)8.0f);
        GL11.glScalef((float)16.0f, (float)-16.0f, (float)16.0f);
        this.render(tessellator, holder, itemStack, "gui", false, 1, brightness, alpha, partialTick, false);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    @Override
    public void renderItemEntity(@NotNull Tessellator tessellator, @NotNull ItemStack itemStack, boolean items3d, int clusterSize, int ticks, float yaw, float brightness, float alpha, float partialTick) {
        if (!this.blockModel.shouldItemRender3d()) {
            super.renderItemEntity(tessellator, itemStack, items3d, clusterSize, ticks, yaw, brightness, alpha, partialTick);
            return;
        }
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
        this.render(tessellator, null, itemStack, "ground", items3d, clusterSize, brightness, alpha, partialTick, false);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
    }

    @Override
    public int getColor(ItemStack stack) {
        return ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(stack.getMetadata(), 0);
    }
}

