/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.data.entity.mojang;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.useless.util.GsonHelper;

public class Face {
    public final double @NotNull [] uv;
    public final double @NotNull [] uv_size;
    public final int uv_rotation;

    protected Face(double @NotNull [] uv, double @NotNull [] uvSize, int uv_rotation) {
        this.uv = uv;
        this.uv_size = uvSize;
        this.uv_rotation = uv_rotation;
    }

    public static class Builder {
        private final double @NotNull [] uv;
        private final double @NotNull [] uv_size;
        private int uv_rotation;

        public Builder(double u, double v, double uSize, double vSize) {
            this.uv = new double[]{u, v};
            this.uv_size = new double[]{uSize, vSize};
            this.uv_rotation = 0;
        }

        public Builder(double @NotNull [] uv, double @NotNull [] uvSize) {
            this.uv = uv;
            this.uv_size = uvSize;
            this.uv_rotation = 0;
        }

        @NotNull
        public Builder setUVRotation(int rotation) {
            this.uv_rotation = (rotation + 360) % 360 / 90;
            return this;
        }

        protected void setMirror() {
            this.uv[0] = this.uv[0] + this.uv_size[0];
            this.uv_size[0] = this.uv_size[0] * -1.0;
        }

        @NotNull
        protected Face build() {
            return new Face(this.uv, this.uv_size, this.uv_rotation);
        }

        public static class Serializer
        implements JsonSerializer<Builder>,
        JsonDeserializer<Builder> {
            @Override
            public Builder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                double[] uv = GsonHelper.getAsDoubleArray(object.get("uv"), 2);
                double[] uvSize = GsonHelper.getAsDoubleArray(object.get("uv_size"), 2);
                Builder builder = new Builder(uv, uvSize);
                if (object.has("uv_rotation")) {
                    builder.setUVRotation(object.get("uv_rotation").getAsInt());
                }
                return builder;
            }

            @Override
            public JsonElement serialize(Builder src, Type typeOfSrc, JsonSerializationContext context) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

