/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.console;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogMessage {
    @Nullable
    private final Level level;
    @NotNull
    private final String message;

    public LogMessage(@NotNull String message) {
        @Nullable Level level = null;
        for (Level l : Level.values()) {
            @NotNull String prefix = (Object)((Object)l) + ": ";
            if (!message.startsWith(prefix)) continue;
            level = l;
            message = message.substring(prefix.length());
            break;
        }
        this.level = level;
        this.message = message;
    }

    @Nullable
    public Level getLevel() {
        return this.level;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

