/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.Option;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.core.util.helper.Toggleable;

public abstract class OptionToggleable<E>
extends Option<E>
implements Toggleable {
    public E[] values;

    public OptionToggleable(GameSettings gameSettings, String name, E defaultValue, E[] values) {
        super(gameSettings, name, defaultValue);
        this.values = values;
    }

    @Override
    public void toggle() {
        this.value = this.values[(this.getValueIndex() + 1) % this.values.length];
    }

    public void toggle(int delta) {
        this.value = this.values[DynamicTexture.pmod(this.getValueIndex() + delta, this.values.length)];
    }

    public int getValueIndex() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.value != this.values[i]) continue;
            return i;
        }
        return 0;
    }

    public void setValueWithIndex(int i) {
        this.value = this.values[i];
    }

    public int size() {
        return this.values.length;
    }

    public abstract boolean isSlider();
}

