/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockModelJarButterfly<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelJarButterfly(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, WorldSource worldSource, int x, int y, int z) {
        int meta = worldSource.getBlockMetadata(x, y, z);
        boolean isHanging = (meta & 1) == 0;
        boolean isAngled = (meta & 2) != 0;
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(worldSource, x, y, z));
        } else {
            brightness = renderBlocks.getBlockBrightness(worldSource, x, y, z);
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        float yOffset = isHanging ? 0.0f : 0.375f;
        float intMinX = (float)x + 0.5f - 0.125f;
        float intMinY = (float)y + yOffset + 0.0625f;
        float intMinZ = (float)z + 0.5f - 0.125f;
        float intMaxX = (float)x + 0.5f + 0.125f;
        float intMaxY = (float)y + (0.4375f + yOffset);
        float intMaxZ = (float)z + 0.5f + 0.125f;
        float extMinX = (float)x + 0.5f - 0.1875f;
        float extMinY = (float)y + yOffset;
        float extMinZ = (float)z + 0.5f - 0.1875f;
        float extMaxX = (float)x + 0.5f + 0.1875f;
        float extMaxY = (float)y + (0.5f + yOffset);
        float extMaxZ = (float)z + 0.5f + 0.1875f;
        float hookMinX = (float)x + 0.5f - 0.125f;
        float hookMinZ = (float)z + 0.5f - 0.125f;
        float hookMaxX = (float)x + 0.5f + 0.125f;
        float hookMaxY = intMaxY + 0.25f;
        float hookMaxZ = (float)z + 0.5f + 0.125f;
        IconCoordinate texIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, meta);
        double texU = texIndex.getIconUMin();
        double texV = texIndex.getIconVMin();
        double onePix = 0.0625;
        double extSideMinU = texU;
        double extSideMaxU = texIndex.getSubIconU(onePix * 6.0);
        double extSideMinV = texIndex.getSubIconV(onePix * 6.0);
        double extSideMaxV = texIndex.getSubIconV(onePix * 14.0);
        double extTopMinU = texU;
        double extTopMaxU = texIndex.getSubIconU(onePix * 6.0);
        double extTopMinV = texV;
        double extTopMaxV = texIndex.getSubIconV(onePix * 6.0);
        double extBottomMinU = texIndex.getSubIconU(onePix * 6.0);
        double extBottomMaxU = texIndex.getSubIconU(onePix * 12.0);
        double extBottomMinV = texV;
        double extBottomMaxV = texIndex.getSubIconV(onePix * 6.0);
        double hookMinU = texIndex.getSubIconU(onePix * 10.0);
        double hookMaxU = texIndex.getSubIconU(onePix * 16.0);
        double hookMinV = texIndex.getSubIconV(onePix * 6.0);
        double hookMaxV = texIndex.getSubIconV(onePix * 10.0);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMaxZ, extTopMinU, extTopMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMaxZ, extTopMaxU, extTopMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMinZ, extTopMaxU, extTopMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMinZ, extTopMinU, extTopMinV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extBottomMinU, extBottomMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extBottomMaxU, extBottomMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extBottomMaxU, extBottomMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extBottomMinU, extBottomMaxV);
        tessellator.addVertexWithUV(hookMinX, intMaxY, hookMinZ, hookMinU, hookMaxV);
        tessellator.addVertexWithUV(hookMaxX, intMaxY, hookMaxZ, hookMaxU, hookMaxV);
        tessellator.addVertexWithUV(hookMaxX, hookMaxY, hookMaxZ, hookMaxU, hookMinV);
        tessellator.addVertexWithUV(hookMinX, hookMaxY, hookMinZ, hookMinU, hookMinV);
        tessellator.addVertexWithUV(hookMinX, hookMaxY, hookMinZ, hookMaxU, hookMinV);
        tessellator.addVertexWithUV(hookMaxX, hookMaxY, hookMaxZ, hookMinU, hookMinV);
        tessellator.addVertexWithUV(hookMaxX, intMaxY, hookMaxZ, hookMinU, hookMaxV);
        tessellator.addVertexWithUV(hookMinX, intMaxY, hookMinZ, hookMaxU, hookMaxV);
        tessellator.addVertexWithUV(hookMinX, intMaxY, intMaxZ, hookMinU, hookMaxV);
        tessellator.addVertexWithUV(hookMaxX, intMaxY, intMinZ, hookMaxU, hookMaxV);
        tessellator.addVertexWithUV(hookMaxX, hookMaxY, intMinZ, hookMaxU, hookMinV);
        tessellator.addVertexWithUV(hookMinX, hookMaxY, intMaxZ, hookMinU, hookMinV);
        tessellator.addVertexWithUV(hookMinX, hookMaxY, hookMaxZ, hookMaxU, hookMinV);
        tessellator.addVertexWithUV(hookMaxX, hookMaxY, hookMinZ, hookMinU, hookMinV);
        tessellator.addVertexWithUV(hookMaxX, intMaxY, hookMinZ, hookMinU, hookMaxV);
        tessellator.addVertexWithUV(hookMinX, intMaxY, hookMaxZ, hookMaxU, hookMaxV);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

