/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.Global;
import net.minecraft.core.block.entity.TileEntityMeshGold;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererMeshGold
extends TileEntityRenderer<TileEntityMeshGold> {
    @Override
    public void doRender(Tessellator tessellator, TileEntityMeshGold tileEntity, double x, double y, double z, float renderPartialTicks) {
        if (tileEntity.filterItem == null) {
            return;
        }
        GL11.glPushMatrix();
        float bobbingOffset = MathHelper.sin(((float)tileEntity.ticksRan + renderPartialTicks) / 10.0f) * 0.1f + 0.1f;
        float yaw = (float)Math.toDegrees(((float)tileEntity.ticksRan + renderPartialTicks) / 20.0f);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + bobbingOffset + 0.25f), (float)((float)z + 0.5f));
        float lightLevel = Minecraft.getMinecraft().currentWorld.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
        if (Global.accessor.isFullbrightEnabled()) {
            lightLevel = 1.0f;
        }
        ItemModelDispatcher.getInstance().getDispatch(tileEntity.filterItem).renderItemEntity(tessellator, tileEntity.filterItem, (Boolean)Minecraft.getMinecraft().gameSettings.items3D.value, 1, tileEntity.ticksRan, yaw, lightLevel, 1.0f, renderPartialTicks);
        GL11.glPopMatrix();
    }
}

