/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class TileEntityRendererSign
extends TileEntityRenderer<TileEntitySign> {
    private final Minecraft mc = Minecraft.getMinecraft();
    @NotNull
    private final StringBuilder builder = new StringBuilder();

    @Override
    public void doRender(@NotNull Tessellator t, @NotNull TileEntitySign tileEntity, double x, double y, double z, float partialTick) {
        float height;
        StaticEntityModel model;
        float angle;
        Block<?> block = tileEntity.getBlock();
        if (block == null || !(block.getLogic() instanceof BlockLogicSign)) {
            return;
        }
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        float scale = 0.041666668f;
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        if (((BlockLogicSign)block.getLogic()).isFreeStanding) {
            angle = (float)(tileEntity.getBlockMeta() * 360) / 16.0f;
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
            model = this.getModel("post");
            height = 20.0f;
        } else {
            switch (tileEntity.getBlockMeta()) {
                case 2: {
                    angle = 180.0f;
                    break;
                }
                case 3: {
                    angle = 0.0f;
                    break;
                }
                case 4: {
                    angle = 90.0f;
                    break;
                }
                default: {
                    angle = -90.0f;
                }
            }
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.45833334f);
            model = this.getModel("wall");
            height = 13.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.041666668f, (float)0.041666668f, (float)-0.041666668f);
        this.bindTexture("/assets/minecraft/textures/entity/sign.png");
        model.render(t);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(height * 0.041666668f), (float)0.04375f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        EnumSignPicture picture = tileEntity.getPicture();
        TileEntityRendererSign.drawTexturedModalRect(1.0, 0.5, TextureRegistry.getTexture(picture.getTextureKey()));
        GL11.glPopMatrix();
        FontRenderer sr = this.getFont();
        float lightLevel = LightmapHelper.isLightmapEnabled() || this.mc.isFullbrightEnabled() ? 1.0f : this.mc.currentWorld.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
        float lightOffset = 0.0f;
        if (tileEntity.isGlowing()) {
            lightLevel = 1.0f;
            lightOffset = 96.0f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 15));
            }
        }
        GL11.glPushMatrix();
        float scale2 = 0.011111113f;
        GL11.glTranslatef((float)0.0f, (float)(height * 0.041666668f), (float)0.045833334f);
        GL11.glScalef((float)0.011111113f, (float)-0.011111113f, (float)0.011111113f);
        GL11.glDepthMask((boolean)false);
        int color = Colors.allSignColors[tileEntity.getColor().id].getARGB();
        int r = (int)MathHelper.clamp((float)Color.redFromInt(color) * lightLevel + lightOffset, 0.0f, 255.0f);
        int g = (int)MathHelper.clamp((float)Color.greenFromInt(color) * lightLevel + lightOffset, 0.0f, 255.0f);
        int b = (int)MathHelper.clamp((float)Color.blueFromInt(color) * lightLevel + lightOffset, 0.0f, 255.0f);
        color = Color.intToIntARGB(0, r, g, b);
        for (int line = 0; line < tileEntity.signText.length; ++line) {
            this.builder.setLength(0);
            if (line == tileEntity.lineBeingEdited) {
                this.builder.append("\u00a7+\u00a70> \u00a7-").append(tileEntity.signText[line]).append("\u00a7+\u00a70 <\u00a7-");
            } else {
                this.builder.append(tileEntity.signText[line]);
            }
            sr.render(t, this.builder, -sr.stringWidth(this.builder) / 2, line * 10 - tileEntity.signText.length * 5).setColor(color).call();
        }
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
    }

    private static void drawTexturedModalRect(double width, double height, @NotNull IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-width / 2.0, height / 2.0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(-width / 2.0, -height / 2.0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(width / 2.0, -height / 2.0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(width / 2.0, height / 2.0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.draw();
    }
}

