/*
 * Decompiled with CFR 0.152.
 */
package com.github.zarzelcow.legacylwjgl3.implementation.glfw;

import com.github.zarzelcow.legacylwjgl3.implementation.input.MouseImplementation;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorEnterCallback;
import org.lwjgl.glfw.GLFWCursorEnterCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.EventQueue;

public class GLFWMouseImplementation
implements MouseImplementation {
    private GLFWMouseButtonCallback buttonCallback;
    private GLFWCursorPosCallback posCallback;
    private GLFWScrollCallback scrollCallback;
    private GLFWCursorEnterCallback cursorEnterCallback;
    private long windowHandle;
    private boolean grabbed;
    private boolean isInsideWindow;
    private final EventQueue event_queue = new EventQueue(22);
    private final ByteBuffer tmp_event = ByteBuffer.allocate(22);
    private int last_x;
    private int last_y;
    private int accum_dx;
    private int accum_dy;
    private int accum_dz;
    private byte[] button_states = new byte[this.getButtonCount()];
    private long last_event_nanos;

    @Override
    public void createMouse() {
        this.windowHandle = Display.getHandle();
        if (GLFW.glfwRawMouseMotionSupported() && !Mouse.getPrivilegedBoolean("org.lwjgl.input.Mouse.disableRawInput")) {
            GLFW.glfwSetInputMode((long)this.windowHandle, (int)208901, (int)1);
        }
        this.buttonCallback = GLFWMouseButtonCallback.create((window, button, action, mods) -> {
            byte state = action == 1 ? (byte)1 : (byte)0;
            this.putMouseEvent((byte)button, state, 0, System.nanoTime());
            if (button < this.button_states.length) {
                this.button_states[button] = state;
            }
        });
        this.posCallback = GLFWCursorPosCallback.create((window, xpos, ypos) -> {
            int x = (int)xpos;
            int y = Display.getHeight() - 1 - (int)ypos;
            int dx = x - this.last_x;
            int dy = y - this.last_y;
            if (dx != 0 || dy != 0) {
                this.accum_dx += dx;
                this.accum_dy += dy;
                this.last_x = x;
                this.last_y = y;
                long nanos = System.nanoTime();
                if (this.grabbed) {
                    this.putMouseEventWithCoords((byte)-1, (byte)0, dx, dy, 0, nanos);
                } else {
                    this.putMouseEventWithCoords((byte)-1, (byte)0, x, y, 0, nanos);
                }
            }
        });
        this.scrollCallback = GLFWScrollCallback.create((window, xoffset, yoffset) -> {
            this.accum_dz = (int)((double)this.accum_dz + yoffset);
            this.putMouseEvent((byte)-1, (byte)0, (int)yoffset, System.nanoTime());
        });
        this.cursorEnterCallback = GLFWCursorEnterCallback.create((window, entered) -> {
            this.isInsideWindow = entered;
        });
        GLFW.glfwSetMouseButtonCallback((long)this.windowHandle, (GLFWMouseButtonCallbackI)this.buttonCallback);
        GLFW.glfwSetCursorPosCallback((long)this.windowHandle, (GLFWCursorPosCallbackI)this.posCallback);
        GLFW.glfwSetScrollCallback((long)this.windowHandle, (GLFWScrollCallbackI)this.scrollCallback);
        GLFW.glfwSetCursorEnterCallback((long)this.windowHandle, (GLFWCursorEnterCallbackI)this.cursorEnterCallback);
    }

    private void putMouseEvent(byte button, byte state, int dz, long nanos) {
        if (this.grabbed) {
            this.putMouseEventWithCoords(button, state, 0, 0, dz, nanos);
        } else {
            this.putMouseEventWithCoords(button, state, this.last_x, this.last_y, dz, nanos);
        }
    }

    private void putMouseEventWithCoords(byte button, byte state, int coord1, int coord2, int dz, long nanos) {
        this.tmp_event.clear();
        this.tmp_event.put(button).put(state).putInt(coord1).putInt(coord2).putInt(dz).putLong(nanos);
        this.tmp_event.flip();
        this.event_queue.putEvent(this.tmp_event);
        this.last_event_nanos = nanos;
    }

    @Override
    public void destroyMouse() {
        this.buttonCallback.free();
        this.posCallback.free();
        this.scrollCallback.free();
        this.cursorEnterCallback.free();
    }

    private void reset() {
        this.event_queue.clearEvents();
        this.accum_dy = 0;
        this.accum_dx = 0;
    }

    @Override
    public void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons_buffer) {
        if (this.grabbed) {
            coord_buffer.put(0, this.accum_dx);
            coord_buffer.put(1, this.accum_dy);
        } else {
            coord_buffer.put(0, this.last_x);
            coord_buffer.put(1, this.last_y);
        }
        coord_buffer.put(2, this.accum_dz);
        this.accum_dz = 0;
        this.accum_dy = 0;
        this.accum_dx = 0;
        for (int i = 0; i < this.button_states.length; ++i) {
            buttons_buffer.put(i, this.button_states[i]);
        }
    }

    @Override
    public void readMouse(ByteBuffer readBuffer) {
        this.event_queue.copyEvents(readBuffer);
    }

    @Override
    public void setCursorPosition(int x, int y) {
        this.last_x = x;
        this.last_y = y;
        GLFW.glfwSetCursorPos((long)this.windowHandle, (double)x, (double)y);
    }

    @Override
    public void grabMouse(boolean grab) {
        GLFW.glfwSetInputMode((long)this.windowHandle, (int)208897, (int)(grab ? 212995 : 212993));
        this.grabbed = grab;
        this.reset();
    }

    @Override
    public boolean hasWheel() {
        return true;
    }

    @Override
    public int getButtonCount() {
        return 8;
    }

    @Override
    public boolean isInsideWindow() {
        return this.isInsideWindow;
    }
}

