/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.console.shell.commands;

import bsh.CallStack;
import bsh.ClassIdentifier;
import bsh.Interpreter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.client.console.shell.RawOutputWrapper;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class fields {
    public static RawOutputWrapper invoke(Interpreter env, CallStack callstack, Object o) {
        Field[] fields2;
        if (o == null) {
            return new RawOutputWrapper(TextFormatting.RED + "Argument was null!");
        }
        Class<?> clazz = o.getClass();
        StringBuilder sb = new StringBuilder();
        for (Field field : fields2 = clazz.getFields()) {
            sb.append(TextFormatting.WHITE).append("    ").append(TextFormatting.ORANGE).append(Modifier.toString(field.getModifiers())).append(" ");
            if (field.getType().isPrimitive()) {
                sb.append(TextFormatting.ORANGE);
            } else {
                sb.append(TextFormatting.WHITE);
            }
            sb.append(field.getType().getSimpleName()).append(" ").append(TextFormatting.PINK).append(field.getName()).append(TextFormatting.WHITE).append(" = ");
            fields.appendObject(field, o, sb);
            sb.append(TextFormatting.WHITE).append(";\n");
        }
        return new RawOutputWrapper(sb.toString());
    }

    public static RawOutputWrapper invoke(Interpreter env, CallStack callstack, ClassIdentifier clazz) {
        StringBuilder sb = new StringBuilder();
        if (clazz.getTargetClass() != null) {
            Field[] fields2;
            for (Field field : fields2 = clazz.getTargetClass().getFields()) {
                sb.append(TextFormatting.WHITE).append("    ").append(TextFormatting.ORANGE).append(Modifier.toString(field.getModifiers())).append(" ").append(TextFormatting.WHITE).append(field.getType().getSimpleName()).append(" ").append(TextFormatting.PINK).append(field.getName());
                if (Modifier.isStatic(field.getModifiers())) {
                    sb.append(TextFormatting.WHITE).append(" = ");
                    fields.appendObject(field, null, sb);
                }
                sb.append(TextFormatting.WHITE).append(";\n");
            }
            return new RawOutputWrapper(sb.toString());
        }
        return null;
    }

    private static void appendObject(Field field, Object o, StringBuilder sb) {
        try {
            @Nullable Object v = field.get(o);
            if (v instanceof String) {
                sb.append(TextFormatting.LIGHT_BLUE).append("\"").append(v).append("\"");
            } else if (!field.getType().isPrimitive() && v != null) {
                if (v.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == Object.class) {
                    sb.append(TextFormatting.ORANGE).append("new ").append(TextFormatting.WHITE).append(v.getClass().getSimpleName()).append("()");
                } else {
                    sb.append(TextFormatting.LIGHT_BLUE).append("[").append(v).append("]");
                }
            } else {
                sb.append(TextFormatting.LIGHT_BLUE).append(v);
            }
        }
        catch (IllegalAccessException e) {
            sb.append("?!");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

