/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.option.OptionToggleable;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import org.lwjgl.opengl.GL11;

public class IntegerSliderElement
extends ButtonElement {
    public int sliderValue;
    public boolean dragging = false;
    public boolean renderText = true;
    private OptionToggleable<?> option;
    public IconCoordinate backgroundTexture;

    public IntegerSliderElement(int id, int xPosition, int yPosition, OptionToggleable<?> option) {
        this(id, xPosition, yPosition, 150, 20, option);
    }

    public IntegerSliderElement(int id, int xPosition, int yPosition, int width, int height, OptionToggleable<?> option) {
        super(id, xPosition, yPosition, width, height, option.getDisplayStringValue());
        this.option = option;
        this.sliderValue = option.getValueIndex();
        this.displayString = option.getDisplayStringValue();
    }

    @Override
    protected void setDefaultTextures() {
        this.backgroundTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider_background");
        this.defaultTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider");
        this.hoveredTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider_highlighted");
        this.disabledTexture = TextureRegistry.getTexture("minecraft:gui/widgets/slider/slider_disabled");
    }

    private int getSliderWidth() {
        return 8;
    }

    @Override
    public void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        int sliderWidth = this.getSliderWidth();
        int maxValue = this.option.size() - 1;
        if (this.dragging) {
            int segments = maxValue;
            float percentage = (float)(mouseX - (this.xPosition + 4) - this.width / (2 * segments)) / (float)(this.width - sliderWidth);
            if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            if (percentage < 0.0f) {
                percentage = 0.0f;
            }
            this.sliderValue = (int)Math.ceil((float)segments * percentage);
            this.option.setValueWithIndex(this.sliderValue);
            this.displayString = this.option.getDisplayStringValue();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        int textColor;
        IconCoordinate tex;
        if (!this.visible) {
            return;
        }
        boolean mouseOver = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
        int state = this.getButtonState(mouseOver);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (state) {
            case 0: {
                tex = this.disabledTexture;
                break;
            }
            case 2: {
                tex = this.hoveredTexture;
                break;
            }
            default: {
                tex = this.defaultTexture;
            }
        }
        this.drawGuiIcon(this.xPosition, this.yPosition, this.width, this.height, this.backgroundTexture);
        int sliderWidth = this.getSliderWidth();
        int maxValue = this.option.size() - 1;
        this.drawGuiIcon(this.xPosition + (int)((float)this.sliderValue / (float)maxValue * (float)(this.width - sliderWidth)), this.yPosition, sliderWidth, this.height, tex);
        this.mouseDragged(mc, mouseX, mouseY);
        switch (state) {
            case 0: {
                textColor = 0xA0A0A0;
                break;
            }
            case 1: {
                textColor = 0xE0E0E0;
                break;
            }
            default: {
                textColor = 0xFFFFA0;
            }
        }
        if (this.renderText) {
            this.drawStringCenteredShadow(mc.font, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, textColor);
        }
    }

    @Override
    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        if (super.mouseClicked(mc, mouseX, mouseY)) {
            int segments = this.option.size() - 1;
            float percentage = (float)(mouseX - (this.xPosition + 4) - this.width / (2 * segments)) / (float)(this.width - 8);
            if (percentage > 1.0f) {
                percentage = 1.0f;
            }
            if (percentage < 0.0f) {
                percentage = 0.0f;
            }
            this.sliderValue = (int)Math.ceil((float)segments * percentage);
            this.option.setValueWithIndex(this.sliderValue);
            this.displayString = this.option.getDisplayStringValue();
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY) {
        this.dragging = false;
        this.displayString = this.option.getDisplayString();
    }
}

