/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.entity.player.PlayerLocalMultiplayer;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenMainMenu;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.PacketKeepAlive;
import net.minecraft.core.player.gamemode.Gamemode;
import org.lwjgl.opengl.GL11;

public class ScreenGameOver
extends Screen {
    protected int tickCount = 0;

    @Override
    public void tick() {
        ++this.tickCount;
        if (this.mc.isMultiplayerWorld() && this.mc.thePlayer instanceof PlayerLocalMultiplayer && this.tickCount % 10 == 0) {
            PlayerLocalMultiplayer clientPlayerMP = (PlayerLocalMultiplayer)this.mc.thePlayer;
            clientPlayerMP.sendQueue.addToSendQueue(new PacketKeepAlive());
        }
    }

    @Override
    public void init() {
        I18n i18n = I18n.getInstance();
        this.buttons.clear();
        String respawnKey = this.mc.thePlayer.getGamemode() == Gamemode.hardcore || this.mc.thePlayer.getGamemode() == Gamemode.spectator ? "gui.game_over.button.respawn.spectator" : "gui.game_over.button.respawn";
        this.buttons.add(new ButtonElement(1, this.width / 2 - 100, this.height / 4 + 72, i18n.translateKey(respawnKey)));
        this.buttons.add(new ButtonElement(2, this.width / 2 - 100, this.height / 4 + 96, i18n.translateKey("gui.game_over.button.title_screen")));
        if (this.mc.session == null) {
            ((ButtonElement)this.buttons.get((int)1)).enabled = false;
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        if (button.id == 1) {
            this.mc.thePlayer.respawnPlayer();
            this.mc.displayScreen(null);
        }
        if (button.id == 2) {
            if (this.mc.isMultiplayerWorld()) {
                this.mc.currentWorld.sendQuittingDisconnectingPacket();
            }
            this.mc.changeWorld(null);
            this.mc.displayScreen(new ScreenMainMenu());
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        I18n i18n = I18n.getInstance();
        this.drawGradientRect(0, 0, this.width, this.height, 0x60500000, -1602211792);
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.drawStringCenteredShadow(this.fontRenderer, i18n.translateKey("gui.game_over.label.title"), this.width / 2 / 2, 30, 0xFFFFFF);
        GL11.glPopMatrix();
        this.drawStringCenteredShadow(this.fontRenderer, i18n.translateKeyAndFormat("gui.game_over.label.score", TextFormatting.YELLOW.toString() + this.mc.thePlayer.getScore()), this.width / 2, 100, 0xFFFFFF);
        super.render(mx, my, partialTick);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }
}

