/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.ArtType;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ScreenPaintingPicker
extends Screen {
    private final Player player;
    private final List<ArtEntry> artEntries = new ArrayList<ArtEntry>();
    private ArtType centerArt = ArtType.Kebab;
    private int tallestSize = 0;

    public ScreenPaintingPicker(Player player) {
        this.player = player;
        for (ArtType art : ArtType.values) {
            if (art.sizeY <= this.tallestSize) continue;
            this.tallestSize = art.sizeY;
        }
    }

    @Override
    public void init() {
        super.init();
        this.centerArt = this.player.getSelectedArt();
        this.updateArtEntries();
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        super.render(mx, my, partialTick);
        float dWheel = Mouse.getDWheel();
        if (dWheel < 0.0f) {
            this.centerArt = ArtType.getNext(this.centerArt);
            this.updateArtEntries();
        } else if (dWheel > 0.0f) {
            this.centerArt = ArtType.getPrevious(this.centerArt);
            this.updateArtEntries();
        }
        this.drawPaintings(this.width, this.height, mx, my);
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        int scale = this.getScale(this.width, this.height);
        if (buttonNum == 0) {
            for (ArtEntry artEntry : this.artEntries) {
                if (mx < artEntry.x || mx > artEntry.x + artEntry.art.sizeX * scale || my < artEntry.y || my > artEntry.y + artEntry.art.sizeY * scale) continue;
                this.mc.playerController.setPaintingType(artEntry.art);
                this.mc.displayScreen(null);
                break;
            }
        }
    }

    private void updateArtEntries() {
        float alpha;
        int pCenterY;
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int scale = this.getScale(this.width, this.height);
        int offsetX = 32 * scale;
        int artGap = 2;
        this.artEntries.clear();
        this.artEntries.add(new ArtEntry(this.centerArt, centerX - offsetX, centerY - this.centerArt.sizeY * scale / 2, 1.0f));
        ArtType currentArt = ArtType.getNext(this.centerArt);
        int dy = this.centerArt.sizeY * scale / 2 + artGap + 28;
        while (currentArt != this.centerArt) {
            pCenterY = dy;
            alpha = 1.0f - (float)pCenterY / ((float)this.height / 2.0f);
            this.artEntries.add(new ArtEntry(currentArt, centerX - offsetX, centerY + dy, alpha * 0.75f));
            dy += currentArt.sizeY * scale + artGap;
            currentArt = ArtType.getNext(currentArt);
        }
        currentArt = ArtType.getPrevious(this.centerArt);
        dy = -(this.centerArt.sizeY * scale / 2);
        while (currentArt != this.centerArt) {
            pCenterY = (dy -= currentArt.sizeY * scale + artGap) + currentArt.sizeY * scale;
            alpha = 1.0f - (float)(-pCenterY) / ((float)this.height / 2.0f);
            this.artEntries.add(new ArtEntry(currentArt, centerX - offsetX, centerY + dy, alpha * 0.75f));
            currentArt = ArtType.getPrevious(currentArt);
        }
    }

    private void drawPaintings(int screenWidth, int screenHeight, int mouseX, int mouseY) {
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        int scale = this.getScale(screenWidth, screenHeight);
        int offsetX = 32 * scale;
        GL11.glEnable((int)3553);
        this.drawStringShadow(this.fontRenderer, this.centerArt.title, centerX - offsetX, centerY + this.centerArt.sizeY / 2 * scale + 4, -1);
        this.drawStringShadow(this.fontRenderer, this.centerArt.artist, centerX - offsetX, centerY + this.centerArt.sizeY / 2 * scale + 16, 0x7F7F7F7F);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (ArtEntry entry : this.artEntries) {
            if (!(entry.alpha > 0.0f)) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (mouseX > entry.x && mouseX < entry.x + entry.art.sizeX * scale && mouseY > entry.y && mouseY < entry.y + entry.art.sizeY * scale) {
                GL11.glDisable((int)3553);
                this.drawRectWidthHeight(entry.x - scale, entry.y - scale, (entry.art.sizeX + 2) * scale, (entry.art.sizeY + 2) * scale, -1);
                GL11.glEnable((int)3553);
                this.drawPainting(entry.art, entry.x, entry.y, entry.art.sizeX, entry.art.sizeY, 1.0f);
                continue;
            }
            this.drawPainting(entry.art, entry.x, entry.y, entry.art.sizeX, entry.art.sizeY, entry.alpha);
        }
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void drawPainting(ArtType art, int x, int y, int width, int height, float alpha) {
        int scale = this.getScale(this.width, this.height);
        this.drawTexturedIconPainting(x, y, width * scale, height * scale, TextureRegistry.getTexture(art.texture), alpha);
    }

    public void drawTexturedIconPainting(int x, int y, int width, int height, IconCoordinate coordinate, float alpha) {
        coordinate.parentAtlas.bind();
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0, y + height, this.zLevel, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(x + width, y + height, this.zLevel, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(x + width, y + 0, this.zLevel, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(x + 0, y + 0, this.zLevel, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.draw();
    }

    public int getScale(int width, int height) {
        return Math.min((int)((float)height * 0.9f / (float)this.tallestSize), this.mc.resolution.getScale());
    }

    private static final class ArtEntry {
        public final ArtType art;
        public final int x;
        public final int y;
        public final float alpha;

        public ArtEntry(ArtType art, int x, int y, float alpha) {
            this.art = art;
            this.x = x;
            this.y = y;
            this.alpha = alpha;
        }
    }
}

