/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.chat;

import com.mojang.logging.LogUtils;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.chat.GuiElementChatEmotePicker;
import net.minecraft.client.gui.chat.GuiElementChatSuggestions;
import net.minecraft.client.gui.chat.ScreenSleepMP;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.keyboard.ScreenKeyboard;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.client.input.InputType;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.slf4j.Logger;

public class ScreenChat
extends Screen
implements ITextField {
    protected static final Logger LOGGER = LogUtils.getLogger();
    public String message;
    private int currentIndex = 0;
    private String originalMessage;
    private int updateCounter;
    private final TextFieldEditor editor;
    protected GuiElementChatEmotePicker emotePicker;
    protected boolean showEmotePicker = false;
    private GuiElementChatSuggestions suggestionsElement;

    public ScreenChat() {
        this("");
    }

    public ScreenChat(String initialMessage) {
        this.message = initialMessage;
        this.updateCounter = 0;
        this.editor = new TextFieldEditor(this);
        this.editor.setCursor(10000);
    }

    @Override
    public void init() {
        Keyboard.enableRepeatEvents(true);
        try {
            int emotePickerYCells = (int)MathHelper.clamp(Math.ceil((double)ChatEmotes.getEmotes().size() / 5.0), 0.0, 4.0);
            this.emotePicker = new GuiElementChatEmotePicker(this.mc, this, 5, emotePickerYCells);
            this.showEmotePicker = false;
            this.suggestionsElement = new GuiElementChatSuggestions(this.mc, this.editor, this, (parent, child, minecraft, followParameters) -> 16 + (followParameters ? this.suggestionsElement.getDefaultParameterPosition() - 1 : 0), (parent, child, minecraft, followParameters) -> minecraft.resolution.getScaledHeightScreenCoords() - 14, ComponentAnchor.BOTTOM_LEFT);
            if (!this.getText().startsWith("/")) {
                this.suggestionsElement.hidden = true;
            } else {
                this.suggestionsElement.updateSuggestions();
            }
            if (((Boolean)this.mc.gameSettings.forceOnscreenKeyboard.value).booleanValue() || this.mc.inputType == InputType.CONTROLLER) {
                this.suggestionsElement.hidden = true;
                this.mc.displayScreen(new ScreenKeyboard(this, this.editor, workingString -> this.sendMessage(), (c, k, workingString) -> {
                    this.suggestionsElement.hidden = !this.getText().startsWith("/");
                    this.suggestionsElement.keyTyped(c, k);
                }, s -> {
                    this.suggestionsElement.hidden = !this.getText().startsWith("/");
                    this.suggestionsElement.updateSuggestions();
                }));
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while attempting to initialize chat screen!", e);
        }
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents(false);
        this.mc.hudIngame.chatScroll = 0;
    }

    @Override
    public void tick() {
        if ((((Boolean)this.mc.gameSettings.forceOnscreenKeyboard.value).booleanValue() || this.mc.inputType == InputType.CONTROLLER) && !(this.mc.currentScreen instanceof ScreenKeyboard)) {
            this.mc.displayScreen(null);
            return;
        }
        ++this.updateCounter;
        try {
            int dWheel = Mouse.getDWheel();
            if (dWheel != 0) {
                if (this.showEmotePicker) {
                    this.emotePicker.scrollOffset((int)((float)(-dWheel) / 0.1f));
                } else {
                    this.mc.hudIngame.chatScroll += dWheel;
                }
            }
            if (this.suggestionsElement != null) {
                this.suggestionsElement.hidden = !this.getText().startsWith("/");
                this.suggestionsElement.updateScreen(dWheel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while attempting to tick chat!", e);
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        try {
            boolean handled = false;
            if (eventKey == Keyboard.KEY_UP) {
                if (this.suggestionsElement != null && this.suggestionsElement.getCommandIndex() != -1) {
                    this.suggestionsElement.cycleThroughSuggestions(-1);
                    handled = true;
                }
                if (!handled && !this.mc.thePlayer.messageHistory.isEmpty()) {
                    if (this.currentIndex == 0) {
                        this.originalMessage = this.getText();
                    }
                    if (this.currentIndex < this.mc.thePlayer.messageHistory.size()) {
                        ++this.currentIndex;
                        this.setText(this.getMessage(this.currentIndex));
                        this.editor.setCursor(10000);
                    }
                    this.editor.setCursor(10000);
                    if (this.suggestionsElement != null) {
                        this.suggestionsElement.updateSuggestions();
                    }
                    handled = true;
                }
            }
            if (eventKey == Keyboard.KEY_DOWN) {
                if (this.suggestionsElement != null && this.suggestionsElement.getCommandIndex() != -1) {
                    this.suggestionsElement.cycleThroughSuggestions();
                    handled = true;
                }
                if (!handled && this.currentIndex > 0) {
                    if (this.currentIndex - 1 == 0) {
                        --this.currentIndex;
                        this.setText(this.originalMessage);
                        this.editor.setCursor(10000);
                    } else {
                        --this.currentIndex;
                        this.setText(this.getMessage(this.currentIndex));
                        this.editor.setCursor(10000);
                    }
                    this.editor.setCursor(10000);
                    if (this.suggestionsElement != null) {
                        this.suggestionsElement.updateSuggestions();
                    }
                    handled = true;
                }
            }
            if (eventKey == Keyboard.KEY_ESCAPE && !(this instanceof ScreenSleepMP)) {
                this.mc.displayScreen(null);
                handled = true;
            }
            if (eventKey == Keyboard.KEY_RETURN) {
                String s = this.message.trim();
                if (s.length() > 0) {
                    String s1 = this.message.trim();
                    this.mc.thePlayer.sendChatMessage(s1);
                }
                this.mc.displayScreen(null);
                handled = true;
            }
            if (!handled) {
                this.editor.handleInput(eventKey, eventCharacter);
            }
            if (this.suggestionsElement != null) {
                this.suggestionsElement.keyTyped(eventCharacter, eventKey);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while attempting to type key!", e);
        }
    }

    public void sendMessage() {
        String s = this.message.trim();
        if (s.length() > 0) {
            String s1 = this.message.trim();
            this.mc.thePlayer.sendChatMessage(s1);
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        try {
            int emotePickerButtonColor = Integer.MIN_VALUE;
            int emotePickerTextColor = 0xE0E0E0;
            if (mx >= 2 && mx < 14 && my >= this.height - 14 && my < this.height - 2) {
                emotePickerButtonColor = -2130706433;
                emotePickerTextColor = -96;
            }
            this.drawRect(2, this.height - 14, 14, this.height - 2, emotePickerButtonColor);
            this.drawStringCenteredShadow(this.fontRenderer, Character.toString('\u263a'), 8, this.height - 12, emotePickerTextColor);
            this.drawRect(16, this.height - 14, this.width - 2, this.height - 2, Integer.MIN_VALUE);
            this.drawStringShadow(this.fontRenderer, this.suggestionsElement.getSuggestionPreview(), 16 + this.suggestionsElement.getDefaultParameterPosition(), this.mc.resolution.getScaledHeightScreenCoords() - 12, 0xFFFFFF);
            boolean drawCursor = this.updateCounter / 6 % 2 == 0;
            int cursor = this.editor.getCursor();
            this.drawStringShadow(this.fontRenderer, this.suggestionsElement.colorCodeText(this.message, true), 18, this.height - 12, 0xE0E0E0);
            if (drawCursor) {
                int width = MathHelper.ceil(this.fontRenderer.stringWidthDouble(this.message));
                if (cursor < this.message.length()) {
                    width = MathHelper.ceil(this.fontRenderer.stringWidthDouble(this.message.substring(0, cursor)));
                }
                this.drawStringShadow(this.fontRenderer, "_", 18 + width, this.height - 12, 0xE0E0E0);
            }
            if (this.showEmotePicker) {
                this.emotePicker.draw(2, this.height - 16 - this.emotePicker.getHeight(), mx, my);
            }
            super.render(mx, my, partialTick);
            if (this.suggestionsElement != null) {
                this.suggestionsElement.drawScreen();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while attempting to render chat gui!", e);
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        try {
            boolean handled = false;
            if (buttonNum == 0) {
                Character c;
                if (mx >= 2 && mx < 14 && my >= this.height - 14 && my < this.height - 2) {
                    this.showEmotePicker = !this.showEmotePicker;
                    handled = true;
                }
                if (!handled && this.showEmotePicker && (c = this.emotePicker.click(mx - 2, my - (this.height - 16 - this.emotePicker.getHeight()))) != null) {
                    this.editor.handleInput(0, c.charValue());
                    if (!Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) && !Keyboard.isKeyDown(Keyboard.KEY_RSHIFT)) {
                        this.showEmotePicker = false;
                    }
                    handled = true;
                }
                if (!handled && this.suggestionsElement != null) {
                    this.suggestionsElement.mouseClicked(mx, my, buttonNum);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while attempting to click mouse!", e);
        }
    }

    @Override
    public void setText(String text) {
        this.message = text;
    }

    @Override
    public String getText() {
        return this.message;
    }

    @Override
    public int maxLength() {
        return 256;
    }

    private String getMessage(int currentIndex) {
        return (String)this.mc.thePlayer.messageHistory.get(this.mc.thePlayer.messageHistory.size() - currentIndex);
    }
}

