/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.mobs;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.mobs.MobInfoRegistry;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class GuidebookPageMob
extends GuidebookPage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Class<? extends Entity> mobClass;
    private final MobInfoRegistry.MobInfo mobInfo;
    private final Mob example;
    private List<SlotGuidebook> slots;
    private Map<MobInfoRegistry.MobDrop, SlotGuidebook> dropSlotMap;
    private static final Minecraft mc = Minecraft.getMinecraft();
    private static final ItemElement itemElement = new ItemElement(mc);
    private static final TooltipElement tooltipElement = new TooltipElement(mc);
    private boolean discovered;

    public GuidebookPageMob(GuidebookSection section, Class<? extends Entity> mobClass, MobInfoRegistry.MobInfo mobInfo) {
        super(section);
        this.mobClass = mobClass;
        this.mobInfo = mobInfo;
        Mob example = null;
        try {
            example = (Mob)mobClass.getConstructor(World.class).newInstance(WorldClient.EMPTY_WORLD);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create example instance of mob '{}'!", (Object)mobClass.getSimpleName(), (Object)e);
        }
        this.example = example;
        if (example != null) {
            example.setSkinVariant(0);
        }
        if (mobInfo.getDrops() != null && mobInfo.getDrops().length > 0) {
            this.slots = new ArrayList<SlotGuidebook>();
            this.dropSlotMap = new HashMap<MobInfoRegistry.MobDrop, SlotGuidebook>();
            for (int i = 0; i < mobInfo.getDrops().length; ++i) {
                MobInfoRegistry.MobDrop drop = mobInfo.getDrops()[i];
                SlotGuidebook slot = new SlotGuidebook(i, 0, 0, new RecipeSymbol(drop.getStack()), false, null);
                this.slots.add(slot);
                this.dropSlotMap.put(drop, slot);
            }
        }
        this.discovered = GuidebookPageMob.mc.statsCounter.readStat(StatList.mobEncounterStats.get(EntityDispatcher.idForClass(mobClass))) > 0;
    }

    private static String[] createDescLines(FontRenderer sr, String languageKey) {
        String[] words = I18n.getInstance().translateKey(languageKey).split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            StringBuilder stringBuilder = new StringBuilder();
            if (sr.stringWidthDouble(stringBuilder.append((Object)line).append(" ").append(word).toString()) > 142.0) {
                lines.add(line.toString());
                line = new StringBuilder();
            }
            if (word.contains("\n")) {
                String safeWord = word.replace("\r", "");
                String[] wordParts = safeWord.split("\n");
                for (int i = 0; i < wordParts.length; ++i) {
                    if (i > 0) {
                        lines.add(line.toString());
                        line = new StringBuilder();
                    }
                    line.append(wordParts[i]).append(" ");
                }
                continue;
            }
            line.append(word).append(" ");
        }
        lines.add(line.toString());
        return lines.toArray(new String[0]);
    }

    @Override
    protected void renderBackground(TextureManager re, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        re.bindTexture(re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/mob.png"));
        this.drawTexturedModalRect(x, y, 0, 0, 158, 220);
    }

    @Override
    protected void renderForeground(TextureManager re, FontRenderer sr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        boolean bl = this.discovered = GuidebookPageMob.mc.statsCounter.readStat(StatList.mobEncounterStats.get(EntityDispatcher.idForClass(this.mobClass))) > 0;
        if (GuidebookPageMob.mc.thePlayer.getGamemode() == Gamemode.creative || !((Boolean)GuidebookPageMob.mc.gameSettings.hideUndiscoveredItems.value).booleanValue()) {
            this.discovered = true;
        }
        Lighting.disable();
        if (this.mobInfo != null) {
            I18n i18n = I18n.getInstance();
            String[] lines = !this.discovered ? GuidebookPageMob.createDescLines(sr, "guidebook.section.mob.undiscovered") : GuidebookPageMob.createDescLines(sr, this.mobInfo.getDescriptionTranslationKey());
            int yOffset = y + 8;
            String name = i18n.translateKey(this.mobInfo.getNameTranslationKey());
            if (!this.discovered) {
                name = new String(new char[name.length()]).replace("\u0000", "?");
            }
            this.drawStringNoShadow(sr, name, x + 66, y + 8, 0);
            if (this.discovered) {
                if (this.mobInfo.getHealth() > 0) {
                    if (this.mobInfo.getHealth() > 40) {
                        this.drawStringNoShadow(sr, i18n.translateKey("guidebook.section.mob.health"), x + 66, yOffset += 12, 0x505050);
                        yOffset += 6;
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.drawGuiIcon(x + 66, yOffset += 4, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/container"));
                        this.drawGuiIcon(x + 66, yOffset, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/full"));
                        this.drawStringNoShadow(sr, "x " + this.mobInfo.getHealth() / 2, x + 66 + 12, yOffset, 0x505050);
                    } else {
                        this.drawStringNoShadow(sr, i18n.translateKey("guidebook.section.mob.health"), x + 66, yOffset += 12, 0x505050);
                        yOffset += 6;
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        for (int i = 0; i < this.mobInfo.getHealth() / 2; ++i) {
                            if (i % 10 == 0) {
                                yOffset += 4;
                            }
                            this.drawGuiIcon(x + 66 + i % 10 * 8, yOffset, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/container"));
                            this.drawGuiIcon(x + 66 + i % 10 * 8, yOffset, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/full"));
                        }
                        if (this.mobInfo.getHealth() % 2 == 1) {
                            this.drawGuiIcon(x + 66 + this.mobInfo.getHealth() / 2 % 10 * 8, yOffset, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/container"));
                            this.drawGuiIcon(x + 66 + this.mobInfo.getHealth() / 2 % 10 * 8, yOffset, 9, 9, TextureRegistry.getTexture("minecraft:gui/hud/heart/half"));
                        }
                    }
                }
                if (this.mobInfo.getScore() > 0) {
                    this.drawStringNoShadow(sr, i18n.translateKeyAndFormat("guidebook.section.mob.score", this.mobInfo.getScore()), x + 66, yOffset += 11, 0x505050);
                }
            }
            yOffset = y + 84;
            for (String descLine : lines) {
                this.drawStringNoShadow(sr, descLine, x + 8, yOffset, 0x505050);
                yOffset += 10;
            }
            if (this.discovered && this.mobInfo.getDrops() != null && this.mobInfo.getDrops().length > 0) {
                this.drawStringNoShadow(sr, i18n.translateKey("guidebook.section.mob.drops"), x + 8, yOffset += 4, 0);
                yOffset += 12;
                for (int i = 0; i < this.mobInfo.getDrops().length; ++i) {
                    SlotGuidebook slot = this.slots.get(i);
                    slot.x = 7 + i % 7 * 21;
                    slot.y = yOffset - y + i / 7 * 20;
                    MobInfoRegistry.MobDrop drop = this.mobInfo.getDrops()[i];
                    boolean mouseOver = this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY);
                    this.drawSlot(x + 7 + i % 7 * 21, yOffset + i / 7 * 20, -1);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)50.0f);
                    itemElement.render(slot.getItemStack(), x + 8 + i % 7 * 21, yOffset + 1 + i / 7 * 20, mouseOver, slot);
                    GL11.glPopMatrix();
                    if (!slot.getIsDiscovered(GuidebookPageMob.mc.thePlayer)) continue;
                    String amountString = drop.getMinAmount() == drop.getMaxAmount() ? String.valueOf(drop.getMinAmount()) : drop.getMinAmount() + "-" + drop.getMaxAmount();
                    int width = MathHelper.ceil(sr.stringWidthDouble(amountString));
                    this.drawStringShadow(sr, amountString, x + 8 + i % 7 * 21 + 16 - width + 1, yOffset + 10 + i / 7 * 20, -1);
                }
            }
        } else {
            this.drawStringCenteredNoShadow(sr, "No results :(", x + 79, y + 110, -8355712);
        }
        this.renderMob(x, y, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onMouseDown(int x, int y, int mouseX, int mouseY, int button) {
        super.onMouseDown(x, y, mouseX, mouseY, button);
        if (this.example == null) {
            return;
        }
        if (this.discovered && mouseX > x + 9 && mouseX < x + 9 + 52 && mouseY > y + 9 && mouseY < y + 9 + 70) {
            String livingSound = this.example.getLivingSound();
            if (this.example.cycleVariant() && livingSound != null) {
                Minecraft mc = Minecraft.getMinecraft();
                Random random = new Random();
                mc.currentWorld.playSoundAtEntity(null, mc.thePlayer, livingSound, 0.25f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    private void renderMob(int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.example == null) {
            return;
        }
        if (!this.discovered) {
            return;
        }
        float heightFactor = 27.777779f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Scissor.enable(x + 9, y + 9, 52, 70);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x + 34), (float)(y + 44 + 32), (float)50.0f);
        float f1 = 30.0f;
        GL11.glScalef((float)(-f1), (float)f1, (float)f1);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f5 = (float)(x + 34) - (float)mouseX;
        float f6 = (float)(y + 44 + 32) - heightFactor * this.example.bbHeight - (float)mouseY;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Lighting.enableLight();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(f6 / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.example.yBodyRot = (float)Math.atan(f5 / 40.0f) * 20.0f;
        this.example.yRot = (float)Math.atan(f5 / 40.0f) * 40.0f;
        this.example.xRot = -((float)Math.atan(f6 / 40.0f)) * 20.0f;
        this.example.entityBrightness = 1.0f;
        GL11.glTranslatef((float)0.0f, (float)this.example.heightOffset, (float)0.0f);
        EntityRenderDispatcher.instance.viewLerpYaw = 180.0f;
        EntityRenderDispatcher.instance.renderEntityPreviewWithPosYaw(Tessellator.instance, this.example, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        GL11.glPopMatrix();
        Lighting.disable();
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        Scissor.disable();
    }

    @Override
    protected void renderOverlay(TextureManager re, FontRenderer sr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.renderOverlay(re, sr, x, y, mouseX, mouseY, partialTicks);
        if (this.slots == null) {
            return;
        }
        SlotGuidebook mouseOverSlot = null;
        for (SlotGuidebook slot : this.slots) {
            boolean showDescription;
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (mouseOverSlot == null || !mouseOverSlot.hasItem()) continue;
            boolean bl = showDescription = (Boolean)GuidebookPageMob.mc.gameSettings.alwaysShowDescriptions.value != false || GuidebookPageMob.mc.gameSettings.keyDescription.isPressed();
            String str = tooltipElement.getTooltipText(mouseOverSlot.getItemStack(), showDescription, mouseOverSlot);
            if (str.isEmpty()) continue;
            tooltipElement.render(str, mouseX, mouseY, 8, -8);
        }
    }

    public boolean getIsMouseOverSlot(Slot slot, int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + slot.x - 1 && mouseX < x + slot.x + 16 + 1 && mouseY >= y + slot.y - 1 && mouseY < y + slot.y + 16 + 1;
    }
}

