/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.keyboard.keys;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ControllerGlyphElement;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiElement;
import net.minecraft.client.gui.keyboard.ScreenKeyboard;
import net.minecraft.client.gui.keyboard.keys.BackspaceKey;
import net.minecraft.client.gui.keyboard.keys.CharKey;
import net.minecraft.client.gui.keyboard.keys.CursorKey;
import net.minecraft.client.gui.keyboard.keys.EnterKey;
import net.minecraft.client.gui.keyboard.keys.GroupKey;
import net.minecraft.client.gui.keyboard.keys.ModifierKey;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.input.controller.IButton;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public abstract class Key
extends Gui
implements GuiElement {
    protected IconCoordinate keyUp = TextureRegistry.getTexture("minecraft:gui/widgets/keyboard/key/up");
    protected IconCoordinate keyDown = TextureRegistry.getTexture("minecraft:gui/widgets/keyboard/key/down");
    protected IconCoordinate keyUpHovered = TextureRegistry.getTexture("minecraft:gui/widgets/keyboard/key/up_hovered");
    protected IconCoordinate keyDownHovered = TextureRegistry.getTexture("minecraft:gui/widgets/keyboard/key/down_hovered");
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean isDown = false;
    protected boolean isHovered = false;
    protected long holdStart = 0L;
    @Nullable
    protected ButtonEnum controllerButton = null;

    public Key() {
    }

    public Key(int x, int y, int width, int height) {
        this.setPosition(x, y, width, height);
    }

    public void onOpen(Minecraft mc, ScreenKeyboard keyboard) {
        this.isDown = false;
        this.isHovered = false;
    }

    public void render(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        boolean hovered = this.isHovered(originX, originY, mouseX, mouseY);
        if (!this.isHovered && hovered) {
            this.onFocus(mc, keyboard, originX, originY, mouseX, mouseY);
        }
        this.isHovered = hovered;
        boolean down = this.isDown(mc, keyboard);
        if (down) {
            if (hovered) {
                this.drawGuiIcon(this.x + originX, this.y + originY, this.width, this.height, this.keyDownHovered);
            } else {
                this.drawGuiIcon(this.x + originX, this.y + originY, this.width, this.height, this.keyDown);
            }
        } else if (hovered) {
            this.drawGuiIcon(this.x + originX, this.y + originY, this.width, this.height, this.keyUpHovered);
        } else {
            this.drawGuiIcon(this.x + originX, this.y + originY, this.width, this.height, this.keyUp);
        }
        if (mc.inputType == InputType.CONTROLLER && this.controllerButton != null) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glTranslatef((float)(this.x + originX + this.width - 8), (float)(this.y + originY + 1), (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            keyboard.glyphRenderer.drawGlyph(mc.controllerInput, this.controllerButton.glyph, 0, 0);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    public void onFocus(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        mc.sndManager.playSound("ui.ui_focus", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
    }

    public void onClick(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isHovered(originX, originY, mouseX, mouseY)) {
            this.pressAction(mc, keyboard, originX, originY, mouseX, mouseY);
            this.holdStart = System.currentTimeMillis();
            this.isDown = true;
        }
    }

    public void pressAction(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        mc.sndManager.playSound("ui.ui_click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        if (mc.inputType == InputType.CONTROLLER && mc.controllerInput != null) {
            mc.controllerInput.lockCursor = true;
            mc.controllerInput.hideCursor = true;
        }
    }

    public void releaseAction(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY) {
        if (mc.inputType == InputType.CONTROLLER && mc.controllerInput != null) {
            mc.controllerInput.lockCursor = false;
            mc.controllerInput.hideCursor = false;
        }
    }

    public void onRelease(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY, int mouseX, int mouseY, int mouseButton) {
        if (this.isDown && mouseButton == 0) {
            this.releaseAction(mc, keyboard, originX, originY, mouseX, mouseY);
            this.isDown = false;
        }
    }

    public void onButtonUse(Minecraft mc, ScreenKeyboard keyboard, int originX, int originY) {
        if (mc.inputType == InputType.CONTROLLER && mc.controllerInput != null && this.controllerButton != null) {
            IButton button = this.controllerButton.getButton(mc.controllerInput);
            if (button.pressedThisFrame()) {
                this.pressAction(mc, keyboard, originX, originY, (int)mc.controllerInput.cursorX, (int)mc.controllerInput.cursorY);
                this.holdStart = System.currentTimeMillis();
                this.isDown = true;
            }
            if (button.releasedThisFrame()) {
                this.releaseAction(mc, keyboard, originX, originY, (int)mc.controllerInput.cursorX, (int)mc.controllerInput.cursorY);
                this.isDown = false;
            }
        }
    }

    public Key setTextures(String keyUp, String keyDown, String keyUpHovered, String keyDownHovered) {
        this.keyUp = TextureRegistry.getTexture(keyUp);
        this.keyDown = TextureRegistry.getTexture(keyDown);
        this.keyUpHovered = TextureRegistry.getTexture(keyUpHovered);
        this.keyDownHovered = TextureRegistry.getTexture(keyDownHovered);
        return this;
    }

    public Key setControllerButton(ButtonEnum button) {
        this.controllerButton = button;
        return this;
    }

    public long getHoldTime() {
        return this.isDown ? System.currentTimeMillis() - this.holdStart : 0L;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public boolean isHovered(int originX, int originY, int mx, int my) {
        return this.x <= (mx -= originX) && mx < this.x + this.width && this.y <= (my -= originY) && my < this.y + this.height;
    }

    public boolean isDown(Minecraft mc, ScreenKeyboard keyboard) {
        return this.isDown || this.isButtonPressed(mc, keyboard);
    }

    public boolean isButtonPressed(Minecraft mc, ScreenKeyboard keyboard) {
        return mc.inputType == InputType.CONTROLLER && this.controllerButton != null && mc.controllerInput != null && this.controllerButton.getButton(mc.controllerInput).isPressed();
    }

    public int highestGroup() {
        return 0;
    }

    public static enum ButtonEnum {
        BUTTON_A(ControllerGlyphElement.Glyph.BUTTON_A, c -> c.buttonA),
        BUTTON_B(ControllerGlyphElement.Glyph.BUTTON_B, c -> c.buttonB),
        BUTTON_X(ControllerGlyphElement.Glyph.BUTTON_X, c -> c.buttonX),
        BUTTON_Y(ControllerGlyphElement.Glyph.BUTTON_Y, c -> c.buttonY),
        BUTTON_DPAD_UP(ControllerGlyphElement.Glyph.D_PAD_UP, c -> c.digitalPad.up),
        BUTTON_DPAD_LEFT(ControllerGlyphElement.Glyph.D_PAD_LEFT, c -> c.digitalPad.left),
        BUTTON_DPAD_DOWN(ControllerGlyphElement.Glyph.D_PAD_DOWN, c -> c.digitalPad.down),
        BUTTON_DPAD_RIGHT(ControllerGlyphElement.Glyph.D_PAD_RIGHT, c -> c.digitalPad.right),
        BUTTON_SHOULDER_LEFT(ControllerGlyphElement.Glyph.SHOULDER_LEFT, c -> c.buttonLeftShoulder),
        BUTTON_SHOULDER_RIGHT(ControllerGlyphElement.Glyph.SHOULDER_RIGHT, c -> c.buttonRightShoulder),
        BUTTON_STICK_LEFT(ControllerGlyphElement.Glyph.STICK_LEFT_PRESS, c -> c.joyLeft.button),
        BUTTON_STICK_RIGHT(ControllerGlyphElement.Glyph.STICK_RIGHT_PRESS, c -> c.joyRight.button),
        BUTTON_TRIGGER_LEFT(ControllerGlyphElement.Glyph.TRIGGER_LEFT, c -> c.buttonLeftTrigger),
        BUTTON_TRIGGER_RIGHT(ControllerGlyphElement.Glyph.TRIGGER_RIGHT, c -> c.buttonRightTrigger),
        BUTTON_START(ControllerGlyphElement.Glyph.BUTTON_START, c -> c.buttonStart),
        BUTTON_BACK(ControllerGlyphElement.Glyph.BUTTON_BACK, c -> c.buttonBack);

        @NotNull
        public final ControllerGlyphElement.Glyph glyph;
        @NotNull
        private final ButtonGetter buttonGetter;

        private ButtonEnum(ControllerGlyphElement.Glyph glyph, ButtonGetter buttonGetter) {
            this.glyph = glyph;
            this.buttonGetter = buttonGetter;
        }

        @NotNull
        public IButton getButton(ControllerInput controller) {
            return this.buttonGetter.apply(controller);
        }

        private static interface ButtonGetter {
            @NotNull
            public IButton apply(@NotNull ControllerInput var1);
        }
    }

    public static class Serializer
    implements JsonSerializer<Key>,
    JsonDeserializer<Key> {
        public static final Map<String, Class<? extends Key>> ID_TO_KEY_CLASS = new HashMap<String, Class<? extends Key>>();
        public static final Map<Class<? extends Key>, String> KEY_CLASS_TO_ID = new HashMap<Class<? extends Key>, String>();

        public static void registerKeyClass(String id, Class<? extends Key> keyClass) {
            assert (!ID_TO_KEY_CLASS.containsKey(id)) : "Id '" + id + "' is already assigned to class '" + ID_TO_KEY_CLASS.get(id).getSimpleName() + "'!";
            assert (!KEY_CLASS_TO_ID.containsKey(keyClass)) : "Class '" + keyClass.getSimpleName() + "' is already assigned to id '" + KEY_CLASS_TO_ID.get(keyClass) + "'!";
            ID_TO_KEY_CLASS.put(id, keyClass);
            KEY_CLASS_TO_ID.put(keyClass, id);
        }

        @Override
        public Key deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String type = json.getAsJsonObject().get("type").getAsString();
            Class<? extends Key> keyClass = ID_TO_KEY_CLASS.get(type);
            if (keyClass == null) {
                throw new JsonParseException("No assigned key class for type '" + type + "'!");
            }
            return (Key)context.deserialize(json, keyClass);
        }

        @Override
        public JsonElement serialize(Key src, Type typeOfSrc, JsonSerializationContext context) {
            return null;
        }

        static {
            Serializer.registerKeyClass("key_char", CharKey.class);
            Serializer.registerKeyClass("key_back", BackspaceKey.class);
            Serializer.registerKeyClass("key_enter", EnterKey.class);
            Serializer.registerKeyClass("key_mod", ModifierKey.class);
            Serializer.registerKeyClass("key_group", GroupKey.class);
            Serializer.registerKeyClass("key_cursor", CursorKey.class);
        }
    }
}

