/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.options.components.ToggleableOptionComponent;
import net.minecraft.client.option.OptionRange;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.client.render.window.GameWindowGLFW;

public class FramerateOptionComponent
extends ToggleableOptionComponent<Integer> {
    public FramerateOptionComponent(OptionRange option) {
        super(option);
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        if (((Boolean)FramerateOptionComponent.mc.gameSettings.enableVsync.value).booleanValue() && FramerateOptionComponent.mc.gameWindow instanceof GameWindowGLFW) {
            this.slider.sliderValue = FramerateOptionComponent.mc.gameWindow.getFrequency();
            this.slider.displayString = this.option.getDisplayStringValue();
            this.slider.enabled = false;
        } else {
            this.slider.sliderValue = (Integer)this.option.value;
            this.slider.displayString = this.option.getDisplayStringValue();
            this.slider.enabled = true;
        }
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.slider.xPosition = x + relativeButtonX;
        this.slider.yPosition = y + relativeButtonY;
        this.slider.width = buttonWidth;
        this.slider.height = buttonHeight;
        this.slider.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            FramerateOptionComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }

    @Override
    public void init(Minecraft mc) {
        this.slider.sliderValue = this.option.getValueIndex();
        if (((Boolean)mc.gameSettings.enableVsync.value).booleanValue() && mc.gameWindow instanceof GameWindowGLFW) {
            this.slider.sliderValue = mc.gameWindow.getFrequency();
            this.slider.enabled = false;
        }
        this.slider.displayString = this.option.getDisplayStringValue();
    }
}

