/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRendererFlag;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.wind.WindProvider;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class EntityRendererBoat
extends EntityRenderer<EntityBoat> {
    private final TileEntityRendererFlag flagRenderer;
    private final Minecraft mc = Minecraft.getMinecraft();

    public EntityRendererBoat() {
        super(0.5f);
        this.flagRenderer = (TileEntityRendererFlag)TileEntityRenderDispatcher.instance.getRenderer(TileEntityFlag.class);
    }

    @Override
    public void render(@NotNull Tessellator tessellator, @NotNull EntityBoat entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        float hurt = (float)entity.boatTimeSinceHit - partialTick;
        float dmg = (float)entity.boatCurrentDamage - partialTick;
        if (dmg < 0.0f) {
            dmg = 0.0f;
        }
        if (hurt > 0.0f) {
            GL11.glRotatef((float)(MathHelper.sin(hurt) * hurt * dmg / 10.0f * (float)entity.boatRockDirection), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (entity.tileEntityFlag != null) {
            WorldClient theWorld = this.mc.currentWorld;
            WindProvider theWind = theWorld.getWorldType().getWindManager();
            float windAngle = theWind.getWindDirection(theWorld, (float)x, (float)y, (float)z) * 360.0f + (180.0f - yaw);
            float boatAngle = 180.0f;
            float boatSpeed = MathHelper.sqrt_float((float)(entity.xd * entity.xd + entity.zd * entity.zd));
            float angle = MathHelper.lerp(windAngle, 180.0f, (float)MathHelper.clamp((double)boatSpeed, 0.0, 0.25) * 4.0f);
            this.flagRenderer.doRender(tessellator, entity.tileEntityFlag, -1.19, 0.187, -0.5, partialTick, false, angle, 1.0f);
        }
        TextureRegistry.blockAtlas.bind();
        float f4 = 0.75f;
        GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
        GL11.glScalef((float)1.3333334f, (float)1.3333334f, (float)1.3333334f);
        this.bindTexture("/assets/minecraft/textures/entity/boat.png");
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)-0.0625f);
        GL11.glEnable((int)32826);
        this.getModel("main").render(tessellator);
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
    }
}

